<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
import { NgModule } from '@angular/core';
import { PreloadAllModules, RouterModule, Routes } from '@angular/router';

const routes: Routes = [
<#if app.getDefaultPSAppView()??>
<#assign defaultview=app.getDefaultPSAppView()>
  {
    path: '',
    loadChildren: '@pages/${defaultview.getPSAppModule().getCodeName()?lower_case}/${srffilepath2('${defaultview.getCodeName()}')}/${srffilepath2('${defaultview.getCodeName()}')}.module#${srfclassname('${defaultview.getCodeName()}')}Module'
  },
</#if>
<#if app.getAllRefPSAppViews()??>
<#list app.getAllRefPSAppViews() as appview>
<#if appview.getViewType() == "APPINDEXVIEW" && !appview.isDefaultPage()>
  {
    path: '${appview.getPSAppModule().getCodeName()?lower_case}_${appview.codeName?lower_case}',
    loadChildren: '@pages/${appview.getPSAppModule().getCodeName()?lower_case}/${srffilepath2('${appview.getCodeName()}')}/${srffilepath2('${appview.getCodeName()}')}.module#${srfclassname('${appview.getCodeName()}')}Module'
  },
</#if>
</#list>
</#if>
  {
    path: 'login',
    loadChildren: '@components/login/login.module#LoginModule'
  },
  {
    path: '**',
    redirectTo: '',
    pathMatch: 'full'
  }
];

@NgModule({
  imports: [
    RouterModule.forRoot(routes, { preloadingStrategy: PreloadAllModules, useHash: true })
  ],
  exports: [RouterModule]
})
export class AppRoutingModule {}
