<#ibizinclude>
../@MACRO/CONTROL/CONTROL_HEADER.ts.ftl
</#ibizinclude>

    /**
     * 部件对象
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @ViewChild('${ctrl.getCodeName()}${srfclassname('${ctrl.getControlType()}')}', {static: false}) public multipleTable: any;

    /**
     * 传入url值
     *
     * @type {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private url: string = '<#ibizinclude>../@MACRO/CONTROL/URL.ts.ftl</#ibizinclude>';

    /**
     * 排序方向
     *
     * @type {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public minorSortDir: string = '<#if ctrl.getMinorSortDir()??>${ctrl.getMinorSortDir()}</#if>';

    /**
     * 排序字段
     *
     * @type {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public minorSortPSDEF: string = '<#if ctrl.getMinorSortPSDEF()??>${ctrl.getMinorSortPSDEF().getCodeName()?lower_case}</#if>';

    /**
     * 是否显示标题
     *
     * @type {boolean}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public isHideHeader: boolean = ${ctrl.isHideHeader()?c};

    /**
     * 分页条数
     *
     * @type {number}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public limit: number = ${ctrl.getPagingSize()?c};

    /**
     * 分页条数
     *
     * @returns {number}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public getLimit(): number {
        return this.limit;
    }

    /**
     * 是否禁用排序
     *
     * @returns {boolean}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public isNoSort(): boolean {
        return ${ctrl.isNoSort()?c};
    }

    /**
     * 是否启用分页
     *
     * @returns {boolean}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public isEnablePagingBar(): boolean {
        return ${ctrl.isEnablePagingBar()?c};
    }

    /**
     * 删除
     *
     * @param {any[]} datas
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public async remove(datas: any[]): Promise<any> {
        if (datas.length === 0) {
            return;
        }
        let dataInfo = '';
        datas.forEach((record: any, index: number) => {
            let srfmajortext = record.srfmajortext;
            if (index < 5) {
                if (!Object.is(dataInfo, '')) {
                    dataInfo += '、';
                }
                dataInfo += srfmajortext;
            } else {
                return false;
            }
        });

        if (datas.length < 5) {
            dataInfo = dataInfo + '共' + datas.length + '条数据';
        } else {
            dataInfo = dataInfo + '...' + '共' + datas.length + '条数据';
        }

        const removeData = () => {
            let keys: any[] = [];
            datas.forEach((data: any) => {
                keys.push(data.srfkey);
            });

            return new Promise((resolve: any, reject: any) => {
                this.removeAction({ srfkeys: keys.join(';') }).then((response: any) => {

                    if (!response || response.status !== 200) {
                        this.$notice.error('', '删除数据失败,' + response.info);
                        return;
                    } else {
                        this.$notice.success('', '删除成功!');
                    }
                    this.load({});
                    this.removeEvent.emit(null);
                    this.selections = [];
                    resolve(response);
                }).catch((response: any) => {

                    if (response && response.status === 401) {
                        return;
                    }
                    if (!response || !response.status || !response.data) {
                        this.$notice.error('错误', '系统异常');
                        reject(response);
                        return;
                    }

                    const { data: _data } = response;
                    this.$notice.error( _data.title, _data.message);
                    reject(response);
                });
            });
        }

        dataInfo = dataInfo.replace(/[null]/g, '').replace(/[undefined]/g, '').replace(/[ ]/g, '');
        this.$modal.confirm({
            nzTitle: '警告',
            nzContent: '确认要删除 ' + dataInfo + '，删除操作将不可恢复？',
            nzOnOk: () => {
                removeData();
            },
            nzOnCancel: () => { }
        });
        return removeData;
    }


    /**
     * 批量添加
     *
     * @param {*} [arg={}]
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public addBatch(arg: any = {}): void {
        if (!arg) {
            arg = {};
        }
        <#--  const post: Promise<any> = this.$http.post(this.url + this.addBatchAction, arg, this.showBusyIndicator);
        post.then((response: any) => {
            if (response.ret !== 200) {
                this.$notice.error('', '批量添加失败,' + response.info);
                return;
            }
            this.load({});
            this.addbatchEvent.emit(null);
        }).catch((response: any) => {
            if (response && response.status === 401) {
                return;
            }
            this.$notice.error('', '批量添加失败');
        });  -->
    }

    /**
     * 数据导出
     *
     * @param {*} data
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public exportExcel(data: any = {}): void {
        const arg: any = {};

        const page: any = {};
        if (!this.isNoSort && !Object.is(this.minorSortDir, '') && !Object.is(this.minorSortPSDEF, '')) {
            const sort: string[] = [this.minorSortPSDEF];
            if (Object.is(this.minorSortDir, 'ASC')) {
                Object.assign(page, { asc: sort });
            } else {
                Object.assign(page, { desc: sort });
            }
        }

        if (Object.is(data.type, 'maxRowCount')) {
            Object.assign(page, { current: 1, size: data.maxRowCount });
        } else if (Object.is(data.type, 'activatedPage')) {
            Object.assign(page, { current: this.curPage, size: this.limit });
        }
        Object.assign(arg, { page: page });

        const parentdata: any = {};
        this.beforeloadEvent.emit(parentdata);
        Object.assign(arg, parentdata);

        <#--  const post: Promise<any> = this.$http.post(this.url + 'exportdata/' + this.searchAction, arg, this.showBusyIndicator, serialnumber);
        post.then((response: any) => {
            const { serialnumber: _serialnumber } = response;
            const lastserialnumber = this.getSerialNumber('exportdata');
            if (_serialnumber && lastserialnumber && _serialnumber < lastserialnumber) {
                return;
            }

            if (!response || response.status !== 200) {
                this.$notice.error('', '数据导出失败,' + response.info);
                return;
            }
            const { data: _data } = response;
            const { records: _records } = _data;
            if (!_records || _records.length !== 1) {
                return;
            }

            const { downloadurl: _downloadurl } = _records[0];
            window.open('../' + _downloadurl, '_blank');

        }).catch((response: any) => {
            const { serialnumber: _serialnumber } = response;
            const lastserialnumber = this.getSerialNumber('exportdata');
            if (_serialnumber && lastserialnumber && _serialnumber < lastserialnumber) {
                return;
            }

            if (response && response.status === 401) {
                return;
            }
            this.$notice.error('', '数据导出失败');
        });  -->
    }

    /**
     * 生命周期
     *
     * @memberof SearchForm
     */
    ngOnInit(): void {
        if (this.viewState) {
            this.viewStateEvent = this.viewState.subscribe(({ tag, action, data }) => {
                if (!Object.is(tag, this.name)) {
                    return;
                }
                if (Object.is('load', action)) {
                    this.load(data);
                }
                if (Object.is('remove', action)) {
                    this.load(data);
                }
            });
        }
    }

    /**
     * 分页条数变化
     *
     * @param {*} $event
     * @returns {void}
     * @memberof GridService
     */
    public onPageSizeChange($event: any): void {
        if (!$event) {
            return;
        }
        if ($event === this.limit){
            return;
        }
        this.limit = $event;
        this.curPage = 1;
        this.load({});
    }

    /**
     * 页面变化
     *
     * @param {*} $event
     * @returns {void}
     * @memberof GridService
     */
    public pageOnChange($event: any): void {
        if (!$event) {
            return;
        }
        if ($event === this.curPage) {
            return;
        }
        this.curPage = $event;
        this.load({});
    }

    /**
     * 排序变化
     *
     * @param {*} order
     * @param {*} prop
     * @returns {void}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public onSortChange(order: any, prop: any): void {
        const dir = Object.is(order, 'ascend') ? 'ASC' : Object.is(order, 'descend') ? 'DESC' : '';
        if (Object.is(dir, this.minorSortDir) && Object.is(this.minorSortPSDEF, prop)) {
            return;
        }
        this.minorSortDir = dir;
        this.minorSortPSDEF = prop ? prop : '';
        this.load({});
    }

    /**
     * 界面行为
     *
     * @param {*} row
     * @param {*} tag
     * @param {*} $event
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
	public uiAction(row: any, tag: any, $event: any) {
        this.rowClick(row);
        <#if ctrl.getPSAppViewLogics()??>
        <#list ctrl.getPSAppViewLogics() as logic>
        <#if logic.getPSAppViewUIAction().getPSUIAction()??>
        <#assign action = logic.getPSAppViewUIAction().getPSUIAction()>
        if(Object.is('${action.getUIActionTag()}', tag)) {
            this.${logic.getName()}(row, tag, $event);
        }
        </#if>
        </#list>
        </#if>
    }

<#ibizinclude>
../@MACRO/CONTROL/CONTROL_BOTTOM.ts.ftl
</#ibizinclude>