import { FormItemModel } from '@global/model/form-detail';
import { Output, EventEmitter, Input } from '@angular/core';
import { DEControl } from './DEControl';
import { Subject, Subscription } from 'rxjs';

/**
 * Form部件服务类
 *
 * @export
 * @class FormControl
 */
export class FormControl extends DEControl {

    /**
     * 是否默认保存
     *
     * @type {boolean}
     * @memberof FormControl
     */
    @Input() public autosave: boolean = false;

    /**
     * 视图标识
     *
     * @type {string}
     * @memberof FormControl
     */
    @Input() public viewtag: string;

    /**
     * 加载之前
     *
     * @type {EventEmitter<any>}
     * @memberof FormControl
     */
    @Output() public saveEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 表单状态
     *
     * @type {Subject<any>}
     * @memberof FormControl
     */
    public formState: Subject<any> = new Subject();

    /**
     * 忽略表单项值变化
     *
     * @type {boolean}
     * @memberof FormControl
     */
    public ignorefieldvaluechange: boolean = false;

    /**
     * 数据变化
     *
     * @private
     * @type {Subject<any>}
     * @memberof FormControl
     */
    public dataChang: Subject<any> = new Subject();

    /**
     * 视图状态事件
     *
     * @private
     * @type {(Subscription | undefined)}
     * @memberof FormControl
     */
    public dataChangEvent: Subscription | undefined;

    /**
     * 原始数据
     *
     * @private
     * @type {*}
     * @memberof FormControl
     */
    public oldData: any = {};

    /**
     * 获取表单模型
     *
     * @returns {*}
     * @memberof FormControl
     */
    public getFormDetailModel(): any {

    }

    /**
     * 获取全部值
     *
     * @returns {*}
     * @memberof FormControl
     */
    public getValues(): any {
        return this.getData();
    }

    /**
     * 值填充
     *
     * @param {*} [_datas={}]
     * @memberof FormControl
     */
    public fillForm(_datas: any = {}): void {
        this.ignorefieldvaluechange = true;
        Object.keys(_datas).forEach((name: string) => {
            const data = this.getData();
            if (data && data.hasOwnProperty(name)) {
                data[name] = _datas[name];
            }
        });
        this.ignorefieldvaluechange = false;
    }

    /**
     * 设置表单项是否启用
     *
     * @protected
     * @param {*} data
     * @memberof FormControl
     */
    public setFormEnableCond(data: any): void {
        Object.values(this.getFormDetailModel()).forEach((detail: any) => {
            if (!Object.is(detail.detailType, 'FORMITEM')) {
                return;
            }
            const formItem: FormItemModel = detail;
            formItem.setEnableCond(data.srfuf);
        });
    }

    /**
     * 表单值变化
     *
     * @private
     * @param {{ name: string, newVal: any, oldVal: any }} { name, newVal, oldVal }
     * @returns {void}
     * @memberof FormControl
     */
    public formDataChange({ name, newVal, oldVal }: { name: string, newVal: any, oldVal: any }): void {
        if (this.ignorefieldvaluechange) {
            return;
        }
        this.resetFormData({ name: name, newVal: newVal, oldVal: oldVal });
        this.formLogic({ name: name, newVal: newVal, oldVal: oldVal });
        this.dataChang.next(JSON.stringify(this.getData()));
    }

    /**
     * 重置表单项值
     *
     * @private
     * @param {{ name: string, newVal: any, oldVal: any }} { name, newVal, oldVal }
     * @memberof FormControl
     */
    public resetFormData({ name, newVal, oldVal }: { name: string, newVal: any, oldVal: any }): void {
    }

    /**
     * 表单逻辑
     *
     * @private
     * @param {{ name: string, newVal: any, oldVal: any }} { name, newVal, oldVal }
     * @memberof FormControl
     */
    public formLogic({ name, newVal, oldVal }: { name: string, newVal: any, oldVal: any }): void {
                
    }
    
    /**
     * 表单项值变更
     *
     * @param {{ name: string, value: any }} $event
     * @returns {void}
     * @memberof FormControl
     */
    public onFormItemValueChange($event: { name: string, value: any }): void {
        if (!$event) {
            return;
        }
        const data = this.getData();
        if (!$event.name || Object.is($event.name, '') || !data.hasOwnProperty($event.name)) {
            return;
        }
        let oldVal = data[$event.name];
        data[$event.name] = $event.value;
        this.formDataChange({ name: $event.name, newVal: $event.value, oldVal: oldVal });
    }

    /**
     * 设置数据项值
     *
     * @param {string} name
     * @param {*} value
     * @returns {void}
     * @memberof FormControl
     */
    public setDataItemValue(name: string, value: any): void {
        const data = this.getData();
        if (!name || Object.is(name, '') || !data.hasOwnProperty(name)) {
            return;
        }
        if (Object.is(data[name], value)) {
            return;
        }
        let oldVal = data[name];
        data[name] = value;
        this.formDataChange({ name: name, newVal: value, oldVal: oldVal });
    }

    /**
     * 拷贝内容
     *
     * @param {*} [arg={}]
     * @memberof FormControl
     */
    public copy(arg: any = {}): void {
        this.loadDraft(arg);
    }

    /**
     * 部件刷新
     *
     * @param {any[]} args
     * @memberof FormControl
     */
    public refresh(args: any[]): void {
        let arg: any = {};
        const data = this.getData();
        if (data.srfkey && !Object.is(data.srfkey, '')) {
            Object.assign(arg, { srfkey: data.srfkey });
            this.load(arg);
            return;
        }
        if (data.srfkeys && !Object.is(data.srfkeys, '')) {
            Object.assign(arg, { srfkey: data.srfkeys });
            this.load(arg);
            return;
        }
    }

    /**
     * 自动加载
     *
     * @param {*} [arg={}]
     * @returns {void}
     * @memberof FormControl
     */
    public autoLoad(arg: any = {}): void {
        if (arg.srfkey && !Object.is(arg.srfkey, '')) {
            Object.assign(arg, { srfkey: arg.srfkey });
            this.load(arg);
            return;
        }
        if (arg.srfkeys && !Object.is(arg.srfkeys, '')) {
            Object.assign(arg, { srfkey: arg.srfkeys });
            this.load(arg);
            return;
        }
        this.loadDraft(arg);
    }

    /**
     * 加载草稿
     *
     * @param {*} [opt={}]
     * @memberof FormControl
     */
    public loadDraft(opt: any = {}): void {

    }

    /**
     * 自动保存
     *
     * @param {*} [opt={}]
     * @memberof FormControl
     */
    public autoSave(opt: any = {}): void {

    }

    /**
     * 保存
     *
     * @param {*} [opt={}]
     * @param {boolean} [showResultInfo]
     * @returns {Promise<any>}
     * @memberof FormControl
     */
    public async save(opt: any = {}, showResultInfo?: boolean): Promise<any> {

    }
}
 