import { Component, OnInit, Input, Output, EventEmitter, ViewContainerRef, ViewChild, OnDestroy, AfterViewInit } from '@angular/core';
import { AppEnvironment } from 'src/environments/AppEnvironment';
import { Subject, Subscription } from 'rxjs';
import { NzNotificationService } from 'ng-zorro-antd/notification';
import { Util } from '@global/util/util';
import { NzModalService } from 'ng-zorro-antd/modal';
import { Router, ActivatedRoute } from '@angular/router';
import { CodeList } from '@global/service/codelist/CodeList';
import { ${srfclassname('${ctrl.name}')}Control } from '@global/service/control/${srfclassname('${ctrl.name}')}Control';

<#if ctrl.getPSControls?? && ctrl.getPSControls()??>
<#list ctrl.getPSControls() as subctrl>
<#if subctrl.getControlType() != 'TOOLBAR' && subctrl.getControlType() != 'CONTEXTMENU'>
<#if subctrl.getPSDataEntity?? && subctrl.getPSDataEntity()??>
import {${srfclassname('${subctrl.name}')}} from '@widgets/${srffilepath2(subctrl.getPSDataEntity().getCodeName())}/${srffilepath2(subctrl.getCodeName())}-${subctrl.getControlType()?lower_case}/${srffilepath2(subctrl.getCodeName())}-${subctrl.getControlType()?lower_case}';
<#else>
import {${srfclassname('${subctrl.name}')}} from '@widgets/app/${srffilepath2(subctrl.getCodeName())}-${subctrl.getControlType()?lower_case}/${srffilepath2(subctrl.getCodeName())}-${subctrl.getControlType()?lower_case}';
</#if>
</#if>
</#list>
</#if>

<#if ctrl.getPSDataEntity()??>
import { DEService } from '@global/service/de/DEService';
import { ${ctrl.getPSDataEntity().getCodeName()}Service } from '@de/${ctrl.getPSDataEntity().getCodeName()}/${ctrl.getPSDataEntity().getCodeName()}Service';
</#if>
import { ${srfclassname('${ctrl.getCodeName()}')}${srfclassname('${ctrl.name}')}Mode } from './${srffilepath2(ctrl.codeName)}-${ctrl.getControlType()?lower_case}.mode';

<#if import_block??>${import_block}</#if>

@Component({
	selector: 'view_${ctrl.getName()}',
	templateUrl: './${srffilepath2(ctrl.codeName)}-${ctrl.getControlType()?lower_case}.html',
	styleUrls: ['./${srffilepath2(ctrl.codeName)}-${ctrl.getControlType()?lower_case}.less'],
})
export class ${srfclassname('${ctrl.name}')} extends ${srfclassname('${ctrl.name}')}Control implements OnInit, OnDestroy, AfterViewInit {

    <#if ctrl.getPSControls?? && ctrl.getPSControls()??>
    <#list ctrl.getPSControls() as childCtrl>
    <#if childCtrl.getControlType()??>
    <#if childCtrl.getHookEventNames()??>
    <#list childCtrl.getHookEventNames() as eventName>

    /**
     * ${childCtrl.name} 部件 ${eventName?lower_case} 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public ${childCtrl.name}_${eventName?lower_case}($event: any, $event2?: any) {
    <#if childCtrl.getPSControlLogics(eventName)??>
    <#list childCtrl.getPSControlLogics(eventName) as ctrlLogic>
    <#if ctrlLogic.getLogicType?? && ctrlLogic.getLogicType() == "APPVIEWENGINE" && ctrlLogic.getPSAppViewEngine()??>
        this.${ctrlLogic.getPSAppViewEngine().getName()}.onCtrlEvent('${childCtrl.name}', '${eventName?lower_case}', $event);
    <#else>
        <#if ctrlLogic.getEventArg()?? && ctrlLogic.getEventArg()?length gt 0>
        if (Object.is($event.tag, '${ctrlLogic.getEventArg()}')) {
            this.${ctrlLogic.name}($event, '<#if ctrlLogic.getLogicTag()?length gt 0>${ctrlLogic.getLogicTag()}</#if>', $event2);
        }
        <#else>
        this.${ctrlLogic.name}($event, '<#if ctrlLogic.getLogicTag()?length gt 0>${ctrlLogic.getLogicTag()}</#if>', $event2);
        </#if>
    </#if>
    </#list>
    </#if>
    }
    </#list>
    </#if>
    </#if>
    </#list>
    </#if>

<#if ctrl.getPSAppViewLogics?? && ctrl.getPSAppViewLogics()??>
<#list ctrl.getPSAppViewLogics() as logic>
<#if logic.getLogicTrigger() == "CUSTOM" || logic.getLogicTrigger() == "CTRLEVENT">

${P.getLogicCode(logic, "LOGIC.tsx").code}
</#if>
</#list>
</#if>

<#if ctrl.getPSUIActions?? && ctrl.getPSUIActions()??>
<#list ctrl.getPSUIActions() as uiAction>

${P.getLogicCode(uiAction, "LOGIC.tsx").code}
</#list>
</#if>

    /**
     * 构造方法
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    constructor(
        private $ctrlMode: ${srfclassname('${ctrl.getCodeName()}')}${srfclassname('${ctrl.name}')}Mode,
        private $util: Util, private $modal: NzModalService,
        private $router: Router, private $route: ActivatedRoute, 
        private $notice: NzNotificationService,
        private $codelist: CodeList
        <#if ctrl.getPSDataEntity()??>,private $deService: ${ctrl.getPSDataEntity().getCodeName()}Service</#if>
        <#if constructor_block??>${constructor_block}</#if>
    ) {
        super();
	}

    /**
     * 获取部件模型
     *
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public getControlMode() {
        return this.$ctrlMode;
    }

    <#if ctrl.getPSDataEntity()??>
    /**
     * 获取实体服务对象
     *
     * @returns
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public getDEService(): DEService{
        return this.$deService;
    }
    </#if>

    /**
     * 生命周期（页面加载完成）
     *
     * @memberof Grid
     */
    ngAfterViewInit(): void {
        <#if viewinit_block??>
        ${viewinit_block}
        </#if>
    }