<nz-table #${ctrl.getCodeName()}${srfclassname('${ctrl.getControlType()}')} 
    [nzShowPagination]="isEnablePagingBar()"
    nzShowSizeChanger 
    nzShowTotal 
    [nzData]="items"
    [nzFrontPagination]="false" 
    [nzTotal]="totalrow" 
    [nzPageIndex]="curPage" 
    [nzPageSize]="limit" 
    [nzPageSizeOptions]="[10, 20, 30, 40, 50, 100]"
    (nzPageSizeChange)="onPageSizeChange($event)"
    (nzPageIndexChange)="pageOnChange($event)"
    [ngClass]="['app-grid',isEnablePagingBar() ? 'pagination' : '']"
    >
    <thead>
        <tr>
            <th *ngIf="!isSingleSelect" nzShowCheckbox nzWidth="40px" (nzCheckedChange)="selectAll($event)"></th>
            <#assign isAddCol = true>
            <#list ctrl.getPSDEGridColumns() as column>
            <th [nzShowSort]="!isNoSort()"  (nzSortChange)="onSortChange($event, '${column.getDataItemName()?lower_case}')"<#if column.getWidthUnit()!='STAR'> nzWidth="${column.width?c}px"<#else><#assign isAddCol = false></#if> nzAlign="${column.getAlign()?lower_case}">${column.getCaption()}</th>
            </#list>
            <#if isAddCol>
            <th></th>
            </#if>
        </tr>
    </thead>
    <tbody>
        <tr *ngFor="let data of ${ctrl.getCodeName()}${srfclassname('${ctrl.getControlType()}')}.data" (click)="rowClick(data, true)" (dblclick)="rowDBLClick(data)">
            <td  *ngIf="!isSingleSelect" nzShowCheckbox [(nzChecked)]="data.isSelection" (nzCheckedChange)="select($event, data)"></td>
            <#list ctrl.getPSDEGridColumns() as column>
            <td>{{ data.${column.getDataItemName()?lower_case} }}</td>
            </#list>
        </tr>
    </tbody>
</nz-table>