import { CodeList } from '@global/service/codelist/CodeList';
import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';

@Component({
    selector: 'app-select',
    templateUrl: './app-select.html',
    styleUrls: ['./app-select.less']
})
export class AppSelect implements OnInit {

    constructor(private $codelist: CodeList) { }

    /**
     * 值项
     *
     * @memberof AppSelect
     */
    @Input()
    set value(val) {
        this.itemValue = val;
    }

    /**
     * 提示语
     *
     * @type {string}
     * @memberof AppSelect
     */
    @Input() public placeholder: string = '请选择';

    /**
     * 是否禁用
     *
     * @type {boolean}
     * @memberof AppSelect
     */
    @Input() public disabled: boolean = false;

    /**
     * 代码表标识
     *
     * @type {string}
     * @memberof AppSelect
     */
    @Input() public codeListId: string;

    /**
     * 值项
     *
     * @type {*}
     * @memberof AppSelect
     */
    public itemValue: any = null;

    /**
     * 代码表项集合
     *
     * @type {any[]}
     * @memberof AppSelect
     */
    public items: any[] = [];

    /**
     * 宽度
     *
     * @type {*}
     * @memberof AppDatePicker
     */
    @Input() public width: any;

    /**
     * 表单项之变化事件
     *
     * @memberof AppSelect
     */
    @Output() public onFormItemValueChange: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 生命周期
     *
     * @memberof AppSelect
     */
    public ngOnInit(): void {
        if (this.codeListId) {
            this.items = this.$codelist.getCodeListItems(this.codeListId);
        }
    }

    /**
     * 值变化
     *
     * @param {*} $event
     * @memberof AppSelect
     */
    public onValueChange($event) {
        this.onFormItemValueChange.emit($event);
    }

}
