import { MDControl } from './MDControl';

/**
 * Grid部件服务类
 *
 * @export
 * @class GridControl
 */
export class GridControl extends MDControl {

    /**
     * 是否开启行编辑
     *
     * @type {boolean}
     * @memberof GridControl
     */
    public isOpenEdit: boolean = false;

    /**
     * 是否禁用排序
     *
     * @returns {boolean}
     * @memberof GridControl
     */
    public isNoSort(): boolean {
        return false;
    }

    /**
     * 获取排序方向
     *
     * @returns {string}
     * @memberof GridControl
     */
    public getSortDir(): string {
        return '';
    }

    /**
     * 获取排序字段
     *
     * @returns {string}
     * @memberof GridControl
     */
    public getSort(): string {
        return '';
    }

    /**
     * 复选框数据选中
     *
     * @param {*} $event
     * @returns {void}
     * @memberof  GridControl
     */
    public select($event: any, data: any): void {
        data.isSelection = $event;
        let select: any[] = [];
        this.items.forEach((item: any) => {
            if (item.isSelection) {
                select.push(item);
            }
        });
        this.selections = [...JSON.parse(JSON.stringify(select))];
        this.selectionchangeEvent.emit(this.selections);
    }

    /**
     * 复选框数据全部选中
     *
     * @param {*} $event
     * @memberof  GridControl
     */
    public selectAll($event: any): void {
        this.items.forEach((item: any) => {
            item.isSelection = $event;
        });
        if ($event) {
            this.selections = [...JSON.parse(JSON.stringify(this.items))];
        } else {
            this.selections = [];
        }
        this.selectionchangeEvent.emit(this.selections);
    }

    /**
     * 分页刷新
     *
     * @memberof GridControl
     */
    public pageRefresh(): void {
        this.load({});
    }

    /**
     * 表格数据加载
     *
     * @param {*} [arg={}]
     * @memberof MDControlService
     */
    public load(opt: any = {}): void {
        let arg: any = {...opt};
        const page: any = {};
        if (this.isEnablePagingBar()) {
            Object.assign(page, { current: this.curPage, size: this.getLimit() });
        }
        if (!this.isNoSort() && !Object.is(this.getSortDir(), '') && !Object.is(this.getSort(), '')) {
            const sort: string[] = [this.getSort()];
            if (Object.is(this.getSortDir(), 'ASC')) {
                Object.assign(page, { asc: sort });
            } else {
                Object.assign(page, { desc: sort });
            }
        }
        Object.assign(arg, { page: page });

        const parentdata: any = {};
        this.beforeloadEvent.emit(parentdata);
        Object.assign(arg, parentdata);

        this.getAction(arg).then((result) => {
            if (Object.keys(result).length > 0) {
                this.items = JSON.parse(JSON.stringify(result.items));
                this.totalrow = result.total;
            }
            this.loadEvent.emit(this.items);
        }).catch((error) => {
            
        });
    }
}
