import { FormControl } from './FormControl';

/**
 * SearchForm部件服务类
 *
 * @export
 * @class SearchFormControl
 */
export class SearchFormControl extends FormControl {

    /**
     * 回车事件
     *
     * @param {*} $event
     * @memberof SearchFormControl
     */
    public onEnter($event: any): void {
        this.loadEvent.emit(this.getData());
    }

    /**
     * 搜索
     *
     * @memberof SearchFormControl
     */
    public onSearch() {
        this.loadEvent.emit(this.getData());
    }

    /**
     * 重置
     *
     * @memberof SearchFormControl
     */
    public onReset() {
        this.loadDraft();
    }

    /**
     * 加载数据
     *
     * @param {*} args
     * @memberof SearchFormControl
     */
    public getAction(args: any): Promise<any> {
        return new Promise((resolve, reject) => {
            const mode = this.getControlMode();
            const dataItems = mode.getDataItems();
            let result: any = { data: {} };
            dataItems.forEach(item => {
                result.data[item.name] = Object.is(item.createdv, '') ? null : item.createdv;
            });
            resolve(result);
        });
    }
}
