import { Input } from '@angular/core';
import { Http } from '@global/http/http';
import { AppControl } from './AppControl';

/**
 * AppMenu部件服务类
 *
 * @export
 * @class AppMenuControl
 */
export class AppMenuControl extends AppControl {

    /**
     * 菜单数据
     *
     * @private
     * @type {any[]}
     * @memberof AppMenuControl
     */
    public menus: any[] = [];

    /**
     * 菜单收缩改变
     *
     * @type {boolean}
     * @memberof AppMenuControl
     */
    @Input() public collapsechange: boolean = true;

    /**
     * 当前模式，菜单在顶部还是在底部
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Input() public mode: any;

    /**
     * 是否默认视图
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Input() public isDefaultPage: boolean = false;

    /**
     * 默认打开视图
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Input() public defPSAppView: any;

    /**
     * 获取请求地址
     *
     * @returns {string}
     * @memberof AppMenuControl
     */
    public getUrl(): string {
        return '';
    }

    /**
     * 获取请求对象
     *
     * @returns {Http}
     * @memberof AppMenuControl
     */
    public getHttp(): Http {
        return null;
    }

    /**
     * 数据加载
     *
     * @param {*} data
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public load(data: any) {
        this.getAction({}).then((result) => {
            this.menus = result.items;
        }).catch((error) => {
            // this.$notice.error('错误', error.message);
        });
    }

    /**
     * get行为
     *
     * @param {*} args
     * @memberof AppMenuControl
     */
    public getAction(args: any): Promise<any> {
        return new Promise((resolve, reject) => {
            this.getHttp().get(this.getUrl() + '/get', args).then((response) => {
                resolve(response);
            }).catch((error) => {
                reject(error);
            });
        });
      }
}
