import { CodeList } from '@global/service/codelist/CodeList';
import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';

@Component({
    selector: 'app-radio',
    templateUrl: './app-radio.html',
    styleUrls: ['./app-radio.less']
})
export class AppRadio implements OnInit {

    constructor(private $codelist: CodeList) { }

    /**
     * 值项
     *
     * @memberof AppRadio
     */
    @Input()
    set value(val) {
        this.itemValue = val;
    }

    /**
     * 是否禁用
     *
     * @type {boolean}
     * @memberof AppRadio
     */
    @Input() public disabled: boolean = false;

    /**
     * 代码表标识
     *
     * @type {string}
     * @memberof AppRadio
     */
    @Input() public codeListId: string;

    /**
     * 值项
     *
     * @type {*}
     * @memberof AppRadio
     */
    public itemValue: any = null;

    /**
     * 代码表项集合
     *
     * @type {any[]}
     * @memberof AppRadio
     */
    public items: any[] = [];

    /**
     * 宽度
     *
     * @type {*}
     * @memberof AppRadio
     */
    @Input() public width: any;

    /**
     * 表单项之变化事件
     *
     * @memberof AppRadio
     */
    @Output() public onFormItemValueChange: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 生命周期
     *
     * @memberof AppRadio
     */
    public ngOnInit(): void {
        if (this.codeListId) {
            this.items = this.$codelist.getCodeListItems(this.codeListId);
        }
    }

    /**
     * 值变化
     *
     * @param {*} $event
     * @memberof AppRadio
     */
    public onValueChange($event) {
        this.onFormItemValueChange.emit($event);
    }

}
