import { Input, Output, EventEmitter } from '@angular/core';
import { Subject, Subscription } from 'rxjs';

/**
 * 部件服务类
 *
 * @export
 * @class Control
 */
export class Control {
    
    /**
     * 名称
     *
     * @type {string}
     * @memberof Control
     */
    @Input() public name: string;

    /**
     * 视图通讯对象
     *
     * @type {Subject<ViewState>}
     * @memberof Control
     */
    @Input() public viewState: Subject<ViewState>;

    /**
     * 视图状态事件
     *
     * @type {(Subscription | undefined)}
     * @memberof Control
     */
    public viewStateEvent: Subscription | undefined;

    /**
     * 加载之前
     *
     * @type {EventEmitter<any>}
     * @memberof Control
     */
    @Output() public beforeloadEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 加载完成
     *
     * @type {EventEmitter<any>}
     * @memberof Control
     */
    @Output() public loadEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 删除成功
     *
     * @type {EventEmitter<any>}
     * @memberof Control
     */
    @Output() public removeEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 获取多项数据
     *
     * @returns {any[]}
     * @memberof Control
     */
    public getDatas(): any[] {
        return [];
    }

    /**
     * 获取单项树
     *
     * @returns {*}
     * @memberof Control
     */
    public getData(): any {
        return null;
    }

    /**
     * 生命周期（销毁）
     *
     * @memberof Control
     */
    public ngOnDestroy(): void {
        if (this.viewStateEvent) {
            this.viewStateEvent.unsubscribe();
        }
    }

    /**
     * 获取部件模型
     *
     * @memberof Control
     */
    public getControlMode() {
        return null;
    }

    /**
     * 数据加载
     *
     * @param {*} [arg={}]
     * @memberof Control
     */
    public load(opt: any = {}): void {

    }

    /**
     * 部件刷新
     *
     * @param {any[]} args
     * @memberof Control
     */
    public refresh(args: any[]): void {
        this.load(args);
    }

}
