<#assign destroyed_block>
<#if ctrl.getPSSysCounter?? && ctrl.getPSSysCounter()??>
<#assign sysCounter = ctrl.getPSSysCounter()/>
if(this.${sysCounter.getCodeName()}) {
    this.${sysCounter.getCodeName()}.uiCounterData.unsubscribe();
    this.${sysCounter.getCodeName()}.close();
}
</#if>
</#assign>
<#assign import_block>
import { Http } from '@global/http/http';
</#assign>
<#assign constructor_block>, private $http: Http</#assign>

<#ibizinclude>
../@MACRO/CONTROL/CONTROL_HEADER.ts.ftl
</#ibizinclude>

    /**
     * 获取多项数据
     *
     * @returns {any[]}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public getDatas(): any[] {
        return [];
    }

    /**
     * 获取单项树
     *
     * @returns {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public getData(): any {
        return null;
    }

    /**
     * api地址
     *
     * @private
     * @type {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private url: string = '${app.getPKGCodeName()?lower_case}/ctrl/${ctrl.codeName?lower_case}appmenu';

    /**
     * 应用功能集合
     *
     * @type {any[]}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public appFuncs: any[] = [
        <#list ctrl.getPSAppFuncs() as appFuncs>
        {
            appfunctag: '${appFuncs.getCodeName()}',
            appfuncyype: '${appFuncs.getAppFuncType()}',
            <#if appFuncs.getAppFuncType() == 'APPVIEW'>
            <#assign appview = appFuncs.getPSAppView()/>
            pathname: '${appview.getPSAppModule().getCodeName()?lower_case}_${appview.getCodeName()?lower_case}',
            </#if>
        },
        </#list>
    ];

    <#if ctrl.getPSSysCounter?? && ctrl.getPSSysCounter()??>
    <#assign sysCounter = ctrl.getPSSysCounter()/>
    
    /**
     * 计数器对象
     *
     * @type {(UICounter | null)}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public ${sysCounter.getCodeName()}: UICounter | null = null;

    /**
     * 计数器数据
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public counterdata: any = {};
    </#if>

    /**
     * 获取请求地址
     *
     * @returns {string}
     * @memberof AppMenuService
     */
    public getUrl(): string {
        return this.url;
    }

    /**
     * 获取请求对象
     *
     * @returns {Http}
     * @memberof AppMenuService
     */
    public getHttp(): Http {
        return this.$http;
    }

    /**
     * 生命周期
     *
     * @private
     */
	ngOnInit() {
        <#if ctrl.getPSSysCounter?? && ctrl.getPSSysCounter()??>
        <#assign sysCounter = ctrl.getPSSysCounter()/>
        this.${sysCounter.getCodeName()} = new UICounter({
            name: '${sysCounter.getCodeName()}',
            counterId: '${sysCounter.id}',
            timer: ${sysCounter.timer?c},
            url: `${r'${this.url}'}/get${sysCounter.codeName?lower_case}counter`,
        });
        this.${sysCounter.getCodeName()}.uiCounterData.subscribe((data: any) => {
            this.counterdata = {};
            Object.assign(this.counterdata, data);
        });
        </#if>
        if (this.viewState) {
            this.viewStateEvent = this.viewState.subscribe(({ tag, action, data }) => {
                if (!Object.is(tag, this.name)) {
                    return;
                }
                this.load(data);
            });
        }
	}

    /**
     * 菜单点击
     *
     * @private
     * @param {*} item 菜单数据
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private click(item: any) {
        if (item) {
            switch (item.appfunctag) {
                <#if ctrl.getPSAppFuncs()??>
                <#assign appFuncs = ctrl.getPSAppFuncs()>
                <#list appFuncs as singFuncs>
                case '${singFuncs.getCodeName()}': 
                    this.click${singFuncs.codeName}(item);
                    return;
                </#list>
                </#if>
                default:
                    console.warn('未指定应用功能');
            }
        }
    }

<#if ctrl.getPSAppFuncs()??>
<@ibizindent blank=4>
<#list ctrl.getPSAppFuncs() as singleFuncs>

${P.getLogicCode(singleFuncs,"LOGIC.tsx").code}
</#list>
</@ibizindent>
</#if>

<#ibizinclude>
../@MACRO/CONTROL/CONTROL_BOTTOM.ts.ftl
</#ibizinclude>