import { DEService } from './../de/DEService';
import { Control } from './Control';

/**
 * 实体部件-服务类
 *
 * @export
 * @class DEControl
 */
export class DEControl extends Control {

    /**
     * 获取实体服务对象
     *
     * @returns
     * @memberof DEControlService
     */
    public getDEService(): DEService {
        return null;
    }

    /**
     * 加载数据
     *
     * @param {*} args
     * @memberof ControlService
     */
    public getAction(args: any): Promise<any> {
        return new Promise((resolve, reject) => {
            this.getDEService().getAction(args, this.getControlMode()).then((result: any) => {
                resolve(result);
            }).catch((error) => {
                reject(error);
            });
        });
    }

    /**
     * 更新数据
     *
     * @param {*} args
     * @memberof ControlService
     */
    public updateAction(args: any): Promise<any> {
        return new Promise((resolve, reject) => {
            this.getDEService().updateAction(args, this.getControlMode()).then((result: any) => {
                resolve(result);
            }).catch((error) => {
                reject(error);
            });
        });
    }

    /**
     * 删除数据
     *
     * @param {ang} args
     * @returns {Promise<any>}
     * @memberof DEControlService
     */
    public removeAction(args: any): Promise<any> {
        return new Promise((resolve, reject) => {
            this.getDEService().removeAction(args).then((result: any) => {
                resolve(result);
            }).catch((error) => {
                reject(error);
            });
        });
    }
}
