import { CodeList } from '@global/service/codelist/CodeList';
import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';

@Component({
    selector: 'app-checkbox-list',
    templateUrl: './app-checkbox-list.html',
    styleUrls: ['./app-checkbox-list.less']
})
export class AppCheckboxList implements OnInit {

    constructor(private $codelist: CodeList) { }

    /**
     * 值项
     *
     * @memberof AppCheckboxList
     */
    @Input()
    set value(val) {
        if (val && this.items.length > 0) {
            if (Object.is(this.mode, 'num')) {
                let num: number = parseInt(val, 10);
                this.items.forEach((item: any) => {
                    if ((num & item.value) == item.value) {
                        item.checked = true;
                    }
                });
            } else if (!this.mode || Object.is(this.mode, 'str')) {
                let datas: any[] = val.split(this.separator ? this.separator : ';');
                datas.forEach(data => {
                    let item = this.items.find((obj) => (obj.value == data));
                    if (item) {
                        item.checked = true;
                    }
                });
            }
        }
    }

    /**
     * 是否禁用
     *
     * @type {boolean}
     * @memberof AppCheckboxList
     */
    @Input() public disabled: boolean = false;

    /**
     * 代码表标识
     *
     * @type {string}
     * @memberof AppCheckboxList
     */
    @Input() public codeListId: string;

    /**
     * 值项
     *
     * @type {*}
     * @memberof AppCheckboxList
     */
    public itemValue: any = null;

    /**
     * 代码表项集合
     *
     * @type {any[]}
     * @memberof AppCheckboxList
     */
    public items: any[] = [];

    /**
     * 宽度
     *
     * @type {*}
     * @memberof AppCheckboxList
     */
    @Input() public width: any;

    /**
     * 模式（数字或者字符串）
     *
     * @type {*}
     * @memberof AppCheckboxList
     */
    @Input() mode: any;

    /**
     * 分隔符
     *
     * @type {*}
     * @memberof AppCheckBox
     */
    @Input() separator: any;

    /**
     * 表单项之变化事件
     *
     * @memberof AppCheckboxList
     */
    @Output() public onFormItemValueChange: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 生命周期
     *
     * @memberof AppCheckboxList
     */
    public ngOnInit(): void {
        if (this.codeListId) {
            let datas = this.$codelist.getCodeListItems(this.codeListId);
            if (!datas) {
                return;
            }
            datas = JSON.parse(JSON.stringify(datas));
            this.items = datas.map(data => {
                return { ...data, checked: false };
            });
        }
    }

    /**
     * 值变化
     *
     * @param {*} $event
     * @memberof AppCheckboxList
     */
    public onValueChange() {
        let data = null;
        if (Object.is(this.mode, 'num')) {
            this.items.forEach(item => {
                if (!item.checked) {
                    return;
                }
                data = 0 | parseInt(item.value, 10);
            });
        } else if (!this.mode || Object.is(this.mode, 'str')) {
            let datas: any[] = [];
            this.items.forEach(item => {
                if (!item.checked) {
                    return;
                }
                datas.push(item.value);
            });
            data = datas.join(this.separator ? this.separator : ';');
        }
        console.log(data);
        this.onFormItemValueChange.emit(data);
    }

}
