import { Injectable } from '@angular/core';
import { CodeLists } from '@assets/datas/CodeLists';

/**
 * 代码表服务对象
 *
 * @export
 * @class CodeList
 */
@Injectable({ providedIn: 'root' })
export class CodeList {

    /**
     * 获取代码表对象
     *
     * @returns
     * @memberof CodeList
     */
    public getCodeList(codeListId: string) {
        if (!codeListId) {
            return null;
        }
        return CodeLists[codeListId];
    }

    /**
     * 获取代码表项
     *
     * @param {string} codeListId
     * @returns
     * @memberof CodeList
     */
    public getCodeListItems(codeListId: string) {
        if (!codeListId) {
            return [];
        }
        return this.getCodeList(codeListId).items;
    }
}
