import { Input, Output, EventEmitter } from '@angular/core';
import { DEControl } from './DEControl';

/**
 * 多数据部件服务类
 *
 * @export
 * @class MDControl
 */
export class MDControl extends DEControl {

    /**
     * 选中行数据
     *
     * @type {any[]}
     * @memberof MDControl
     */
    public selections: any[] = [];

    /**
     * 当前页
     *
     * @type {number}
     * @memberof MDControl
     */
    public curPage: number = 1;

    /**
     * 数据
     *
     * @type {any[]}
     * @memberof MDControl
     */
    public items: any[] = [];

    /**
     * 总条数
     *
     * @type {number}
     * @memberof MDControl
     */
    public totalrow: number = 0;

    /**
     * 是否单选
     *
     * @type {boolean}
     * @memberof MDControl
     */
    @Input() public isSingleSelect?: boolean;

    /**
     * 批量添加
     *
     * @type {EventEmitter<any>}
     * @memberof MDControl
     */
    @Output() public addbatchEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 选中变化
     *
     * @type {EventEmitter<any>}
     * @memberof MDControl
     */
    @Output() public selectionchangeEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 行双击
     *
     * @type {EventEmitter<any>}
     * @memberof MDControl
     */
    @Output() public rowdblclickEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 是否启用分页
     *
     * @returns {boolean}
     * @memberof MDControl
     */
    public isEnablePagingBar(): boolean {
        return true;
    }

    /**
     * 分页条数
     *
     * @returns {boolean}
     * @memberof MDControl
     */
    public getLimit(): number {
        return 20;
    }

    /**
     * 获取多项数据
     *
     * @returns {any[]}
     * @memberof MDControl
     */
    public getDatas(): any[] {
        return this.selections;
    }
    
    /**
     * 获取单项树
     *
     * @returns {*}
     * @memberof MDControl
     */
    public getData(): any {
        if (this.selections.length > 0) {
            return this.selections[0];
        } else {
            return null;
        }   
    }

    /**
     * 部件刷新
     *
     * @param {any[]} args
     * @memberof MDControl
     */
    public refresh(args: any[]): void {
        this.load(args);
    }

    /**
     * 获取选中行数据
     *
     * @returns {any[]}
     * @memberof MDControl
     */
    public getSelection(): any[] {
        return this.selections;
    }

    /**
     * 行双击事件
     *
     * @param {*} $event
     * @returns {void}
     * @memberof MDControl
     */
    public rowDBLClick($event: any): void {
        if (!$event) {
            return;
        }
        let data = JSON.parse(JSON.stringify($event));
        this.rowdblclickEvent.emit([data]);
    }

    /**
     * 单击选中
     *
     * @param {*} $event
     * @returns {void}
     * @memberof MDControl
     */
    public rowClick($event: any, clear?: boolean): void {
        if (!$event) {
            return;
        }
        if (this.isSingleSelect || clear) {
            this.items.forEach((item: any) => {
                item.isSelection = false;
            });
        }
        $event.isSelection = true;
        this.selections = [];
        this.selections.push(JSON.parse(JSON.stringify($event)));
        this.selectionchangeEvent.emit(this.selections);
    }
}
