import Jsonp from '@global/http/jsonp';

/**
 * 实体服务类
 *
 * @export
 * @class DEService
 */
export class DEService {

    /**
     * 模拟请求数据对象
     *
     * @type {Jsonp}
     * @memberof DEService
     */
    public $jsonp: Jsonp = new Jsonp();

    /**
     * 获取实体名称
     *
     * @returns {string}
     * @memberof DEService
     */
    public getName(): string {
        return '';
    }

    /**
     * 获取数据api地址
     *
     * @returns {string}
     * @memberof DEService
     */
    public getApi(): string {
        return '';
    }

    /**
     * 删除数据api地址
     *
     * @returns {string}
     * @memberof DEService
     */
    public removeApi(): string {
        return '';
    }

    /**
     * get行为
     *
     * @param {*} args
     * @memberof DEService
     */
    public getAction(args: any, mode: any): Promise<any> {
        return new Promise((resolve, reject) => {
            this.$jsonp.jsonp(this.getApi(), { callbackName: this.getName() }).then((response: any) => {
                let result: any = {};
                if (args.srfkey) {
                    let data = response.find((item) => Object.is(args.srfkey, item[this.getName() + 'id']));
                    Object.assign(result, { data: data });
                    result = this.outputResult(result, mode);
                    if (data) {
                        Object.assign(result.data, { srfuf: '1' });
                    }
                } else {
                    let items = [];
                    if (args.page) {
                        let current = args.page.current ? args.page.current : 1;
                        let size = args.page.size ? args.page.size : 20;
                        response.forEach((item, index) => {
                            if (index >= (current - 1) * size && index < current * size) {
                                items.push(item);
                            }
                        });
                    } else {
                        items = response;
                    }
                    Object.assign(result, { items: items, total: response.length });
                    result = this.outputResult(result, mode);
                }
                resolve(result);
            }).catch((error: any) => {
                reject(error);
            });
        });
    }

    /**
     * update行为
     *
     * @param {*} args
     * @memberof DEService
     */
    public updateAction(args: any, mode: any): Promise<any> {
        return new Promise((resolve, reject) => {
            console.log('未实现');
        });
    }

    /**
     * update行为
     *
     * @param {*} args
     * @memberof DEService
     */
    public removeAction(args: any): Promise<any> {
        return new Promise((resolve, reject) => {
            console.log('未实现');
        });
    }

    /**
     * 处理返回实体数据
     *
     * @param {*} result
     * @returns {*}
     * @memberof DEService
     */
    public outputResult(result: any, mode: any): any {
        const items = [];
        if (result.items) {
            result.items.forEach((item: any) => {
                let data = this.setResultData(item, mode);
                items.push(data);
            });
            result.items = items;
        } else if (result.data) {
            result.data = this.setResultData(result.data, mode);
        }
        return result;
    }

    /**
     * 设置返回结果对象
     *
     * @param {*} item
     * @param {*} mode
     * @returns {*}
     * @memberof DEService
     */
    public setResultData(item: any, mode: any): any {
        if (!mode) {
            return item;
        }
        let data: any = {};
        let dataItems: any[] = mode.getDataItems();
        dataItems.forEach(dataitem => {
            let val = item.hasOwnProperty(dataitem.prop) ? item[dataitem.prop] : null;
            switch (dataitem.dataType) {
                case 'FLOAT': val = 100.00; break;
                case 'DECIMAL': val = 100; break;
                case 'INT': val = 100; break;
                case 'YESNO': val = 0; break;
                case 'DATE': val = '2019-8-8'; break;
                case 'TIME': val = '12:30:54'; break;
                case 'DATETIME': val = '2019-8-8 12:30:54'; break;
                case 'SSCODELIST': val = null; break;
                case 'NSCODELIST': val = null; break;
                case 'NMCODELIST': val = null; break;
                case 'SMCODELIST': val = null; break;
            }
            if (val == null && dataitem.updatedv) {
                data[dataitem.name] = dataitem.updatedv;
            } else {
                data[dataitem.name] = val;
            }
        });
        return data;
    }
}
