<#--  后台界面行为  -->
<#if backend_block??>
${backend_block}
<#else>
    /**
     * ${item.getCaption()}
     *
     * @param {any[]} args
     * @param {*} [params]
     * @param {*} [$event]
     * @param {*} [xData]
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${view.name}')}
     */
    public ${item.getFullCodeName()}(args: any[], params?: any, $event?: any, xData?: any): Promise<any> {
<#if item.getActionTarget() == 'SINGLEDATA'>
        return new Promise((resolve: any, reject: any) => {
            this.$Notice.error({ title: '错误', desc: '不支持单项数据' });
        });
<#elseif item.getActionTarget() == 'MULTIDATA'>
        return new Promise((resolve: any, reject: any) => {
            this.$Notice.error({ title: '错误', desc: '不支持多项数据' });
        });
<#else>
        // BACKEND
        const url: string = '${app.getPKGCodeName()?lower_case}/${item.getPSDataEntity().getPSSystemModule().codeName?lower_case}/${item.getPSDataEntity().codeName?lower_case}/uiaction/${item.getCodeName()?lower_case}';
        const data: any = { srfparentdata: {} };
    
        const _this: any = this;
        if (_this.srfparentdata) {
            Object.assign(data.srfparentdata, _this.srfparentdata);
        }

    <#if item.getActionTarget() == 'SINGLEKEY'>

        <#--  单项数据主键  -->
        if (args.length > 0) {
            Object.assign(data, { srfkey: args[0].srfkey });
        }

        // 值项名称 - 单项数据主键，默认为srfkey
        const valueItem: string = '<#if item.getValueItem?? && item.getValueItem() != ''>${item.getValueItem()}<#else>srfkey</#if>';
        // 数据项名称 - 单项数据主键，默认为srfkey
        const paramItem: string = '<#if item.getParamItem?? && item.getParamItem() != ''>${item.getParamItem()}<#else>srfkey</#if>';
        if (args.length > 0 && args[0].hasOwnProperty(valueItem)) {
            const _params2: any = {};
            Object.assign(_params2, { [paramItem]: args[0][valueItem] });
            // 参数层级处理
            if (Object.is(paramItem, 'srfkey')) {
                Object.assign(data, _params2);
            } else {
                Object.assign(data.srfparentdata, _params2);
            }
            // 非默认值转换 删除原始值
            if (Object.is(valueItem, 'srfkey') && !Object.is(paramItem, 'srfkey')) {
                delete data.srfkey;
            }
        }
    </#if>
    <#if item.getActionTarget() == 'MULTIKEY'>

        <#--  多项数据主键  -->
        let keys: string[] = [];
        args.forEach((arg: any) => {
            if (arg.srfkey) {
                keys.push(arg.srfkey);
            }
        });
        if (keys.length > 0) {
            Object.assign(data, { srfkeys: keys.join(';') });
        }

        // 值项名称 -  多项数据主键，默认为srfkey
        const valueItem: string = '<#if item.getValueItem?? && item.getValueItem() != ''>${item.getValueItem()}<#else>srfkey</#if>';
        // 数据项名称 - 多项数据主键，默认为srfkeys
        const paramItem: string = '<#if item.getParamItem?? && item.getParamItem() != ''>${item.getParamItem()}<#else>srfkeys</#if>';
        const _params2: any = {};
        let _keys: string[] = [];
        args.forEach((arg: any) => {
            if (arg.hasOwnProperty(valueItem)) {
                _keys.push(arg[valueItem]);
            }
        });

        Object.assign(_params2, { [paramItem]: _keys.join(';') });
        // 参数层级处理
        if (Object.is(paramItem, 'srfkeys')) {
            Object.assign(data, _params2);
        } else {
            Object.assign(data.srfparentdata, _params2);
        }
    </#if>

        if (params && Object.keys(params).length > 0) {
            const _params: any = {};
            const arg: any = args[0];
            Object.keys(params).forEach((name: string) => {
                if (!name) {
                    return;
                }
                let value: string | null = params[name];
                if (value && value.startsWith('%') && value.endsWith('%')) {
                    const key = value.substring(1, value.length - 1);
                    if (arg && arg.hasOwnProperty(key)) {
                        value = (arg[key] !== null && arg[key] !== undefined) ? arg[key] : null;
                    } else {
                        value = null;
                    }
                }
                Object.assign(_params, { [name]: value });
            });
            Object.assign(data.srfparentdata, _params);
        }

        return new Promise((resolve: any, reject: any) => {
            const backend = () => {
                this.$http.post(url, data, ${item.isShowBusyIndicator()?c}).then((response: any) => {
                    if (!response || response.status !== 200) {
                        this.$Notice.error({ title: '错误', desc: response.message });
                        return;
                    }
                    <#if item.getSuccessMsg?? && item.getSuccessMsg()??>
                    this.$Notice.success({ title: '成功', desc: '${item.getSuccessMsg()}' });
                    </#if>

                    const _this: any = this;
                    <#--  是否重新加载数据  -->
                    <#if item.isReloadData?? && item.isReloadData()>
                    if (xData && xData.refresh && xData.refresh instanceof Function) {
                        xData.refresh(args);
                    } else if (_this.refresh && _this.refresh instanceof Function) {
                        _this.refresh(args);
                    }
                    </#if>
                    <#--  后续界面行为  -->
                    <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                    <#assign nextPSUIAction = item.getNextPSUIAction()/>
                    const { data: result } = response;
                    let _args: any[] = [];
                    if (Object.is(this.$util.typeOf(result), 'array')) {
                        _args = [...result];
                    } else if (Object.is(this.$util.typeOf(result), 'object')) {
                        _args = [{...result}];
                    } else {
                        _args = [...args];
                    }
                    if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        _this.${nextPSUIAction.getFullCodeName()}(_args, params, $event, xData);
                    }
                    </#if>
                    resolve(response);
                }).catch((response: any) => {
                    if (!response || !response.status || !response.data) {
                        this.$Notice.error({ title: '错误', desc: '系统异常！' });
                        return;
                    }
                    if (response.status === 401) {
                        return;
                    }
                    const { data: _data } = response;
                    this.$Notice.error({ title: _data.title, desc: _data.message });
                    reject(response);
                });
            };
        <#if item.getFrontPSAppView(view)??>
        <#assign frontview = item.getFrontPSAppView(view)>
            <#if frontview.getOpenMode()?index_of('DRAWER') == 0>
            const view: any = {
                viewname: '${srffilepath2(frontview.getCodeName())}',
                title: '${frontview.title}',
                height: ${frontview.getHeight()?c},
                width: ${frontview.getWidth()?c},
                placement: '${frontview.getOpenMode()}'
            };
            const appdrawer = this.$appdrawer.openDrawer(view, data);
            appdrawer.subscribe((result: any) => {
                if (result && Object.is(result.ret, 'OK')) {
                    Object.assign(data, { srfactionparam: result.datas });
                    backend();
                }
            });
            <#else>
            const view = { 
                viewname: '${srffilepath2(frontview.getCodeName())}', 
                title: '${frontview.title}', 
                height: ${frontview.getHeight()?c}, 
                width: ${frontview.getWidth()?c}, 
            };
            const appmodal = this.$appmodal.openModal(view, data);
            appmodal.subscribe((result:any) => {
                if (result && Object.is(result.ret, 'OK')) {
                    Object.assign(data, { srfactionparam: result.datas });
                    backend();
                }
            });
            </#if>
        <#elseif item.getConfirmMsg?? && item.getConfirmMsg()??>
            this.$Modal.confirm({
                title: '警告',
                content: '${item.getConfirmMsg()}',
                onOk: () => {
                    backend();
                },
                onCancel: () => { }
            });
        <#else>
            backend();
        </#if>
        });

</#if>
    }
</#if>