# Angular R6 模板


（技术引用链接）

- [Angular官方文档](https://www.angular.cn/)
- [TypeScript官方文档](http://www.typescriptlang.org/docs/home.html)
- [iBizSys模型api文档](https://modelapi.ibizlab.cn/)

## 介绍

Angular R6 是 iBizSys 基于 Angualr8.x 搭建的一套前端模板。该模板主要是为开发人员提供一套模板基础结构，开发人员克隆该模板进行扩展使用。

<div class="pic-plus">
  <img width="300" height="120" src="https://doc.ibizlab.cn/images/angular_r6_templ/freemarker-logo.png">
  <span>+</span>
  <img width="150" height="150" src="https://doc.ibizlab.cn/images/angular_r6_templ/angular.jpg">
  <span>+</span>
  <img width="150" height="150" src="https://doc.ibizlab.cn/images/angular_r6_templ/typescript-logo.png">
</div>

### 特性

- 使用 FreeMarker 模板引擎发布成果文件
- 以 Angular 为前端技术框架 
- 集成了高质量UI组件 antd 和图标库 Font Awesome 
- 使用 TypeScript 中 ts 、Less 构建成果文件，样式与逻辑分离

### 支持环境

- 现代浏览器和 IE11 及以上

## 文档

可以通过[Angular R6文档](http://172.16.180.231/wx/angular_r6/)来了解 Angular R6。

## 搭建Demo

我们将通过搭建一个简单的Demo来描述Angular R6模板的使用。

### 建立模板

在使用 Angular R6 前端模板时应该 [Fork](https://docs.gitlab.com/ee/gitlab-basics/fork-project.html) 一份属于自己的模板来进行扩展使用。

### 创建模块

创建一个对实体或视图进行功能分类的独立命名单位。

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/create_module.png)

### 建立实体

建立一个测试数据模型来实现业务交互的逻辑展现。

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/create_entity.png)

实体建立完成以后可以在此查看实体模型的一些默认属性等信息。

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/entity_info.png)

### 设置前端应用发布模板

这里我们选用创建应用时会默认生成一个前端应用来做demo测试。选择模板时请选择自己 Fork 出来的模板，这里我们就选择 ANGULAR_R6 作为前端技术模板，选择 angular_r6_templ 分支作为前端应用样式。

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/set_template.png)

### 创建菜单

1. 建立一个应用程序的顶级菜单栏。

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/create_appmenu.png)

2. 建立以后，打开菜单设计界面。添加菜单项成员。

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/add_menuitem.png)

3. 为菜单项添加应用功能（选择报销单(BXD)实体的实体表格视图作为打开的应用视图）。

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/add_func.png)

4. 保存

### 创建首页视图

1. 建立应用默认首页视图（应用默认顶级打开视图）。

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/create_indexview.png)

2. 打开首页视图设计界面，在“配置”里面设置应用菜单。

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/set_indexview.png)

3. 保存

### 发布模型

以上就是一个简单的demo应用的配置，然后执行一键发布，将 IBizSys 平台所配置的数据模型按照 Angular R6 模板的结构生成代码文件。

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/publish.png)

## 模板成果物预览

iBizSys 提供了即时预览，可以让您在编写模板的同时预览到最终成果物 [查看更多模板编写小技巧](http://bbs.ibizlab.cn/)

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/preview_result.png)

### 项目结构说明

[项目结构说明](http://172.16.180.231/wx/angular_r6/docs/project-structure/project-structure.html)

### 应用顶级路由
 
![produce](https://doc.ibizlab.cn/images/angular_r6_templ/root_router.png)

### 部件模型

表格部件：

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/grid_mode.png)

表单部件：

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/form_mode.png)

### 实体服务类

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/de_service.png)

## 页面预览

应用首页视图：

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/indexview.png)

实体表格视图（关闭搜索表单）：

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/gridview.png)

实体表格视图（开启搜索表单）：

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/gridview2.png)

实体编辑视图：

![produce](https://doc.ibizlab.cn/images/angular_r6_templ/editview.png)