import { NgZorroAntdModule } from 'ng-zorro-antd';
import { RouterModule } from '@angular/router';
import { NgModule, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';

import { EditFormModule } from '@widgets/entity/main/main.module';
import { EntityEditViewPage } from './entity-edit-view';


@NgModule({
  imports: [
    RouterModule.forChild([
      {
        path: '',
        component: EntityEditViewPage,
        data: { name: 'module_entityeditview' }
      }
    ])
  ],
  exports: [ RouterModule ]
})
export class EntityEditViewRouteModule {}

@NgModule({
  imports: [
    NgZorroAntdModule,
    CommonModule,
    FormsModule,
    EntityEditViewRouteModule,
    EditFormModule,
  ],
  schemas: [CUSTOM_ELEMENTS_SCHEMA],
  declarations: [EntityEditViewPage],
  entryComponents: [EntityEditViewPage],
  exports: [EntityEditViewPage]
})
export class EntityEditViewModule {}
