import { NgZorroAntdModule } from 'ng-zorro-antd';
import { RouterModule } from '@angular/router';
import { NgModule, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';

import { EditFormModule } from '@widgets/example/main/main.module';
import { ExampleEditViewPage } from './example-edit-view';


@NgModule({
  imports: [
    RouterModule.forChild([
      {
        path: '',
        component: ExampleEditViewPage,
        data: { name: 'exapmple_exampleeditview' }
      }
    ])
  ],
  exports: [ RouterModule ]
})
export class ExampleEditViewRouteModule {}

@NgModule({
  imports: [
    NgZorroAntdModule,
    CommonModule,
    FormsModule,
    ExampleEditViewRouteModule,
    EditFormModule,
  ],
  schemas: [CUSTOM_ELEMENTS_SCHEMA],
  declarations: [ExampleEditViewPage],
  entryComponents: [ExampleEditViewPage],
  exports: [ExampleEditViewPage]
})
export class ExampleEditViewModule {}
