import { NgZorroAntdModule } from 'ng-zorro-antd';
import { RouterModule } from '@angular/router';
import { NgModule, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';

import { EditFormModule } from '@widgets/entity3/main/main.module';
import { Entity3EditViewPage } from './entity3-edit-view';


@NgModule({
  imports: [
    RouterModule.forChild([
      {
        path: '',
        component: Entity3EditViewPage,
        data: { name: 'module3_entity3editview' }
      }
    ])
  ],
  exports: [ RouterModule ]
})
export class Entity3EditViewRouteModule {}

@NgModule({
  imports: [
    NgZorroAntdModule,
    CommonModule,
    FormsModule,
    Entity3EditViewRouteModule,
    EditFormModule,
  ],
  schemas: [CUSTOM_ELEMENTS_SCHEMA],
  declarations: [Entity3EditViewPage],
  entryComponents: [Entity3EditViewPage],
  exports: [Entity3EditViewPage]
})
export class Entity3EditViewModule {}
