import { NgZorroAntdModule } from 'ng-zorro-antd';
import { RouterModule } from '@angular/router';
import { NgModule, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';

import { EditFormModule } from '@widgets/entity5/main/main.module';
import { Entity5EditViewPage } from './entity5-edit-view';


@NgModule({
  imports: [
    RouterModule.forChild([
      {
        path: '',
        component: Entity5EditViewPage,
        data: { name: 'module5_entity5editview' }
      }
    ])
  ],
  exports: [ RouterModule ]
})
export class Entity5EditViewRouteModule {}

@NgModule({
  imports: [
    NgZorroAntdModule,
    CommonModule,
    FormsModule,
    Entity5EditViewRouteModule,
    EditFormModule,
  ],
  schemas: [CUSTOM_ELEMENTS_SCHEMA],
  declarations: [Entity5EditViewPage],
  entryComponents: [Entity5EditViewPage],
  exports: [Entity5EditViewPage]
})
export class Entity5EditViewModule {}
