import { Component, OnInit, Input, Output, EventEmitter, ViewContainerRef, ViewChild, OnDestroy, AfterViewInit } from '@angular/core';
import { Subject, Subscription } from 'rxjs';
import { NzNotificationService } from 'ng-zorro-antd/notification';
import { Util } from '@global/util/util';
import { NzModalService } from 'ng-zorro-antd/modal';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@global/model/form-detail';
import { debounceTime, distinctUntilChanged } from 'rxjs/operators';

@Component({
	selector: 'main-form',
	templateUrl: './main.html',
	styleUrls: ['./main.less'],
})
export class EditForm implements OnInit {

	constructor(private $util: Util) {
		
	}

    /**
     * 数据对象
     *
     * @type {*}
     * @memberof EditForm
     */
    @Input()
    set formData(val: any) {
        if (val) {
            this.data = JSON.parse(JSON.stringify(val));
            this.formLogic('', null, null);
        }
    }

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof EditForm
     */
    public data: any = {};

	/**
	 * 表单数据变化
	 *
	 * @type {Subject<any>}
	 * @memberof EditForm
	 */
	public formDataChange: Subject<any> = new Subject<any>();

	/**
	 * 表单数据变化抛出事件
	 *
	 * @type {EventEmitter<any>}
	 * @memberof EditForm
	 */
	@Output() dataChangeEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 代码表模型
     *
     * @type {*}
     * @memberof Main
     */
    public codelistModel: any = {
        'SysOperator': [
        ]
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof Main
     */
    public rules: any = {
        entity4name: [
            { type: 'string', message: '实体4名称 值必须为字符串类型' },
            { required: false, type: 'string', message: '实体4名称 值不能为空' },
        ],
        createman: [
            { type: 'string', message: '建立人 值必须为字符串类型' },
            { required: false, type: 'string', message: '建立人 值不能为空' },
        ],
        createdate: [
            { type: 'string', message: '建立时间 值必须为字符串类型' },
            { required: false, type: 'string', message: '建立时间 值不能为空' },
        ],
        updateman: [
            { type: 'string', message: '更新人 值必须为字符串类型' },
            { required: false, type: 'string', message: '更新人 值不能为空' },
        ],
        updatedate: [
            { type: 'string', message: '更新时间 值必须为字符串类型' },
            { required: false, type: 'string', message: '更新时间 值不能为空' },
        ],
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof Main
     */
    public detailsModel: any = {
        entity4name: new FormItemModel({ caption: '实体4名称', detailType: 'FORMITEM', name: 'entity4name', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        group1: new FormGroupPanelModel({ caption: '实体4基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this })
, 
        createman: new FormItemModel({ caption: '建立人', detailType: 'FORMITEM', name: 'createman', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        createdate: new FormItemModel({ caption: '建立时间', detailType: 'FORMITEM', name: 'createdate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        updateman: new FormItemModel({ caption: '更新人', detailType: 'FORMITEM', name: 'updateman', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        updatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'updatedate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        group2: new FormGroupPanelModel({ caption: '操作信息', detailType: 'GROUPPANEL', name: 'group2', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        formpage2: new FormPageModel({ caption: '其它', detailType: 'FORMPAGE', name: 'formpage2', visible: true, isShowCaption: true, form: this })
, 
        form: new FormTabPanelModel({ caption: 'form', detailType: 'TABPANEL', name: 'form', visible: true, isShowCaption: true, form: this, tabPages: [{ name: 'formpage1', index: 0, visible: true }, { name: 'formpage2', index: 1, visible: true }] }),
    };

    /**
     * 生命周期
     *
     * @memberof EditForm
     */
    ngOnInit(): void {
        this.formLogic('', null, null);
        this.formDataChange.pipe(
			debounceTime(300),
            distinctUntilChanged()
		).subscribe(data => {
			this.dataChangeEvent.emit(JSON.parse(data.data));
			const field = data.field;
			if (field) {
				this.formLogic(field.name, field.value, field.oldVal);
				this.validateFormItem(field.name);
			}
		});
    }

	/**
	 * 表单项值变化事件
	 *
	 * @param {{name: string, value: any}} {name, value}
	 * @memberof EditForm
	 */
	public onFormDataChange(name: string, value: any): void {
		if (Object.is(this.data[name], value)) {
            return;
        }
		let oldVal: any = this.data[name];
		this.data[name] = value;
		this.formDataChange.next({ data: JSON.stringify(this.data), field: { name: name, value: value, oldVal: oldVal } });
	}

	/**
	 * 校验表单项
	 *
	 * @param {string} name
	 * @memberof EditForm
	 */
	public validateFormItem(name: string) {
		if (!name) {
			return;
		}
		const rule: any[] = this.rules[name];
		let message = '';
        let status = '';
        const val: any = this.data[name];
        rule.every((rule: any) => {
            if (rule.required && (!val || Object.is(val, '')) ) {
                message = rule.message;
                status = 'error';
                return false;
            } else if (val && rule.pattern && !rule.pattern.test(val)) {
                message = rule.message;
                status = 'error';
                return false;
            }
            return true;
        });
		this.detailsModel[name].error = message;
		this.detailsModel[name].validateStatus = status;
	}

    /**
     * 获取代码表集合
     *
     * @param {string} name
     * @memberof EditForm
     */
    public getCodeList(name: string) {
        if (!name || !this.codelistModel[name]) {
            return [];
        }
        return this.codelistModel[name];
    }

    /**
     * 表单逻辑
     *
     * @param {string} name
     * @param {*} newVal
     * @param {*} oldVal
     * @memberof EditForm
     */
    public formLogic(name: string, newVal: any, oldVal: any) {
                









    }
}