import { Component, OnInit, Input, Output, EventEmitter, ViewContainerRef, ViewChild, OnDestroy, AfterViewInit } from '@angular/core';
import { Subject, Subscription } from 'rxjs';
import { NzNotificationService } from 'ng-zorro-antd/notification';
import { Util } from '@global/util/util';
import { NzModalService } from 'ng-zorro-antd/modal';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@global/model/form-detail';
import { debounceTime, distinctUntilChanged } from 'rxjs/operators';

@Component({
	selector: 'alleditortype-form',
	templateUrl: './all-editor-type.html',
	styleUrls: ['./all-editor-type.less'],
})
export class EditForm implements OnInit {

	constructor(private $util: Util) {
		
	}

    /**
     * 数据对象
     *
     * @type {*}
     * @memberof EditForm
     */
    @Input()
    set formData(val: any) {
        if (val) {
            this.data = JSON.parse(JSON.stringify(val));
            this.formLogic('', null, null);
        }
    }

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof EditForm
     */
    public data: any = {};

	/**
	 * 表单数据变化
	 *
	 * @type {Subject<any>}
	 * @memberof EditForm
	 */
	public formDataChange: Subject<any> = new Subject<any>();

	/**
	 * 表单数据变化抛出事件
	 *
	 * @type {EventEmitter<any>}
	 * @memberof EditForm
	 */
	@Output() dataChangeEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 代码表模型
     *
     * @type {*}
     * @memberof AllEditorType
     */
    public codelistModel: any = {
        'ExampleText': [
            { 'id': 'A', 'text': '文本1', 'value': 'A' },
            { 'id': 'B', 'text': '文本2', 'value': 'B' },
            { 'id': 'C', 'text': '文本3', 'value': 'C' },
            { 'id': 'D', 'text': '文本4', 'value': 'D' },
            { 'id': 'E', 'text': '文本5', 'value': 'E' },
        ]
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof AllEditorType
     */
    public rules: any = {
        span: [
            { type: 'string', message: '标签 值必须为字符串类型' },
            { required: false, type: 'string', message: '标签 值不能为空' },
        ],
        textbox: [
            { type: 'string', message: '文本框 值必须为字符串类型' },
            { required: false, type: 'string', message: '文本框 值不能为空' },
        ],
        password: [
            { type: 'string', message: '密码输入框 值必须为字符串类型' },
            { required: false, type: 'string', message: '密码输入框 值不能为空' },
        ],
        rawitem: [
            { type: 'string', message: '直接内容 值必须为字符串类型' },
            { required: false, type: 'string', message: '直接内容 值不能为空' },
        ],
        checkbox: [
            { type: 'string', message: '选项框 值必须为字符串类型' },
            { required: false, type: 'string', message: '选项框 值不能为空' },
        ],
        checkboxlist: [
            { type: 'string', message: '选项框列表 值必须为字符串类型' },
            { required: false, type: 'string', message: '选项框列表 值不能为空' },
        ],
        dropdownlist: [
            { type: 'string', message: '下拉列表 值必须为字符串类型' },
            { required: false, type: 'string', message: '下拉列表 值不能为空' },
        ],
        listbox: [
            { type: 'string', message: '列表框 值必须为字符串类型' },
            { required: false, type: 'string', message: '列表框 值不能为空' },
        ],
        formitem1: [
            { type: 'string', message: '单选项列表 值必须为字符串类型' },
            { required: false, type: 'string', message: '单选项列表 值不能为空' },
        ],
        datepicker: [
            { type: 'string', message: '时间选择 值必须为字符串类型' },
            { required: false, type: 'string', message: '时间选择 值不能为空' },
        ],
        formitem: [
            { type: 'string', message: '无小时 值必须为字符串类型' },
            { required: false, type: 'string', message: '无小时 值不能为空' },
        ],
        formitem6: [
            { type: 'string', message: '无日期 值必须为字符串类型' },
            { required: false, type: 'string', message: '无日期 值不能为空' },
        ],
        formitem7: [
            { type: 'string', message: '小时 值必须为字符串类型' },
            { required: false, type: 'string', message: '小时 值不能为空' },
        ],
        formitem8: [
            { type: 'string', message: '分钟 值必须为字符串类型' },
            { required: false, type: 'string', message: '分钟 值不能为空' },
        ],
        formitem9: [
            { type: 'string', message: '秒钟 值必须为字符串类型' },
            { required: false, type: 'string', message: '秒钟 值不能为空' },
        ],
        formitem10: [
            { type: 'string', message: '无日期无秒钟 值必须为字符串类型' },
            { required: false, type: 'string', message: '无日期无秒钟 值不能为空' },
        ],
        textrea: [
            { type: 'string', message: '多行输入框 值必须为字符串类型' },
            { required: false, type: 'string', message: '多行输入框 值不能为空' },
        ],
        formitem2: [
            { type: 'string', message: 'HTML编辑框 值必须为字符串类型' },
            { required: false, type: 'string', message: 'HTML编辑框 值不能为空' },
        ],
        formitem4: [
            { type: 'string', message: '图片上传 值必须为字符串类型' },
            { required: false, type: 'string', message: '图片上传 值不能为空' },
        ],
        formitem5: [
            { type: 'string', message: '文件上传 值必须为字符串类型' },
            { required: false, type: 'string', message: '文件上传 值不能为空' },
        ],
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof AllEditorType
     */
    public detailsModel: any = {
        span: new FormItemModel({ caption: '标签', detailType: 'FORMITEM', name: 'span', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        textbox: new FormItemModel({ caption: '文本框', detailType: 'FORMITEM', name: 'textbox', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        password: new FormItemModel({ caption: '密码输入框', detailType: 'FORMITEM', name: 'password', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        rawitem: new FormItemModel({ caption: '直接内容', detailType: 'FORMITEM', name: 'rawitem', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        grouppanel1: new FormGroupPanelModel({ caption: '基础', detailType: 'GROUPPANEL', name: 'grouppanel1', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        checkbox: new FormItemModel({ caption: '选项框', detailType: 'FORMITEM', name: 'checkbox', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        checkboxlist: new FormItemModel({ caption: '选项框列表', detailType: 'FORMITEM', name: 'checkboxlist', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        dropdownlist: new FormItemModel({ caption: '下拉列表', detailType: 'FORMITEM', name: 'dropdownlist', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        listbox: new FormItemModel({ caption: '列表框', detailType: 'FORMITEM', name: 'listbox', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem1: new FormItemModel({ caption: '单选项列表', detailType: 'FORMITEM', name: 'formitem1', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        grouppanel3: new FormGroupPanelModel({ caption: '选择类', detailType: 'GROUPPANEL', name: 'grouppanel3', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        datepicker: new FormItemModel({ caption: '时间选择', detailType: 'FORMITEM', name: 'datepicker', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem: new FormItemModel({ caption: '无小时', detailType: 'FORMITEM', name: 'formitem', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem6: new FormItemModel({ caption: '无日期', detailType: 'FORMITEM', name: 'formitem6', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem7: new FormItemModel({ caption: '小时', detailType: 'FORMITEM', name: 'formitem7', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem8: new FormItemModel({ caption: '分钟', detailType: 'FORMITEM', name: 'formitem8', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem9: new FormItemModel({ caption: '秒钟', detailType: 'FORMITEM', name: 'formitem9', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem10: new FormItemModel({ caption: '无日期无秒钟', detailType: 'FORMITEM', name: 'formitem10', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        grouppanel4: new FormGroupPanelModel({ caption: '时间类型', detailType: 'GROUPPANEL', name: 'grouppanel4', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        textrea: new FormItemModel({ caption: '多行输入框', detailType: 'FORMITEM', name: 'textrea', visible: true, isShowCaption: false, form: this, disabled: false, enableCond: 3 })
, 
        grouppanel2: new FormGroupPanelModel({ caption: '多行输入框', detailType: 'GROUPPANEL', name: 'grouppanel2', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        formitem2: new FormItemModel({ caption: 'HTML编辑框', detailType: 'FORMITEM', name: 'formitem2', visible: true, isShowCaption: false, form: this, disabled: false, enableCond: 3 })
, 
        grouppanel5: new FormGroupPanelModel({ caption: '富文本文本编辑', detailType: 'GROUPPANEL', name: 'grouppanel5', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        formitem4: new FormItemModel({ caption: '图片上传', detailType: 'FORMITEM', name: 'formitem4', visible: true, isShowCaption: false, form: this, disabled: false, enableCond: 3 })
, 
        grouppanel6: new FormGroupPanelModel({ caption: '图片上传', detailType: 'GROUPPANEL', name: 'grouppanel6', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        formitem5: new FormItemModel({ caption: '文件上传', detailType: 'FORMITEM', name: 'formitem5', visible: true, isShowCaption: false, form: this, disabled: false, enableCond: 3 })
, 
        grouppanel7: new FormGroupPanelModel({ caption: '文件上传', detailType: 'GROUPPANEL', name: 'grouppanel7', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        formpage1: new FormPageModel({ caption: '表单分页', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this })
, 
    };

    /**
     * 生命周期
     *
     * @memberof EditForm
     */
    ngOnInit(): void {
        this.formLogic('', null, null);
        this.formDataChange.pipe(
			debounceTime(300),
            distinctUntilChanged()
		).subscribe(data => {
			this.dataChangeEvent.emit(JSON.parse(data.data));
			const field = data.field;
			if (field) {
				this.formLogic(field.name, field.value, field.oldVal);
				this.validateFormItem(field.name);
			}
		});
    }

	/**
	 * 表单项值变化事件
	 *
	 * @param {{name: string, value: any}} {name, value}
	 * @memberof EditForm
	 */
	public onFormDataChange(name: string, value: any): void {
		if (Object.is(this.data[name], value)) {
            return;
        }
		let oldVal: any = this.data[name];
		this.data[name] = value;
		this.formDataChange.next({ data: JSON.stringify(this.data), field: { name: name, value: value, oldVal: oldVal } });
	}

	/**
	 * 校验表单项
	 *
	 * @param {string} name
	 * @memberof EditForm
	 */
	public validateFormItem(name: string) {
		if (!name) {
			return;
		}
		const rule: any[] = this.rules[name];
		let message = '';
        let status = '';
        const val: any = this.data[name];
        rule.every((rule: any) => {
            if (rule.required && (!val || Object.is(val, '')) ) {
                message = rule.message;
                status = 'error';
                return false;
            } else if (val && rule.pattern && !rule.pattern.test(val)) {
                message = rule.message;
                status = 'error';
                return false;
            }
            return true;
        });
		this.detailsModel[name].error = message;
		this.detailsModel[name].validateStatus = status;
	}

    /**
     * 获取代码表集合
     *
     * @param {string} name
     * @memberof EditForm
     */
    public getCodeList(name: string) {
        if (!name || !this.codelistModel[name]) {
            return [];
        }
        return this.codelistModel[name];
    }

    /**
     * 表单逻辑
     *
     * @param {string} name
     * @param {*} newVal
     * @param {*} oldVal
     * @memberof EditForm
     */
    public formLogic(name: string, newVal: any, oldVal: any) {
                




























    }
}