import { Component, OnInit, Input, Output, EventEmitter, ViewContainerRef, ViewChild, OnDestroy, AfterViewInit } from '@angular/core';
import { Subject, Subscription } from 'rxjs';
import { NzNotificationService } from 'ng-zorro-antd/notification';
import { Util } from '@global/util/util';
import { NzModalService } from 'ng-zorro-antd/modal';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@global/model/form-detail';
import { debounceTime, distinctUntilChanged } from 'rxjs/operators';

@Component({
	selector: 'main2-form',
	templateUrl: './main2.html',
	styleUrls: ['./main2.less'],
})
export class EditForm implements OnInit {

	constructor(private $util: Util) {
		
	}

    /**
     * 数据对象
     *
     * @type {*}
     * @memberof EditForm
     */
    @Input()
    set formData(val: any) {
        if (val) {
            this.data = JSON.parse(JSON.stringify(val));
            this.formLogic('', null, null);
        }
    }

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof EditForm
     */
    public data: any = {};

	/**
	 * 表单数据变化
	 *
	 * @type {Subject<any>}
	 * @memberof EditForm
	 */
	public formDataChange: Subject<any> = new Subject<any>();

	/**
	 * 表单数据变化抛出事件
	 *
	 * @type {EventEmitter<any>}
	 * @memberof EditForm
	 */
	@Output() dataChangeEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 代码表模型
     *
     * @type {*}
     * @memberof Main2
     */
    public codelistModel: any = {
        'SysOperator': [
        ]
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof Main2
     */
    public rules: any = {
        formitem: [
            { type: 'string', message: '文本框 值必须为字符串类型' },
            { required: false, type: 'string', message: '文本框 值不能为空' },
        ],
        formitem1: [
            { type: 'string', message: '密码框 值必须为字符串类型' },
            { required: false, type: 'string', message: '密码框 值不能为空' },
        ],
        formitem2: [
            { type: 'string', message: '隐藏表单项 值必须为字符串类型' },
            { required: false, type: 'string', message: '隐藏表单项 值不能为空' },
        ],
        formitem3: [
            { type: 'string', message: '多行输入框 值必须为字符串类型' },
            { required: false, type: 'string', message: '多行输入框 值不能为空' },
        ],
        formitem4: [
            { type: 'string', message: 'IP地址输入框 值必须为字符串类型' },
            { required: false, type: 'string', message: 'IP地址输入框 值不能为空' },
        ],
        formitem5: [
            { type: 'string', message: '直接内容 值必须为字符串类型' },
            { required: false, type: 'string', message: '直接内容 值不能为空' },
        ],
        formitem6: [
            { type: 'string', message: '标签 值必须为字符串类型' },
            { required: false, type: 'string', message: '标签 值不能为空' },
        ],
        formitem7: [
            { type: 'string', message: '下拉列表框 值必须为字符串类型' },
            { required: false, type: 'string', message: '下拉列表框 值不能为空' },
        ],
        formitem8: [
            { type: 'string', message: '选项框 值必须为字符串类型' },
            { required: false, type: 'string', message: '选项框 值不能为空' },
        ],
        formitem9: [
            { type: 'string', message: '单选项列表 值必须为字符串类型' },
            { required: false, type: 'string', message: '单选项列表 值不能为空' },
        ],
        formitem10: [
            { type: 'string', message: '选项框列表 值必须为字符串类型' },
            { required: false, type: 'string', message: '选项框列表 值不能为空' },
        ],
        formitem11: [
            { type: 'string', message: '时间选择器 值必须为字符串类型' },
            { required: false, type: 'string', message: '时间选择器 值不能为空' },
        ],
        formitem12: [
            { type: 'string', message: 'html编辑框 值必须为字符串类型' },
            { required: false, type: 'string', message: 'html编辑框 值不能为空' },
        ],
        formitem13: [
            { type: 'string', message: '代码编辑器 值必须为字符串类型' },
            { required: false, type: 'string', message: '代码编辑器 值不能为空' },
        ],
        formitem14: [
            { type: 'string', message: '图片控件 值必须为字符串类型' },
            { required: false, type: 'string', message: '图片控件 值不能为空' },
        ],
        formitem15: [
            { type: 'string', message: '文件上传控件 值必须为字符串类型' },
            { required: false, type: 'string', message: '文件上传控件 值不能为空' },
        ],
        formitem16: [
            { type: 'string', message: '用户自定义 值必须为字符串类型' },
            { required: false, type: 'string', message: '用户自定义 值不能为空' },
        ],
        formitem11: [
            { type: 'string', message: '表单项 值必须为字符串类型' },
            { required: false, type: 'string', message: '表单项 值不能为空' },
        ],
        age: [
            { type: 'string', message: '年龄 值必须为字符串类型' },
            { required: false, type: 'string', message: '年龄 值不能为空' },
        ],
        checkbox: [
            { type: 'string', message: '选项框 值必须为字符串类型' },
            { required: false, type: 'string', message: '选项框 值不能为空' },
        ],
        checkboxlist: [
            { type: 'string', message: '选项框列表 值必须为字符串类型' },
            { required: false, type: 'string', message: '选项框列表 值不能为空' },
        ],
        childrenmarriage: [
            { type: 'string', message: '子女婚否 值必须为字符串类型' },
            { required: true, type: 'string', message: '子女婚否 值不能为空' },
        ],
        childrenname: [
            { type: 'string', message: '子女姓名 值必须为字符串类型' },
            { required: false, type: 'string', message: '子女姓名 值不能为空' },
        ],
        childrenornot: [
            { type: 'string', message: '是否有小孩 值必须为字符串类型' },
            { required: false, type: 'string', message: '是否有小孩 值不能为空' },
        ],
        childrensex: [
            { type: 'string', message: '子女性别 值必须为字符串类型' },
            { required: false, type: 'string', message: '子女性别 值不能为空' },
        ],
        createdate: [
            { type: 'string', message: '建立时间 值必须为字符串类型' },
            { required: false, type: 'string', message: '建立时间 值不能为空' },
        ],
        createman: [
            { type: 'string', message: '建立人 值必须为字符串类型' },
            { required: false, type: 'string', message: '建立人 值不能为空' },
        ],
        datepicker: [
            { type: 'string', message: '时间选择 值必须为字符串类型' },
            { required: false, type: 'string', message: '时间选择 值不能为空' },
        ],
        dropdownlist: [
            { type: 'string', message: '下拉列表 值必须为字符串类型' },
            { required: false, type: 'string', message: '下拉列表 值不能为空' },
        ],
        exampleid: [
            { type: 'string', message: '示例标识 值必须为字符串类型' },
            { required: false, type: 'string', message: '示例标识 值不能为空' },
        ],
        examplename: [
            { type: 'string', message: '示例名称 值必须为字符串类型' },
            { required: false, type: 'string', message: '示例名称 值不能为空' },
        ],
        listbox: [
            { type: 'string', message: '列表框 值必须为字符串类型' },
            { required: false, type: 'string', message: '列表框 值不能为空' },
        ],
        marriage: [
            { type: 'string', message: '婚否 值必须为字符串类型' },
            { required: true, type: 'string', message: '婚否 值不能为空' },
        ],
        name: [
            { type: 'string', message: '名称 值必须为字符串类型' },
            { required: false, type: 'string', message: '名称 值不能为空' },
        ],
        password: [
            { type: 'string', message: '密码输入框 值必须为字符串类型' },
            { required: false, type: 'string', message: '密码输入框 值不能为空' },
        ],
        rawitem: [
            { type: 'string', message: '直接内容 值必须为字符串类型' },
            { required: false, type: 'string', message: '直接内容 值不能为空' },
        ],
        sex: [
            { type: 'string', message: '性别 值必须为字符串类型' },
            { required: true, type: 'string', message: '性别 值不能为空' },
        ],
        span: [
            { type: 'string', message: '标签 值必须为字符串类型' },
            { required: false, type: 'string', message: '标签 值不能为空' },
        ],
        spouseage: [
            { type: 'string', message: '配偶年龄 值必须为字符串类型' },
            { required: false, type: 'string', message: '配偶年龄 值不能为空' },
        ],
        spousename: [
            { type: 'string', message: '配偶姓名 值必须为字符串类型' },
            { required: false, type: 'string', message: '配偶姓名 值不能为空' },
        ],
        spousesex: [
            { type: 'string', message: '配偶性别 值必须为字符串类型' },
            { required: true, type: 'string', message: '配偶性别 值不能为空' },
        ],
        textbox: [
            { type: 'string', message: '文本框 值必须为字符串类型' },
            { required: false, type: 'string', message: '文本框 值不能为空' },
        ],
        textrea: [
            { type: 'string', message: '多行输入框 值必须为字符串类型' },
            { required: false, type: 'string', message: '多行输入框 值不能为空' },
        ],
        updatedate: [
            { type: 'string', message: '更新时间 值必须为字符串类型' },
            { required: false, type: 'string', message: '更新时间 值不能为空' },
        ],
        updateman: [
            { type: 'string', message: '更新人 值必须为字符串类型' },
            { required: false, type: 'string', message: '更新人 值不能为空' },
        ],
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof Main2
     */
    public detailsModel: any = {
        tabpanel1: new FormTabPanelModel({ caption: '', detailType: 'TABPANEL', name: 'tabpanel1', visible: true, isShowCaption: false, form: this, tabPages: [] })
, 
        grouppanel2: new FormGroupPanelModel({ caption: '分组面板', detailType: 'GROUPPANEL', name: 'grouppanel2', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        formitem: new FormItemModel({ caption: '文本框', detailType: 'FORMITEM', name: 'formitem', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem1: new FormItemModel({ caption: '密码框', detailType: 'FORMITEM', name: 'formitem1', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem2: new FormItemModel({ caption: '隐藏表单项', detailType: 'FORMITEM', name: 'formitem2', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem3: new FormItemModel({ caption: '多行输入框', detailType: 'FORMITEM', name: 'formitem3', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem4: new FormItemModel({ caption: 'IP地址输入框', detailType: 'FORMITEM', name: 'formitem4', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem5: new FormItemModel({ caption: '直接内容', detailType: 'FORMITEM', name: 'formitem5', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem6: new FormItemModel({ caption: '标签', detailType: 'FORMITEM', name: 'formitem6', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem7: new FormItemModel({ caption: '下拉列表框', detailType: 'FORMITEM', name: 'formitem7', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem8: new FormItemModel({ caption: '选项框', detailType: 'FORMITEM', name: 'formitem8', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem9: new FormItemModel({ caption: '单选项列表', detailType: 'FORMITEM', name: 'formitem9', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem10: new FormItemModel({ caption: '选项框列表', detailType: 'FORMITEM', name: 'formitem10', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem11: new FormItemModel({ caption: '时间选择器', detailType: 'FORMITEM', name: 'formitem11', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem12: new FormItemModel({ caption: 'html编辑框', detailType: 'FORMITEM', name: 'formitem12', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem13: new FormItemModel({ caption: '代码编辑器', detailType: 'FORMITEM', name: 'formitem13', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem14: new FormItemModel({ caption: '图片控件', detailType: 'FORMITEM', name: 'formitem14', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem15: new FormItemModel({ caption: '文件上传控件', detailType: 'FORMITEM', name: 'formitem15', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem16: new FormItemModel({ caption: '用户自定义', detailType: 'FORMITEM', name: 'formitem16', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        button1: new FormButtonModel({ caption: '', detailType: 'BUTTON', name: 'button1', visible: true, isShowCaption: true, form: this })
, 
        rawitem1: new FormRowItemModel({ caption: '', detailType: 'RAWITEM', name: 'rawitem1', visible: true, isShowCaption: true, form: this })
, 
        iframe1: new FormIFrameModel({ caption: '', detailType: 'IFRAME', name: 'iframe1', visible: true, isShowCaption: true, form: this })
, 
        formitem11: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem11', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        age: new FormItemModel({ caption: '年龄', detailType: 'FORMITEM', name: 'age', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        checkbox: new FormItemModel({ caption: '选项框', detailType: 'FORMITEM', name: 'checkbox', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        checkboxlist: new FormItemModel({ caption: '选项框列表', detailType: 'FORMITEM', name: 'checkboxlist', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        childrenmarriage: new FormItemModel({ caption: '子女婚否', detailType: 'FORMITEM', name: 'childrenmarriage', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        childrenname: new FormItemModel({ caption: '子女姓名', detailType: 'FORMITEM', name: 'childrenname', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        childrenornot: new FormItemModel({ caption: '是否有小孩', detailType: 'FORMITEM', name: 'childrenornot', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        childrensex: new FormItemModel({ caption: '子女性别', detailType: 'FORMITEM', name: 'childrensex', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        createdate: new FormItemModel({ caption: '建立时间', detailType: 'FORMITEM', name: 'createdate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        createman: new FormItemModel({ caption: '建立人', detailType: 'FORMITEM', name: 'createman', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        datepicker: new FormItemModel({ caption: '时间选择', detailType: 'FORMITEM', name: 'datepicker', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        dropdownlist: new FormItemModel({ caption: '下拉列表', detailType: 'FORMITEM', name: 'dropdownlist', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        exampleid: new FormItemModel({ caption: '示例标识', detailType: 'FORMITEM', name: 'exampleid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        examplename: new FormItemModel({ caption: '示例名称', detailType: 'FORMITEM', name: 'examplename', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        listbox: new FormItemModel({ caption: '列表框', detailType: 'FORMITEM', name: 'listbox', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        marriage: new FormItemModel({ caption: '婚否', detailType: 'FORMITEM', name: 'marriage', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        name: new FormItemModel({ caption: '名称', detailType: 'FORMITEM', name: 'name', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        password: new FormItemModel({ caption: '密码输入框', detailType: 'FORMITEM', name: 'password', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        rawitem: new FormItemModel({ caption: '直接内容', detailType: 'FORMITEM', name: 'rawitem', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        sex: new FormItemModel({ caption: '性别', detailType: 'FORMITEM', name: 'sex', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        span: new FormItemModel({ caption: '标签', detailType: 'FORMITEM', name: 'span', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        spouseage: new FormItemModel({ caption: '配偶年龄', detailType: 'FORMITEM', name: 'spouseage', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        spousename: new FormItemModel({ caption: '配偶姓名', detailType: 'FORMITEM', name: 'spousename', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        spousesex: new FormItemModel({ caption: '配偶性别', detailType: 'FORMITEM', name: 'spousesex', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        textbox: new FormItemModel({ caption: '文本框', detailType: 'FORMITEM', name: 'textbox', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        textrea: new FormItemModel({ caption: '多行输入框', detailType: 'FORMITEM', name: 'textrea', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        updatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'updatedate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        updateman: new FormItemModel({ caption: '更新人', detailType: 'FORMITEM', name: 'updateman', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        grouppanel1: new FormGroupPanelModel({ caption: '分组面板', detailType: 'GROUPPANEL', name: 'grouppanel1', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        formpage1: new FormPageModel({ caption: '表单分页', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this })
, 
        formpage2: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage2', visible: true, isShowCaption: true, form: this })
, 
        form: new FormTabPanelModel({ caption: 'form', detailType: 'TABPANEL', name: 'form', visible: true, isShowCaption: true, form: this, tabPages: [{ name: 'formpage1', index: 0, visible: true }, { name: 'formpage2', index: 1, visible: true }] }),
    };

    /**
     * 生命周期
     *
     * @memberof EditForm
     */
    ngOnInit(): void {
        this.formLogic('', null, null);
        this.formDataChange.pipe(
			debounceTime(300),
            distinctUntilChanged()
		).subscribe(data => {
			this.dataChangeEvent.emit(JSON.parse(data.data));
			const field = data.field;
			if (field) {
				this.formLogic(field.name, field.value, field.oldVal);
				this.validateFormItem(field.name);
			}
		});
    }

    /**
     * 事件触发
     *
     * @param {*} $event
     * @memberof EditForm
     */
    public button1_click($event: any) {

    }

	/**
	 * 表单项值变化事件
	 *
	 * @param {{name: string, value: any}} {name, value}
	 * @memberof EditForm
	 */
	public onFormDataChange(name: string, value: any): void {
		if (Object.is(this.data[name], value)) {
            return;
        }
		let oldVal: any = this.data[name];
		this.data[name] = value;
		this.formDataChange.next({ data: JSON.stringify(this.data), field: { name: name, value: value, oldVal: oldVal } });
	}

	/**
	 * 校验表单项
	 *
	 * @param {string} name
	 * @memberof EditForm
	 */
	public validateFormItem(name: string) {
		if (!name) {
			return;
		}
		const rule: any[] = this.rules[name];
		let message = '';
        let status = '';
        const val: any = this.data[name];
        rule.every((rule: any) => {
            if (rule.required && (!val || Object.is(val, '')) ) {
                message = rule.message;
                status = 'error';
                return false;
            } else if (val && rule.pattern && !rule.pattern.test(val)) {
                message = rule.message;
                status = 'error';
                return false;
            }
            return true;
        });
		this.detailsModel[name].error = message;
		this.detailsModel[name].validateStatus = status;
	}

    /**
     * 获取代码表集合
     *
     * @param {string} name
     * @memberof EditForm
     */
    public getCodeList(name: string) {
        if (!name || !this.codelistModel[name]) {
            return [];
        }
        return this.codelistModel[name];
    }

    /**
     * 表单逻辑
     *
     * @param {string} name
     * @param {*} newVal
     * @param {*} oldVal
     * @memberof EditForm
     */
    public formLogic(name: string, newVal: any, oldVal: any) {
                





















































    }
}