import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';

@Component({
    selector: 'app-file-upload',
    templateUrl: './app-file-upload.html',
    styleUrls: ['./app-file-upload.less']
})
export class AppFileUpload implements OnInit {

    /**
     * 是否禁用
     *
     * @type {boolean}
     * @memberof AppFileUpload
     */
    @Input() disabled: boolean;

    /**
     * 值项
     *
     * @memberof AppFileUpload
     */
    @Input()
    set value(val: any) {
        if (val) {
            this.fileList = JSON.parse(val);
        } else {
            this.fileList = [];
        }
    }

    /**
     * 表单项之变化事件
     *
     * @memberof AppFileUpload
     */
    @Output() public onFormItemValueChange: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 上传地址
     *
     * @type {string}
     * @memberof AppFileUpload
     */
    public url: string = 'https://jsonplaceholder.typicode.com/posts/';

    /**
     * 已上传文件
     *
     * @type {any[]}
     * @memberof AppFileUpload
     */
    public fileList: any[] = [];

    /**
     * 是否支持多选
     *
     * @type {boolean}
     * @memberof AppFileUpload
     */
    public isMultiple: boolean = false;

    /**
     * 生命周期
     *
     * @memberof AppFileUpload
     */
    ngOnInit(): void {
        
    }

    /**
     * 值变化
     *
     * @param {*} $event
     * @memberof AppFileUpload
     */
    public onChange($event) {
        if (Object.is($event.type, 'success')) {
            let files: any[] = JSON.parse(JSON.stringify(this.fileList));
            files.push($event.file);
            this.onFormItemValueChange.emit(JSON.stringify(files));
        } else if (Object.is($event.type, 'removed')) {
            let files: any[] = JSON.parse(JSON.stringify(this.fileList));
            let file = $event.file;
            let index = files.findIndex((item) => Object.is(item.uid, file.uid));
            files.splice(index, 1);
            this.onFormItemValueChange.emit(JSON.stringify(files));
        }
    }

}
