import { Component, OnInit, Input, Output, EventEmitter, ViewContainerRef, ViewChild, OnDestroy, AfterViewInit } from '@angular/core';
import { Subject, Subscription } from 'rxjs';
import { NzNotificationService } from 'ng-zorro-antd/notification';
import { Util } from '@global/util/util';
import { NzModalService } from 'ng-zorro-antd/modal';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@global/model/form-detail';
import { debounceTime, distinctUntilChanged } from 'rxjs/operators';

@Component({
	selector: 'dynamiclogicform-form',
	templateUrl: './dynamic-logic-form.html',
	styleUrls: ['./dynamic-logic-form.less'],
})
export class EditForm implements OnInit {

	constructor(private $util: Util) {
		
	}

    /**
     * 数据对象
     *
     * @type {*}
     * @memberof EditForm
     */
    @Input()
    set formData(val: any) {
        if (val) {
            this.data = JSON.parse(JSON.stringify(val));
            this.formLogic('', null, null);
        }
    }

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof EditForm
     */
    public data: any = {};

	/**
	 * 表单数据变化
	 *
	 * @type {Subject<any>}
	 * @memberof EditForm
	 */
	public formDataChange: Subject<any> = new Subject<any>();

	/**
	 * 表单数据变化抛出事件
	 *
	 * @type {EventEmitter<any>}
	 * @memberof EditForm
	 */
	@Output() dataChangeEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 代码表模型
     *
     * @type {*}
     * @memberof DynamicLogicForm
     */
    public codelistModel: any = {
        'YesNo': [
            { 'id': 'Item_1', 'text': '是', 'value': '1' },
            { 'id': 'Item_0', 'text': '否', 'value': '0' },
        ],
        'SexCodeList': [
            { 'id': 'Woman', 'text': '女', 'value': 'woman' },
            { 'id': 'Man', 'text': '男', 'value': 'man' },
        ],
        'AgeGroupCodeList': [
            { 'id': 'Item_1', 'text': '0~15岁', 'value': '0_15' },
            { 'id': 'Item_2', 'text': '16~25岁', 'value': '16_25' },
            { 'id': 'Item_3', 'text': '26~40岁', 'value': '26_40' },
            { 'id': 'Item_4', 'text': '41~65岁', 'value': '41_65' },
            { 'id': 'Item_5', 'text': '大于65岁', 'value': '65_' },
        ]
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof DynamicLogicForm
     */
    public rules: any = {
        name: [
            { type: 'string', message: '名称 值必须为字符串类型' },
            { required: false, type: 'string', message: '名称 值不能为空' },
        ],
        age: [
            { type: 'string', message: '年龄 值必须为字符串类型' },
            { required: false, type: 'string', message: '年龄 值不能为空' },
        ],
        sex: [
            { type: 'string', message: '性别 值必须为字符串类型' },
            { required: true, type: 'string', message: '性别 值不能为空' },
        ],
        marriage: [
            { type: 'string', message: '婚否 值必须为字符串类型' },
            { required: true, type: 'string', message: '婚否 值不能为空' },
        ],
        spousename: [
            { type: 'string', message: '配偶姓名 值必须为字符串类型' },
            { required: false, type: 'string', message: '配偶姓名 值不能为空' },
        ],
        spouseage: [
            { type: 'string', message: '配偶年龄 值必须为字符串类型' },
            { required: false, type: 'string', message: '配偶年龄 值不能为空' },
        ],
        spousesex: [
            { type: 'string', message: '配偶性别 值必须为字符串类型' },
            { required: true, type: 'string', message: '配偶性别 值不能为空' },
        ],
        childrenname: [
            { type: 'string', message: '子女姓名 值必须为字符串类型' },
            { required: false, type: 'string', message: '子女姓名 值不能为空' },
        ],
        childrensex: [
            { type: 'string', message: '子女性别 值必须为字符串类型' },
            { required: false, type: 'string', message: '子女性别 值不能为空' },
        ],
        childrenmarriage: [
            { type: 'string', message: '子女婚否 值必须为字符串类型' },
            { required: true, type: 'string', message: '子女婚否 值不能为空' },
        ],
        childrenornot: [
            { type: 'string', message: '是否有小孩 值必须为字符串类型' },
            { required: true, type: 'string', message: '是否有小孩 值不能为空' },
        ],
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof DynamicLogicForm
     */
    public detailsModel: any = {
        name: new FormItemModel({ caption: '名称', detailType: 'FORMITEM', name: 'name', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        age: new FormItemModel({ caption: '年龄', detailType: 'FORMITEM', name: 'age', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        sex: new FormItemModel({ caption: '性别', detailType: 'FORMITEM', name: 'sex', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        marriage: new FormItemModel({ caption: '婚否', detailType: 'FORMITEM', name: 'marriage', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        group1: new FormGroupPanelModel({ caption: '基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        spousename: new FormItemModel({ caption: '配偶姓名', detailType: 'FORMITEM', name: 'spousename', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        spouseage: new FormItemModel({ caption: '配偶年龄', detailType: 'FORMITEM', name: 'spouseage', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        spousesex: new FormItemModel({ caption: '配偶性别', detailType: 'FORMITEM', name: 'spousesex', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        grouppanel2: new FormGroupPanelModel({ caption: '配偶信息', detailType: 'GROUPPANEL', name: 'grouppanel2', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        childrenname: new FormItemModel({ caption: '子女姓名', detailType: 'FORMITEM', name: 'childrenname', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        childrensex: new FormItemModel({ caption: '子女性别', detailType: 'FORMITEM', name: 'childrensex', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        childrenmarriage: new FormItemModel({ caption: '子女婚否', detailType: 'FORMITEM', name: 'childrenmarriage', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        childrenornot: new FormItemModel({ caption: '是否有小孩', detailType: 'FORMITEM', name: 'childrenornot', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        grouppanel3: new FormGroupPanelModel({ caption: '子女信息', detailType: 'GROUPPANEL', name: 'grouppanel3', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        grouppanel1: new FormGroupPanelModel({ caption: '家庭信息', detailType: 'GROUPPANEL', name: 'grouppanel1', visible: false, isShowCaption: true, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this })
, 
    };

    /**
     * 生命周期
     *
     * @memberof EditForm
     */
    ngOnInit(): void {
        this.formLogic('', null, null);
        this.formDataChange.pipe(
			debounceTime(300),
            distinctUntilChanged()
		).subscribe(data => {
			this.dataChangeEvent.emit(JSON.parse(data.data));
			const field = data.field;
			if (field) {
				this.formLogic(field.name, field.value, field.oldVal);
				this.validateFormItem(field.name);
			}
		});
    }

	/**
	 * 表单项值变化事件
	 *
	 * @param {{name: string, value: any}} {name, value}
	 * @memberof EditForm
	 */
	public onFormDataChange(name: string, value: any): void {
		if (Object.is(this.data[name], value)) {
            return;
        }
		let oldVal: any = this.data[name];
		this.data[name] = value;
		this.formDataChange.next({ data: JSON.stringify(this.data), field: { name: name, value: value, oldVal: oldVal } });
	}

	/**
	 * 校验表单项
	 *
	 * @param {string} name
	 * @memberof EditForm
	 */
	public validateFormItem(name: string) {
		if (!name) {
			return;
		}
		const rule: any[] = this.rules[name];
		let message = '';
        let status = '';
        const val: any = this.data[name];
        rule.every((rule: any) => {
            if (rule.required && (!val || Object.is(val, '')) ) {
                message = rule.message;
                status = 'error';
                return false;
            } else if (val && rule.pattern && !rule.pattern.test(val)) {
                message = rule.message;
                status = 'error';
                return false;
            }
            return true;
        });
		this.detailsModel[name].error = message;
		this.detailsModel[name].validateStatus = status;
	}

    /**
     * 获取代码表集合
     *
     * @param {string} name
     * @memberof EditForm
     */
    public getCodeList(name: string) {
        if (!name || !this.codelistModel[name]) {
            return [];
        }
        return this.codelistModel[name];
    }

    /**
     * 表单逻辑
     *
     * @param {string} name
     * @param {*} newVal
     * @param {*} oldVal
     * @memberof EditForm
     */
    public formLogic(name: string, newVal: any, oldVal: any) {
                









        if (Object.is(name, '') || Object.is(name, 'sex') || Object.is(name, 'spousesex')) {
            let ret = false;
            const _sex = this.data.sex;
            const _spousesex = this.data.spousesex;
            if (this.$util.testCond(_sex, 'EQ', 'man') && this.$util.testCond(_spousesex, 'EQ', 'woman') || this.$util.testCond(_sex, 'EQ', 'woman') && this.$util.testCond(_spousesex, 'EQ', 'man')) {
                ret = true;
            }
            this.detailsModel.childrenname.setDisabled(!ret);
        }

        if (Object.is(name, '') || Object.is(name, 'sex') || Object.is(name, 'spousesex')) {
            let ret = false;
            const _sex = this.data.sex;
            const _spousesex = this.data.spousesex;
            if (this.$util.testCond(_sex, 'EQ', 'man') && this.$util.testCond(_spousesex, 'EQ', 'woman') || this.$util.testCond(_sex, 'EQ', 'woman') && this.$util.testCond(_spousesex, 'EQ', 'man')) {
                ret = true;
            }
            this.detailsModel.childrensex.setDisabled(!ret);
        }

        if (Object.is(name, '') || Object.is(name, 'sex') || Object.is(name, 'spousesex')) {
            let ret = false;
            const _sex = this.data.sex;
            const _spousesex = this.data.spousesex;
            if (this.$util.testCond(_sex, 'EQ', 'man') && this.$util.testCond(_spousesex, 'EQ', 'woman') || this.$util.testCond(_sex, 'EQ', 'woman') && this.$util.testCond(_spousesex, 'EQ', 'man')) {
                ret = true;
            }
            this.detailsModel.childrenmarriage.setDisabled(!ret);
        }

        if (Object.is(name, '') || Object.is(name, 'childrenmarriage')) {
            let ret = true;
            const _childrenmarriage = this.data.childrenmarriage;
            if (this.$util.testCond(_childrenmarriage, 'EQ', '0')) {
                ret = false;
            }
            this.rules.childrenornot.some((rule: any) => {
                if (rule.hasOwnProperty('required')) {
                    rule.required = ret;
                }
                return false;
            });
        }
        if (Object.is(name, '') || Object.is(name, 'sex') || Object.is(name, 'spousesex')) {
            let ret = false;
            const _sex = this.data.sex;
            const _spousesex = this.data.spousesex;
            if (this.$util.testCond(_sex, 'EQ', 'man') && this.$util.testCond(_spousesex, 'EQ', 'woman') || this.$util.testCond(_sex, 'EQ', 'woman') && this.$util.testCond(_spousesex, 'EQ', 'man')) {
                ret = true;
            }
            this.detailsModel.childrenornot.setDisabled(!ret);
        }


        if (Object.is(name, '') || Object.is(name, 'marriage')) {
            let ret = false;
            const _marriage = this.data.marriage;
            if (this.$util.testCond(_marriage, 'EQ', '1')) {
                ret = true;
            }
            this.detailsModel.grouppanel1.setVisible(ret);
        }


    }
}