import { NgZorroAntdModule } from 'ng-zorro-antd';
import { RouterModule } from '@angular/router';
import { NgModule, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';

import { EditFormModule } from '@widgets/example/dynamic-logic-form/dynamic-logic-form.module';
import { ExampleDLFEditViewPage } from './example-dlfedit-view';


@NgModule({
  imports: [
    RouterModule.forChild([
      {
        path: '',
        component: ExampleDLFEditViewPage,
        data: { name: 'exapmple_exampledlfeditview' }
      }
    ])
  ],
  exports: [ RouterModule ]
})
export class ExampleDLFEditViewRouteModule {}

@NgModule({
  imports: [
    NgZorroAntdModule,
    CommonModule,
    FormsModule,
    ExampleDLFEditViewRouteModule,
    EditFormModule,
  ],
  schemas: [CUSTOM_ELEMENTS_SCHEMA],
  declarations: [ExampleDLFEditViewPage],
  entryComponents: [ExampleDLFEditViewPage],
  exports: [ExampleDLFEditViewPage]
})
export class ExampleDLFEditViewModule {}
