import { NgModule } from '@angular/core';
import { PreloadAllModules, RouterModule, Routes } from '@angular/router';
import { AppComponent } from './app.component';

const routes: Routes = [
  {
    path: '',
    children: [
            {
        path: 'exapmple_exampleeditortype',
        loadChildren: '@pages/exapmple/example-editor-type/example-editor-type.module#ExampleEditorTypeModule'
      },
      {
        path: 'exapmple_exampleeditview',
        loadChildren: '@pages/exapmple/example-edit-view/example-edit-view.module#ExampleEditViewModule'
      },
      {
        path: 'exapmple_exampledlfeditview',
        loadChildren: '@pages/exapmple/example-dlfedit-view/example-dlfedit-view.module#ExampleDLFEditViewModule'
      },
    ]
  },
  {
    path: '**',
    redirectTo: '',
    pathMatch: 'full'
  }
];

@NgModule({
  imports: [
    RouterModule.forRoot(routes, { preloadingStrategy: PreloadAllModules, useHash: true })
  ],
  exports: [RouterModule]
})
export class AppRoutingModule {}
