import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';

@Component({
    selector: 'app-radio',
    templateUrl: './app-radio.html',
    styleUrls: ['./app-radio.less']
})
export class AppRadio implements OnInit {

    /**
     * 值项
     *
     * @memberof AppRadio
     */
    @Input()
    set value(val) {
        this.itemValue = val;
    }

    /**
     * 是否禁用
     *
     * @type {boolean}
     * @memberof AppRadio
     */
    @Input() public disabled: boolean = false;

    /**
     * 代码表
     *
     * @type {any[]}
     * @memberof AppCheckboxList
     */
    @Input() codeList: any[];

    /**
     * 值项
     *
     * @type {*}
     * @memberof AppRadio
     */
    public itemValue: any = null;

    /**
     * 代码表项集合
     *
     * @type {any[]}
     * @memberof AppRadio
     */
    public items: any[] = [];

    /**
     * 宽度
     *
     * @type {*}
     * @memberof AppRadio
     */
    @Input() public width: any;

    /**
     * 表单项之变化事件
     *
     * @memberof AppRadio
     */
    @Output() public onFormItemValueChange: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 生命周期
     *
     * @memberof AppRadio
     */
    public ngOnInit(): void {
        if (this.codeList) {
            this.items = JSON.parse(JSON.stringify(this.codeList));
        }
    }

    /**
     * 值变化
     *
     * @param {*} $event
     * @memberof AppRadio
     */
    public onValueChange($event) {
        this.onFormItemValueChange.emit($event);
    }

}
