import { NgZorroAntdModule } from 'ng-zorro-antd';
import { RouterModule } from '@angular/router';
import { NgModule, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';

import { EditFormModule } from '@widgets/entity4/main/main.module';
import { Entity4EditViewPage } from './entity4-edit-view';


@NgModule({
  imports: [
    RouterModule.forChild([
      {
        path: '',
        component: Entity4EditViewPage,
        data: { name: 'module4_entity4editview' }
      }
    ])
  ],
  exports: [ RouterModule ]
})
export class Entity4EditViewRouteModule {}

@NgModule({
  imports: [
    NgZorroAntdModule,
    CommonModule,
    FormsModule,
    Entity4EditViewRouteModule,
    EditFormModule,
  ],
  schemas: [CUSTOM_ELEMENTS_SCHEMA],
  declarations: [Entity4EditViewPage],
  entryComponents: [Entity4EditViewPage],
  exports: [Entity4EditViewPage]
})
export class Entity4EditViewModule {}
