import { NgZorroAntdModule } from 'ng-zorro-antd';
import { RouterModule } from '@angular/router';
import { NgModule, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';

import { EditFormModule } from '@widgets/entity2/main/main.module';
import { Entity2EditViewPage } from './entity2-edit-view';


@NgModule({
  imports: [
    RouterModule.forChild([
      {
        path: '',
        component: Entity2EditViewPage,
        data: { name: 'module2_entity2editview' }
      }
    ])
  ],
  exports: [ RouterModule ]
})
export class Entity2EditViewRouteModule {}

@NgModule({
  imports: [
    NgZorroAntdModule,
    CommonModule,
    FormsModule,
    Entity2EditViewRouteModule,
    EditFormModule,
  ],
  schemas: [CUSTOM_ELEMENTS_SCHEMA],
  declarations: [Entity2EditViewPage],
  entryComponents: [Entity2EditViewPage],
  exports: [Entity2EditViewPage]
})
export class Entity2EditViewModule {}
