import { Component, OnInit, Input, Output, EventEmitter, ViewContainerRef, ViewChild, OnDestroy, AfterViewInit } from '@angular/core';
import { Subject, Subscription } from 'rxjs';
import { NzNotificationService } from 'ng-zorro-antd/notification';
import { Util } from '@global/util/util';
import { NzModalService } from 'ng-zorro-antd/modal';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@global/model/form-detail';
import { debounceTime, distinctUntilChanged } from 'rxjs/operators';

@Component({
	selector: 'main5-form',
	templateUrl: './main5.html',
	styleUrls: ['./main5.less'],
})
export class EditForm implements OnInit {

	constructor(private $util: Util) {
		
	}

    /**
     * 数据对象
     *
     * @type {*}
     * @memberof EditForm
     */
    @Input()
    set formData(val: any) {
        if (val) {
            this.data = JSON.parse(JSON.stringify(val));
            this.formLogic('', null, null);
        }
    }

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof EditForm
     */
    public data: any = {};

	/**
	 * 表单数据变化
	 *
	 * @type {Subject<any>}
	 * @memberof EditForm
	 */
	public formDataChange: Subject<any> = new Subject<any>();

	/**
	 * 表单数据变化抛出事件
	 *
	 * @type {EventEmitter<any>}
	 * @memberof EditForm
	 */
	@Output() dataChangeEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 代码表模型
     *
     * @type {*}
     * @memberof Main5
     */
    public codelistModel: any = {
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof Main5
     */
    public rules: any = {
        srfupdatedate: [
            { type: 'string', message: '更新时间 值必须为字符串类型' },
            { required: false, type: 'string', message: '更新时间 值不能为空' },
        ],
        srforikey: [
            { type: 'string', message: ' 值必须为字符串类型' },
            { required: false, type: 'string', message: ' 值不能为空' },
        ],
        srfkey: [
            { type: 'string', message: '实体5标识 值必须为字符串类型' },
            { required: false, type: 'string', message: '实体5标识 值不能为空' },
        ],
        srfmajortext: [
            { type: 'string', message: '实体5名称 值必须为字符串类型' },
            { required: false, type: 'string', message: '实体5名称 值不能为空' },
        ],
        srftempmode: [
            { type: 'string', message: ' 值必须为字符串类型' },
            { required: false, type: 'string', message: ' 值不能为空' },
        ],
        srfuf: [
            { type: 'string', message: ' 值必须为字符串类型' },
            { required: false, type: 'string', message: ' 值不能为空' },
        ],
        srfdeid: [
            { type: 'string', message: ' 值必须为字符串类型' },
            { required: false, type: 'string', message: ' 值不能为空' },
        ],
        srfsourcekey: [
            { type: 'string', message: ' 值必须为字符串类型' },
            { required: false, type: 'string', message: ' 值不能为空' },
        ],
        formitem1: [
            { type: 'string', message: ' 值必须为字符串类型' },
            { required: false, type: 'string', message: ' 值不能为空' },
        ],
        formitem: [
            { type: 'string', message: ' 值必须为字符串类型' },
            { required: true, type: 'string', message: ' 值不能为空' },
        ],
        entity5id: [
            { type: 'string', message: '实体5标识 值必须为字符串类型' },
            { required: false, type: 'string', message: '实体5标识 值不能为空' },
        ],
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof Main5
     */
    public detailsModel: any = {
        button1: new FormButtonModel({ caption: '123123', detailType: 'BUTTON', name: 'button1', visible: true, isShowCaption: true, form: this })
, 
        grouppanel2: new FormGroupPanelModel({ caption: '分组面板', detailType: 'GROUPPANEL', name: 'grouppanel2', visible: true, isShowCaption: false, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        grouppanel3: new FormGroupPanelModel({ caption: '分组面板', detailType: 'GROUPPANEL', name: 'grouppanel3', visible: true, isShowCaption: false, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        grouppanel4: new FormGroupPanelModel({ caption: '分组面板', detailType: 'GROUPPANEL', name: 'grouppanel4', visible: true, isShowCaption: false, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        grouppanel1: new FormGroupPanelModel({ caption: '分组面板', detailType: 'GROUPPANEL', name: 'grouppanel1', visible: true, isShowCaption: false, form: this, uiActionGroup: { caption: '', extractMode: 'ITEM', details: [] } })
, 
        formpage1: new FormPageModel({ caption: '表单分页', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this })
, 
        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        srfkey: new FormItemModel({ caption: '实体5标识', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        srfmajortext: new FormItemModel({ caption: '实体5名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem1: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'formitem1', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        formitem: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'formitem', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
        entity5id: new FormItemModel({ caption: '实体5标识', detailType: 'FORMITEM', name: 'entity5id', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 })
, 
    };

    /**
     * 生命周期
     *
     * @memberof EditForm
     */
    ngOnInit(): void {
        this.formLogic('', null, null);
        this.formDataChange.pipe(
			debounceTime(300),
            distinctUntilChanged()
		).subscribe(data => {
			this.dataChangeEvent.emit(JSON.parse(data.data));
			const field = data.field;
			if (field) {
				this.formLogic(field.name, field.value, field.oldVal);
				this.validateFormItem(field.name);
			}
		});
    }

    /**
     * 123123事件触发
     *
     * @param {*} $event
     * @memberof EditForm
     */
    public button1_click($event: any) {

    }

	/**
	 * 表单项值变化事件
	 *
	 * @param {{name: string, value: any}} {name, value}
	 * @memberof EditForm
	 */
	public onFormDataChange(name: string, value: any): void {
		if (Object.is(this.data[name], value)) {
            return;
        }
		let oldVal: any = this.data[name];
		this.data[name] = value;
		this.formDataChange.next({ data: JSON.stringify(this.data), field: { name: name, value: value, oldVal: oldVal } });
	}

	/**
	 * 校验表单项
	 *
	 * @param {string} name
	 * @memberof EditForm
	 */
	public validateFormItem(name: string) {
		if (!name) {
			return;
		}
		const rule: any[] = this.rules[name];
		let message = '';
        let status = '';
        const val: any = this.data[name];
        rule.every((rule: any) => {
            if (rule.required && (!val || Object.is(val, '')) ) {
                message = rule.message;
                status = 'error';
                return false;
            } else if (val && rule.pattern && !rule.pattern.test(val)) {
                message = rule.message;
                status = 'error';
                return false;
            }
            return true;
        });
		this.detailsModel[name].error = message;
		this.detailsModel[name].validateStatus = status;
	}

    /**
     * 获取代码表集合
     *
     * @param {string} name
     * @memberof EditForm
     */
    public getCodeList(name: string) {
        if (!name || !this.codelistModel[name]) {
            return [];
        }
        return this.codelistModel[name];
    }

    /**
     * 表单逻辑
     *
     * @param {string} name
     * @param {*} newVal
     * @param {*} oldVal
     * @memberof EditForm
     */
    public formLogic(name: string, newVal: any, oldVal: any) {
                















        if (Object.is(name, '') || Object.is(name, 'formitem')) {
            let ret = true;
            const _formitem = this.data.formitem;
            if (this.$util.testCond(_formitem, 'EQ', '1213')) {
                ret = false;
            }
            this.rules.formitem.some((rule: any) => {
                if (rule.hasOwnProperty('required')) {
                    rule.required = ret;
                }
                return false;
            });
        }


    }
}