import React, { PureComponent } from 'react';
import { Form, Input, Row, Col, Tabs, Icon, Collapse, Button, Select, message } from 'antd';
import Schema from "async-validator";
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '../../../ibizsys/form-detail';
import { Util } from '../../../ibizsys/utils/util';

import AppDropDownList  from '../../../ibizsys/components/app-dropdown-list/app-dropdown-list';
import AppRadioGroup from '../../../ibizsys/components/app-radio-group/app-radio-group';
import AppCheckBox from '../../../ibizsys/components/app-checkbox/app-checkbox';
import AppCheckBoxGroup from '../../../ibizsys/components/app-checkbox-group/app-checkbox-group';
import AppDatePicker from '../../../ibizsys/components/app-date-picker/app-date-picker';
import AppTimePicker from '../../../ibizsys/components/app-time-picker/app-time-picker';
import AppImageUpload from '../../../ibizsys/components/app-image-upload/app-image-upload';
import AppFileUpload from '../../../ibizsys/components/app-file-upload/app-file-upload';
import AppRichTextEditor from '../../../ibizsys/components/app-rich-text-editor/app-rich-text-editor';

import './dynamic-logic-form.less';
const { TabPane } = Tabs;
const { Panel } = Collapse;
const { Option } = Select;
const { TextArea  } = Input;

/**
 * 表单属性
 *
 * @export
 * @interface DynamicLogicFormFormData
 */
export class DynamicLogicFormFormData {
    /**
     * 名称
     *
     * @type {*}
     * @memberof DynamicLogicFormFormData
     */
    name?: any;
    /**
     * 年龄
     *
     * @type {*}
     * @memberof DynamicLogicFormFormData
     */
    age?: any;
    /**
     * 性别
     *
     * @type {*}
     * @memberof DynamicLogicFormFormData
     */
    sex?: any;
    /**
     * 婚否
     *
     * @type {*}
     * @memberof DynamicLogicFormFormData
     */
    marriage?: any;
    /**
     * 配偶姓名
     *
     * @type {*}
     * @memberof DynamicLogicFormFormData
     */
    spousename?: any;
    /**
     * 配偶年龄
     *
     * @type {*}
     * @memberof DynamicLogicFormFormData
     */
    spouseage?: any;
    /**
     * 配偶性别
     *
     * @type {*}
     * @memberof DynamicLogicFormFormData
     */
    spousesex?: any;
    /**
     * 子女姓名
     *
     * @type {*}
     * @memberof DynamicLogicFormFormData
     */
    childrenname?: any;
    /**
     * 子女性别
     *
     * @type {*}
     * @memberof DynamicLogicFormFormData
     */
    childrensex?: any;
    /**
     * 子女婚否
     *
     * @type {*}
     * @memberof DynamicLogicFormFormData
     */
    childrenmarriage?: any;
    /**
     * 是否有小孩
     *
     * @type {*}
     * @memberof DynamicLogicFormFormData
     */
    childrenornot?: any;
    /**
     * 示例标识
     *
     * @type {*}
     * @memberof DynamicLogicFormFormData
     */
    exampleid?: any;
}

/**
 * 输入属性
 *
 * @export
 * @interface DynamicLogicFormProps
 */
export interface DynamicLogicFormProps {
    /**
     * 表单数据对象
     *
     * @type {DynamicLogicFormFormData}
     * @memberof DynamicLogicFormProps
     */
    data?: DynamicLogicFormFormData;
    /**
     * 表单分页切换
     *
     * @memberof DynamicLogicFormProps
     */
    tabChange?: (key: string) => void;
    /**
     * 表单项之变化
     *
     * @memberof MainProps
     */
    formItemChange?:(key:any) => void;
}

/**
 * DynamicLogicForm
 *
 * @export
 * @class DynamicLogicForm
 * @extends {PureComponent}
 */
export default class DynamicLogicForm extends PureComponent<DynamicLogicFormProps> {
    /**
     * 表单数据
     *
     * @type {*}
     * @memberof DynamicLogicForm
     */
    public data: DynamicLogicFormFormData = new DynamicLogicFormFormData();

    /**
     * 初始化实例
     *
     * @type {*}
     * @memberof DynamicLogicForm
     */
    constructor(props) {
        super(props);
        if (this.data && this.props.data && !Object.is(JSON.stringify(this.data), JSON.stringify(this.props.data))) {
            Object.assign(this.data, this.props.data);
        }
        this.initForm();
    }
    
    /**
     * 在组件接收到一个新的 prop (或更新后)时被调用
     *
     * @memberof IBizViewController
     */
    public componentWillReceiveProps(nextProps: Readonly<DynamicLogicFormProps>, nextContext: any) {
        if (this.data && nextProps.data && !Object.is(JSON.stringify(this.data), JSON.stringify(nextProps.data))) {
            Object.assign(this.data, nextProps.data);
        }
    }

    /**
     * 在组件从 DOM 中移除的时候立刻被调用
     *
     * @memberof IBizViewController
     */
    public componentWillUnmount() {

    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof DynamicLogicForm
     */
    public rules: any = {
        name: [
            { type: 'string', message: '名称 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '名称 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '名称 值不能为空', trigger: 'blur' },
        ],
        age: [
            { type: 'string', message: '年龄 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '年龄 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '年龄 值不能为空', trigger: 'blur' },
        ],
        sex: [
            { type: 'string', message: '性别 值必须为字符串类型', trigger: 'change' },
            { required: true, type: 'string', message: '性别 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '性别 值不能为空', trigger: 'blur' },
        ],
        marriage: [
            { type: 'string', message: '婚否 值必须为字符串类型', trigger: 'change' },
            { required: true, type: 'string', message: '婚否 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '婚否 值不能为空', trigger: 'blur' },
        ],
        spousename: [
            { type: 'string', message: '配偶姓名 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '配偶姓名 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '配偶姓名 值不能为空', trigger: 'blur' },
        ],
        spouseage: [
            { type: 'string', message: '配偶年龄 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '配偶年龄 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '配偶年龄 值不能为空', trigger: 'blur' },
        ],
        spousesex: [
            { type: 'string', message: '配偶性别 值必须为字符串类型', trigger: 'change' },
            { required: true, type: 'string', message: '配偶性别 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '配偶性别 值不能为空', trigger: 'blur' },
        ],
        childrenname: [
            { type: 'string', message: '子女姓名 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '子女姓名 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '子女姓名 值不能为空', trigger: 'blur' },
        ],
        childrensex: [
            { type: 'string', message: '子女性别 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '子女性别 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '子女性别 值不能为空', trigger: 'blur' },
        ],
        childrenmarriage: [
            { type: 'string', message: '子女婚否 值必须为字符串类型', trigger: 'change' },
            { required: true, type: 'string', message: '子女婚否 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '子女婚否 值不能为空', trigger: 'blur' },
        ],
        childrenornot: [
            { type: 'string', message: '是否有小孩 值必须为字符串类型', trigger: 'change' },
            { required: true, type: 'string', message: '是否有小孩 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '是否有小孩 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof DynamicLogicForm
     */
    public detailsModel: any = {
        name: new FormItemModel({ caption: '名称', detailType: 'FORMITEM', name: 'name', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        age: new FormItemModel({ caption: '年龄', detailType: 'FORMITEM', name: 'age', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        sex: new FormItemModel({ caption: '性别', detailType: 'FORMITEM', name: 'sex', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:true,enableCond: 3 })
,
        marriage: new FormItemModel({ caption: '婚否', detailType: 'FORMITEM', name: 'marriage', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:true,enableCond: 3 })
,
        group1: new FormGroupPanelModel({ caption: '基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        spousename: new FormItemModel({ caption: '配偶姓名', detailType: 'FORMITEM', name: 'spousename', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        spouseage: new FormItemModel({ caption: '配偶年龄', detailType: 'FORMITEM', name: 'spouseage', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        spousesex: new FormItemModel({ caption: '配偶性别', detailType: 'FORMITEM', name: 'spousesex', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:true,enableCond: 3 })
,
        grouppanel2: new FormGroupPanelModel({ caption: '配偶信息', detailType: 'GROUPPANEL', name: 'grouppanel2', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        childrenname: new FormItemModel({ caption: '子女姓名', detailType: 'FORMITEM', name: 'childrenname', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        childrensex: new FormItemModel({ caption: '子女性别', detailType: 'FORMITEM', name: 'childrensex', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        childrenmarriage: new FormItemModel({ caption: '子女婚否', detailType: 'FORMITEM', name: 'childrenmarriage', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:true,enableCond: 3 })
,
        childrenornot: new FormItemModel({ caption: '是否有小孩', detailType: 'FORMITEM', name: 'childrenornot', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:true,enableCond: 3 })
,
        grouppanel3: new FormGroupPanelModel({ caption: '子女信息', detailType: 'GROUPPANEL', name: 'grouppanel3', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        grouppanel1: new FormGroupPanelModel({ caption: '家庭信息', detailType: 'GROUPPANEL', name: 'grouppanel1', visible: false, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this })
,
    }

    /**
      * 代码表模型
      *
      * @type {*}
      * @memberof DynamicLogicForm
      */      
    public codelistModel:any = {
        "formbase_YesNo":[
        {"id":"1","text":"是","disabled":false},
        {"id":"0","text":"否","disabled":false}
        ],
        "formbase_SexCodeList":[
        {"id":"woman","text":"女","disabled":false},
        {"id":"man","text":"男","disabled":false}
        ],
        "formbase_AgeGroupCodeList":[
        {"id":"0_15","text":"0~15岁","disabled":false},
        {"id":"16_25","text":"16~25岁","disabled":false},
        {"id":"26_40","text":"26~40岁","disabled":false},
        {"id":"41_65","text":"41~65岁","disabled":false},
        {"id":"65_","text":"大于65岁","disabled":false}
        ]
      }

    /**
     * 表单逻辑
     *
     * @private
     * @param { name, newVal, oldVal }
     * @memberof DynamicLogicForm
     */
    private formLogic(name: string, newVal: any, oldVal?: any): void {
                









        if (Object.is(name, '') || Object.is(name, 'sex') || Object.is(name, 'spousesex')) {
            let ret = false;
            const _sex = this.data.sex;
            const _spousesex = this.data.spousesex;
            if (Util.testCond(_sex, 'EQ', 'man') && Util.testCond(_spousesex, 'EQ', 'woman') || Util.testCond(_sex, 'EQ', 'woman') && Util.testCond(_spousesex, 'EQ', 'man')) {
                ret = true;
            }
            this.detailsModel.childrenname.setDisabled(!ret);
        }

        if (Object.is(name, '') || Object.is(name, 'sex') || Object.is(name, 'spousesex')) {
            let ret = false;
            const _sex = this.data.sex;
            const _spousesex = this.data.spousesex;
            if (Util.testCond(_sex, 'EQ', 'man') && Util.testCond(_spousesex, 'EQ', 'woman') || Util.testCond(_sex, 'EQ', 'woman') && Util.testCond(_spousesex, 'EQ', 'man')) {
                ret = true;
            }
            this.detailsModel.childrensex.setDisabled(!ret);
        }

        if (Object.is(name, '') || Object.is(name, 'sex') || Object.is(name, 'spousesex')) {
            let ret = false;
            const _sex = this.data.sex;
            const _spousesex = this.data.spousesex;
            if (Util.testCond(_sex, 'EQ', 'man') && Util.testCond(_spousesex, 'EQ', 'woman') || Util.testCond(_sex, 'EQ', 'woman') && Util.testCond(_spousesex, 'EQ', 'man')) {
                ret = true;
            }
            this.detailsModel.childrenmarriage.setDisabled(!ret);
        }

        if (Object.is(name, '') || Object.is(name, 'childrenmarriage')) {
            let ret = true;
            const _childrenmarriage = this.data.childrenmarriage;
            if (Util.testCond(_childrenmarriage, 'EQ', '0')) {
                ret = false;
            }
            this.detailsModel.childrenornot.required = ret;
            this.rules.childrenornot.forEach((item) =>{
                    if(item.hasOwnProperty('required')){
                            item.required = ret;
                    }
            })
        }
        if (Object.is(name, '') || Object.is(name, 'sex') || Object.is(name, 'spousesex')) {
            let ret = false;
            const _sex = this.data.sex;
            const _spousesex = this.data.spousesex;
            if (Util.testCond(_sex, 'EQ', 'man') && Util.testCond(_spousesex, 'EQ', 'woman') || Util.testCond(_sex, 'EQ', 'woman') && Util.testCond(_spousesex, 'EQ', 'man')) {
                ret = true;
            }
            this.detailsModel.childrenornot.setDisabled(!ret);
        }


        if (Object.is(name, '') || Object.is(name, 'marriage')) {
            let ret = false;
            const _marriage = this.data.marriage;
            if (Util.testCond(_marriage, 'EQ', '1')) {
                ret = true;
            }
            this.detailsModel.grouppanel1.setVisible(ret);
        }


    }


    /**
     * 表单分页切换
     *
     * @param {string} key 分页标识
     * @memberof DynamicLogicForm
     */
    public tabChange(key: string): void {
        if (this.props.tabChange) {
            this.props.tabChange(key);
        }
    }

    /**
     * 表单值变化事件
     *
     * @memberof DynamicLogicForm
     */
    public formItemChange(item: string, value: any, isFirst?: boolean) {
        this.data[item] = value;
        this.formLogic(item, value);
        if (!isFirst) {
            this.validateItem(item, value);
            if (this.props.formItemChange) {
                this.props.formItemChange({name:item,value:value});
            }
        }
        this.tick();
    }

    /**
     * 按钮点击事件
     *
     * @memberof DynamicLogicForm
     */
    public buttonClick($event:any,value:String){
        message.info('点击了'+value);
    }

    /**
     * 初始化表单
     * 
     * @memberof DynamicLogicForm
     */
    public initForm() {
        if (Object.keys(this.data).length > 0) {
            Object.keys(this.data).forEach((item) => {
                this.formItemChange(item, this.data[item], true);
            })
        }
    }

    /**
     * 校验单个表单项
     * @param item 
     * @param value 
     */
    public validateItem(item: string, value: any) {
        // 做校验
        // 1.获取数值和规则
        const rule = this.rules[item];
        // 2.创建校验规则
        const schema = new Schema({ [item]: rule })
        // 校验返回Promise
        return schema.validate({ [item]: value },undefined,errors => {
            if (errors) {
                // 有错
                this.detailsModel[item].setError(errors[0].message);
            } else {
                this.detailsModel[item].setError('');
            }
        })
    }

    /**
     * 校验表单
     * 
     * @memberof DynamicLogicForm
     */
    public validateForm(callback:Function) {
        let tasks: any;
        if (Object.keys(this.data).length > 0) {
            tasks = Object.keys(this.data).map((item) => {
                this.validateItem(item, this.data[item]);
            })
        }
        Promise.all(tasks)
            .then(() => callback(true))
            .catch(() => callback(false))
    }

    /**
     * 绘制内容
     *
     * @returns
     * @memberof DynamicLogicForm
     */
    public render(): any {
        return <>
            <div className="ibiz-form dynamiclogicform">
                <Form layout="inline">
                {this.detailsModel.group1.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
        <Collapse defaultActiveKey={['group1']} className=''>
    <Panel header="基本信息" key="group1">
        <Row>
                
        {this.detailsModel.name.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 24, offset: 0}} lg={{ span: 12, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.name.isShowCaption && !this.detailsModel.name.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.name.required ? <span className="isrequired">*</span> : ""}名称
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'name'}  validateStatus={this.detailsModel.name.validateStatus} help={this.detailsModel.name.error}>
                <Input id={'name'} disabled={this.detailsModel.name.disabled} value={this.data.name}     onChange={($event) =>{this.formItemChange('name',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.age.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 24, offset: 0}} lg={{ span: 12, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.age.isShowCaption && !this.detailsModel.age.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.age.required ? <span className="isrequired">*</span> : ""}年龄
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'age'}  validateStatus={this.detailsModel.age.validateStatus} help={this.detailsModel.age.error}>
                <AppDropDownList value={this.data.age} disabled={this.detailsModel.age.disabled}  tag={'formbase_AgeGroupCodeList'}  codelist={this.codelistModel}  placeholder={'请选择...'}  onChange={($event) =>{this.formItemChange('age', $event)}}></AppDropDownList>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.sex.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 24, offset: 0}} lg={{ span: 12, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.sex.isShowCaption && !this.detailsModel.sex.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.sex.required ? <span className="isrequired">*</span> : ""}性别
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'sex'}  validateStatus={this.detailsModel.sex.validateStatus} help={this.detailsModel.sex.error}>
                
        <AppRadioGroup value={this.data.sex}  disabled={this.detailsModel.sex.disabled}  tag={'formbase_SexCodeList'}  codelist={this.codelistModel} onChange={($event) =>{this.formItemChange('sex', $event)}}></AppRadioGroup>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.marriage.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 24, offset: 0}} lg={{ span: 12, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.marriage.isShowCaption && !this.detailsModel.marriage.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.marriage.required ? <span className="isrequired">*</span> : ""}婚否
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'marriage'}  validateStatus={this.detailsModel.marriage.validateStatus} help={this.detailsModel.marriage.error}>
                
        <AppRadioGroup value={this.data.marriage}  disabled={this.detailsModel.marriage.disabled}  tag={'formbase_YesNo'}  codelist={this.codelistModel} onChange={($event) =>{this.formItemChange('marriage', $event)}}></AppRadioGroup>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
        
            </Row>
    </Panel>
</Collapse>
    </Col>:""}
    {this.detailsModel.grouppanel1.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
        <Collapse defaultActiveKey={['grouppanel1']} className=''>
    <Panel header="家庭信息" key="grouppanel1">
        <Row>
                
        {this.detailsModel.grouppanel2.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                <Collapse defaultActiveKey={['grouppanel2']} className=''>
            <Panel header="配偶信息" key="grouppanel2">
                <Row>
                        
                {this.detailsModel.spousename.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 24, offset: 0}} lg={{ span: 8, offset: 0}} xl={{ span: 8, offset: 0}}>
                        <div className={`app-form-item app-form-item-left`}>
                    {this.detailsModel.spousename.isShowCaption && !this.detailsModel.spousename.isEmptyCaption ?
                        <div className="app-form-item-label" style={{ width: '130px' }}>
                            {this.detailsModel.spousename.required ? <span className="isrequired">*</span> : ""}配偶姓名
                        </div> : ""}
                    <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                        <Form.Item    key={'spousename'}  validateStatus={this.detailsModel.spousename.validateStatus} help={this.detailsModel.spousename.error}>
                        <Input id={'spousename'} disabled={this.detailsModel.spousename.disabled} value={this.data.spousename}     onChange={($event) =>{this.formItemChange('spousename',$event.target.value)}}/>
                        </Form.Item>
                    </div>
                </div> 
                
                    </Col>:""}
                    {this.detailsModel.spouseage.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 24, offset: 0}} lg={{ span: 8, offset: 0}} xl={{ span: 8, offset: 0}}>
                        <div className={`app-form-item app-form-item-left`}>
                    {this.detailsModel.spouseage.isShowCaption && !this.detailsModel.spouseage.isEmptyCaption ?
                        <div className="app-form-item-label" style={{ width: '130px' }}>
                            {this.detailsModel.spouseage.required ? <span className="isrequired">*</span> : ""}配偶年龄
                        </div> : ""}
                    <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                        <Form.Item    key={'spouseage'}  validateStatus={this.detailsModel.spouseage.validateStatus} help={this.detailsModel.spouseage.error}>
                        <AppDropDownList value={this.data.spouseage} disabled={this.detailsModel.spouseage.disabled}  tag={'formbase_AgeGroupCodeList'}  codelist={this.codelistModel}  placeholder={'请选择...'}  onChange={($event) =>{this.formItemChange('spouseage', $event)}}></AppDropDownList>
                        </Form.Item>
                    </div>
                </div> 
                
                    </Col>:""}
                    {this.detailsModel.spousesex.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 24, offset: 0}} lg={{ span: 8, offset: 0}} xl={{ span: 8, offset: 0}}>
                        <div className={`app-form-item app-form-item-left`}>
                    {this.detailsModel.spousesex.isShowCaption && !this.detailsModel.spousesex.isEmptyCaption ?
                        <div className="app-form-item-label" style={{ width: '130px' }}>
                            {this.detailsModel.spousesex.required ? <span className="isrequired">*</span> : ""}配偶性别
                        </div> : ""}
                    <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                        <Form.Item    key={'spousesex'}  validateStatus={this.detailsModel.spousesex.validateStatus} help={this.detailsModel.spousesex.error}>
                        
                <AppRadioGroup value={this.data.spousesex}  disabled={this.detailsModel.spousesex.disabled}  tag={'formbase_SexCodeList'}  codelist={this.codelistModel} onChange={($event) =>{this.formItemChange('spousesex', $event)}}></AppRadioGroup>
                        </Form.Item>
                    </div>
                </div> 
                
                    </Col>:""}
                
                    </Row>
            </Panel>
        </Collapse>
            </Col>:""}
            {this.detailsModel.grouppanel3.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                <Collapse defaultActiveKey={['grouppanel3']} className=''>
            <Panel header="子女信息" key="grouppanel3">
                <Row>
                        
                {this.detailsModel.childrenname.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 24, offset: 0}} lg={{ span: 12, offset: 0}} xl={{ span: 12, offset: 0}}>
                        <div className={`app-form-item app-form-item-left`}>
                    {this.detailsModel.childrenname.isShowCaption && !this.detailsModel.childrenname.isEmptyCaption ?
                        <div className="app-form-item-label" style={{ width: '130px' }}>
                            {this.detailsModel.childrenname.required ? <span className="isrequired">*</span> : ""}子女姓名
                        </div> : ""}
                    <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                        <Form.Item    key={'childrenname'}  validateStatus={this.detailsModel.childrenname.validateStatus} help={this.detailsModel.childrenname.error}>
                        <Input id={'childrenname'} disabled={this.detailsModel.childrenname.disabled} value={this.data.childrenname}     onChange={($event) =>{this.formItemChange('childrenname',$event.target.value)}}/>
                        </Form.Item>
                    </div>
                </div> 
                
                    </Col>:""}
                    {this.detailsModel.childrensex.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 24, offset: 0}} lg={{ span: 12, offset: 0}} xl={{ span: 12, offset: 0}}>
                        <div className={`app-form-item app-form-item-left`}>
                    {this.detailsModel.childrensex.isShowCaption && !this.detailsModel.childrensex.isEmptyCaption ?
                        <div className="app-form-item-label" style={{ width: '130px' }}>
                            {this.detailsModel.childrensex.required ? <span className="isrequired">*</span> : ""}子女性别
                        </div> : ""}
                    <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                        <Form.Item    key={'childrensex'}  validateStatus={this.detailsModel.childrensex.validateStatus} help={this.detailsModel.childrensex.error}>
                        
                <AppRadioGroup value={this.data.childrensex}  disabled={this.detailsModel.childrensex.disabled}  tag={'formbase_SexCodeList'}  codelist={this.codelistModel} onChange={($event) =>{this.formItemChange('childrensex', $event)}}></AppRadioGroup>
                        </Form.Item>
                    </div>
                </div> 
                
                    </Col>:""}
                    {this.detailsModel.childrenmarriage.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 24, offset: 0}} lg={{ span: 12, offset: 0}} xl={{ span: 12, offset: 0}}>
                        <div className={`app-form-item app-form-item-left`}>
                    {this.detailsModel.childrenmarriage.isShowCaption && !this.detailsModel.childrenmarriage.isEmptyCaption ?
                        <div className="app-form-item-label" style={{ width: '130px' }}>
                            {this.detailsModel.childrenmarriage.required ? <span className="isrequired">*</span> : ""}子女婚否
                        </div> : ""}
                    <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                        <Form.Item    key={'childrenmarriage'}  validateStatus={this.detailsModel.childrenmarriage.validateStatus} help={this.detailsModel.childrenmarriage.error}>
                        
                <AppRadioGroup value={this.data.childrenmarriage}  disabled={this.detailsModel.childrenmarriage.disabled}  tag={'formbase_YesNo'}  codelist={this.codelistModel} onChange={($event) =>{this.formItemChange('childrenmarriage', $event)}}></AppRadioGroup>
                        </Form.Item>
                    </div>
                </div> 
                
                    </Col>:""}
                    {this.detailsModel.childrenornot.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 24, offset: 0}} lg={{ span: 12, offset: 0}} xl={{ span: 12, offset: 0}}>
                        <div className={`app-form-item app-form-item-left`}>
                    {this.detailsModel.childrenornot.isShowCaption && !this.detailsModel.childrenornot.isEmptyCaption ?
                        <div className="app-form-item-label" style={{ width: '130px' }}>
                            {this.detailsModel.childrenornot.required ? <span className="isrequired">*</span> : ""}是否有小孩
                        </div> : ""}
                    <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                        <Form.Item    key={'childrenornot'}  validateStatus={this.detailsModel.childrenornot.validateStatus} help={this.detailsModel.childrenornot.error}>
                        
                <AppRadioGroup value={this.data.childrenornot}  disabled={this.detailsModel.childrenornot.disabled}  tag={'formbase_YesNo'}  codelist={this.codelistModel} onChange={($event) =>{this.formItemChange('childrenornot', $event)}}></AppRadioGroup>
                        </Form.Item>
                    </div>
                </div> 
                
                    </Col>:""}
                
                    </Row>
            </Panel>
        </Collapse>
            </Col>:""}
        
            </Row>
    </Panel>
</Collapse>
    </Col>:""}


                </Form>
            </div>
        </>;
    }

    /**
     * 变更监测
     *
     * @protected
     * @memberof Main
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }

}