import React, { PureComponent } from 'react';
import { Form, Input, Row, Col, Tabs, Icon, Collapse, Button, Select, message } from 'antd';
import Schema from "async-validator";
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '../../../ibizsys/form-detail';
import { Util } from '../../../ibizsys/utils/util';

import AppDropDownList  from '../../../ibizsys/components/app-dropdown-list/app-dropdown-list';
import AppRadioGroup from '../../../ibizsys/components/app-radio-group/app-radio-group';
import AppCheckBox from '../../../ibizsys/components/app-checkbox/app-checkbox';
import AppCheckBoxGroup from '../../../ibizsys/components/app-checkbox-group/app-checkbox-group';
import AppDatePicker from '../../../ibizsys/components/app-date-picker/app-date-picker';
import AppTimePicker from '../../../ibizsys/components/app-time-picker/app-time-picker';
import AppImageUpload from '../../../ibizsys/components/app-image-upload/app-image-upload';
import AppFileUpload from '../../../ibizsys/components/app-file-upload/app-file-upload';
import AppRichTextEditor from '../../../ibizsys/components/app-rich-text-editor/app-rich-text-editor';

import './main.less';
const { TabPane } = Tabs;
const { Panel } = Collapse;
const { Option } = Select;
const { TextArea  } = Input;

/**
 * 表单属性
 *
 * @export
 * @interface MainFormData
 */
export class MainFormData {
    /**
     * 实体2名称
     *
     * @type {*}
     * @memberof MainFormData
     */
    entity2name?: any;
    /**
     * 建立人
     *
     * @type {*}
     * @memberof MainFormData
     */
    createman?: any;
    /**
     * 建立时间
     *
     * @type {*}
     * @memberof MainFormData
     */
    createdate?: any;
    /**
     * 更新人
     *
     * @type {*}
     * @memberof MainFormData
     */
    updateman?: any;
    /**
     * 更新时间
     *
     * @type {*}
     * @memberof MainFormData
     */
    updatedate?: any;
    /**
     * 实体2标识
     *
     * @type {*}
     * @memberof MainFormData
     */
    entity2id?: any;
}

/**
 * 输入属性
 *
 * @export
 * @interface MainProps
 */
export interface MainProps {
    /**
     * 表单数据对象
     *
     * @type {MainFormData}
     * @memberof MainProps
     */
    data?: MainFormData;
    /**
     * 表单分页切换
     *
     * @memberof MainProps
     */
    tabChange?: (key: string) => void;
    /**
     * 表单项之变化
     *
     * @memberof MainProps
     */
    formItemChange?:(key:any) => void;
}

/**
 * Main
 *
 * @export
 * @class Main
 * @extends {PureComponent}
 */
export default class Main extends PureComponent<MainProps> {
    /**
     * 表单数据
     *
     * @type {*}
     * @memberof Main
     */
    public data: MainFormData = new MainFormData();

    /**
     * 初始化实例
     *
     * @type {*}
     * @memberof Main
     */
    constructor(props) {
        super(props);
        if (this.data && this.props.data && !Object.is(JSON.stringify(this.data), JSON.stringify(this.props.data))) {
            Object.assign(this.data, this.props.data);
        }
        this.initForm();
    }
    
    /**
     * 在组件接收到一个新的 prop (或更新后)时被调用
     *
     * @memberof IBizViewController
     */
    public componentWillReceiveProps(nextProps: Readonly<MainProps>, nextContext: any) {
        if (this.data && nextProps.data && !Object.is(JSON.stringify(this.data), JSON.stringify(nextProps.data))) {
            Object.assign(this.data, nextProps.data);
        }
    }

    /**
     * 在组件从 DOM 中移除的时候立刻被调用
     *
     * @memberof IBizViewController
     */
    public componentWillUnmount() {

    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof Main
     */
    public rules: any = {
        srfupdatedate: [
            { type: 'string', message: '更新时间 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '更新时间 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '更新时间 值不能为空', trigger: 'blur' },
        ],
        srforikey: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfkey: [
            { type: 'string', message: '实体2标识 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '实体2标识 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '实体2标识 值不能为空', trigger: 'blur' },
        ],
        srfmajortext: [
            { type: 'string', message: '实体2名称 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '实体2名称 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '实体2名称 值不能为空', trigger: 'blur' },
        ],
        srftempmode: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfuf: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfdeid: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfsourcekey: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        entity2name: [
            { type: 'string', message: '实体2名称 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '实体2名称 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '实体2名称 值不能为空', trigger: 'blur' },
        ],
        createman: [
            { type: 'string', message: '建立人 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '建立人 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '建立人 值不能为空', trigger: 'blur' },
        ],
        createdate: [
            { type: 'string', message: '建立时间 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '建立时间 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '建立时间 值不能为空', trigger: 'blur' },
        ],
        updateman: [
            { type: 'string', message: '更新人 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '更新人 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '更新人 值不能为空', trigger: 'blur' },
        ],
        updatedate: [
            { type: 'string', message: '更新时间 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '更新时间 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '更新时间 值不能为空', trigger: 'blur' },
        ],
        entity2id: [
            { type: 'string', message: '实体2标识 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '实体2标识 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '实体2标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof Main
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '实体2基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this })
,
        group2: new FormGroupPanelModel({ caption: '操作信息', detailType: 'GROUPPANEL', name: 'group2', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        formpage2: new FormPageModel({ caption: '其它', detailType: 'FORMPAGE', name: 'formpage2', visible: true, isShowCaption: true, form: this })
,
        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfkey: new FormItemModel({ caption: '实体2标识', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfmajortext: new FormItemModel({ caption: '实体2名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        entity2name: new FormItemModel({ caption: '实体2名称', detailType: 'FORMITEM', name: 'entity2name', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        createman: new FormItemModel({ caption: '建立人', detailType: 'FORMITEM', name: 'createman', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        createdate: new FormItemModel({ caption: '建立时间', detailType: 'FORMITEM', name: 'createdate', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        updateman: new FormItemModel({ caption: '更新人', detailType: 'FORMITEM', name: 'updateman', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        updatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'updatedate', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        entity2id: new FormItemModel({ caption: '实体2标识', detailType: 'FORMITEM', name: 'entity2id', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        form: new FormTabPanelModel({ caption: 'form', detailType: 'TABPANEL', name: 'form', visible: true, isShowCaption: true, form: this, tabPages: [{ name: 'formpage1', index: 0, visible: true }, { name: 'formpage2', index: 1, visible: true }] }),
    }

    /**
      * 代码表模型
      *
      * @type {*}
      * @memberof Main
      */      
    public codelistModel:any = {
      }

    /**
     * 表单逻辑
     *
     * @private
     * @param { name, newVal, oldVal }
     * @memberof Main
     */
    private formLogic(name: string, newVal: any, oldVal?: any): void {
                


















    }


    /**
     * 表单分页切换
     *
     * @param {string} key 分页标识
     * @memberof Main
     */
    public tabChange(key: string): void {
        if (this.props.tabChange) {
            this.props.tabChange(key);
        }
    }

    /**
     * 表单值变化事件
     *
     * @memberof Main
     */
    public formItemChange(item: string, value: any, isFirst?: boolean) {
        this.data[item] = value;
        this.formLogic(item, value);
        if (!isFirst) {
            this.validateItem(item, value);
            if (this.props.formItemChange) {
                this.props.formItemChange({name:item,value:value});
            }
        }
        this.tick();
    }

    /**
     * 按钮点击事件
     *
     * @memberof Main
     */
    public buttonClick($event:any,value:String){
        message.info('点击了'+value);
    }

    /**
     * 初始化表单
     * 
     * @memberof Main
     */
    public initForm() {
        if (Object.keys(this.data).length > 0) {
            Object.keys(this.data).forEach((item) => {
                this.formItemChange(item, this.data[item], true);
            })
        }
    }

    /**
     * 校验单个表单项
     * @param item 
     * @param value 
     */
    public validateItem(item: string, value: any) {
        // 做校验
        // 1.获取数值和规则
        const rule = this.rules[item];
        // 2.创建校验规则
        const schema = new Schema({ [item]: rule })
        // 校验返回Promise
        return schema.validate({ [item]: value },undefined,errors => {
            if (errors) {
                // 有错
                this.detailsModel[item].setError(errors[0].message);
            } else {
                this.detailsModel[item].setError('');
            }
        })
    }

    /**
     * 校验表单
     * 
     * @memberof Main
     */
    public validateForm(callback:Function) {
        let tasks: any;
        if (Object.keys(this.data).length > 0) {
            tasks = Object.keys(this.data).map((item) => {
                this.validateItem(item, this.data[item]);
            })
        }
        Promise.all(tasks)
            .then(() => callback(true))
            .catch(() => callback(false))
    }

    /**
     * 绘制内容
     *
     * @returns
     * @memberof Main
     */
    public render(): any {
        return <>
            <div className="ibiz-form main">
                <Form layout="inline">
                    <Tabs defaultActiveKey="1" onChange={(key: string) => this.tabChange(key)}>
                        <TabPane 
                            tab={
                                <span className='caption'>
                                    基本信息
                                </span>
                            } 
                            key="0">
                                {this.detailsModel.group1.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
            <Collapse defaultActiveKey={['group1']} className=''>
        <Panel header="实体2基本信息" key="group1">
            <Row>
                    
            {this.detailsModel.entity2name.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                    <div className={`app-form-item app-form-item-left`}>
                {this.detailsModel.entity2name.isShowCaption && !this.detailsModel.entity2name.isEmptyCaption ?
                    <div className="app-form-item-label" style={{ width: '130px' }}>
                        {this.detailsModel.entity2name.required ? <span className="isrequired">*</span> : ""}实体2名称
                    </div> : ""}
                <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                    <Form.Item    key={'entity2name'}  validateStatus={this.detailsModel.entity2name.validateStatus} help={this.detailsModel.entity2name.error}>
                    <Input id={'entity2name'} disabled={this.detailsModel.entity2name.disabled} value={this.data.entity2name}     onChange={($event) =>{this.formItemChange('entity2name',$event.target.value)}}/>
                    </Form.Item>
                </div>
            </div> 
            
                </Col>:""}
            
                </Row>
        </Panel>
    </Collapse>
        </Col>:""}

                        </TabPane>
                        <TabPane 
                            tab={
                                <span className='caption'>
                                    其它
                                </span>
                            } 
                            key="1">
                                {this.detailsModel.group2.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
            <Collapse defaultActiveKey={['group2']} className=''>
        <Panel header="操作信息" key="group2">
            <Row>
                    
            {this.detailsModel.createman.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                    <div className={`app-form-item app-form-item-left`}>
                {this.detailsModel.createman.isShowCaption && !this.detailsModel.createman.isEmptyCaption ?
                    <div className="app-form-item-label" style={{ width: '130px' }}>
                        {this.detailsModel.createman.required ? <span className="isrequired">*</span> : ""}建立人
                    </div> : ""}
                <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                    <Form.Item    key={'createman'}  validateStatus={this.detailsModel.createman.validateStatus} help={this.detailsModel.createman.error}>
                    <span>{this.data.createman}</span>
                    </Form.Item>
                </div>
            </div> 
            
                </Col>:""}
                {this.detailsModel.createdate.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                    <div className={`app-form-item app-form-item-left`}>
                {this.detailsModel.createdate.isShowCaption && !this.detailsModel.createdate.isEmptyCaption ?
                    <div className="app-form-item-label" style={{ width: '130px' }}>
                        {this.detailsModel.createdate.required ? <span className="isrequired">*</span> : ""}建立时间
                    </div> : ""}
                <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                    <Form.Item    key={'createdate'}  validateStatus={this.detailsModel.createdate.validateStatus} help={this.detailsModel.createdate.error}>
                    <span>{this.data.createdate}</span>
                    </Form.Item>
                </div>
            </div> 
            
                </Col>:""}
                {this.detailsModel.updateman.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                    <div className={`app-form-item app-form-item-left`}>
                {this.detailsModel.updateman.isShowCaption && !this.detailsModel.updateman.isEmptyCaption ?
                    <div className="app-form-item-label" style={{ width: '130px' }}>
                        {this.detailsModel.updateman.required ? <span className="isrequired">*</span> : ""}更新人
                    </div> : ""}
                <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                    <Form.Item    key={'updateman'}  validateStatus={this.detailsModel.updateman.validateStatus} help={this.detailsModel.updateman.error}>
                    <span>{this.data.updateman}</span>
                    </Form.Item>
                </div>
            </div> 
            
                </Col>:""}
                {this.detailsModel.updatedate.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                    <div className={`app-form-item app-form-item-left`}>
                {this.detailsModel.updatedate.isShowCaption && !this.detailsModel.updatedate.isEmptyCaption ?
                    <div className="app-form-item-label" style={{ width: '130px' }}>
                        {this.detailsModel.updatedate.required ? <span className="isrequired">*</span> : ""}更新时间
                    </div> : ""}
                <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                    <Form.Item    key={'updatedate'}  validateStatus={this.detailsModel.updatedate.validateStatus} help={this.detailsModel.updatedate.error}>
                    <span>{this.data.updatedate}</span>
                    </Form.Item>
                </div>
            </div> 
            
                </Col>:""}
            
                </Row>
        </Panel>
    </Collapse>
        </Col>:""}

                        </TabPane>
                    </Tabs>
                </Form>
            </div>
        </>;
    }

    /**
     * 变更监测
     *
     * @protected
     * @memberof Main
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }

}