import React, { PureComponent } from 'react';
import { Form, Input, Row, Col, Tabs, Icon, Collapse, Button, Select, message } from 'antd';
import Schema from "async-validator";
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '../../../ibizsys/form-detail';
import { Util } from '../../../ibizsys/utils/util';

import AppDropDownList  from '../../../ibizsys/components/app-dropdown-list/app-dropdown-list';
import AppRadioGroup from '../../../ibizsys/components/app-radio-group/app-radio-group';
import AppCheckBox from '../../../ibizsys/components/app-checkbox/app-checkbox';
import AppCheckBoxGroup from '../../../ibizsys/components/app-checkbox-group/app-checkbox-group';
import AppDatePicker from '../../../ibizsys/components/app-date-picker/app-date-picker';
import AppTimePicker from '../../../ibizsys/components/app-time-picker/app-time-picker';
import AppImageUpload from '../../../ibizsys/components/app-image-upload/app-image-upload';
import AppFileUpload from '../../../ibizsys/components/app-file-upload/app-file-upload';
import AppRichTextEditor from '../../../ibizsys/components/app-rich-text-editor/app-rich-text-editor';

import './main2.less';
const { TabPane } = Tabs;
const { Panel } = Collapse;
const { Option } = Select;
const { TextArea  } = Input;

/**
 * 表单属性
 *
 * @export
 * @interface Main2FormData
 */
export class Main2FormData {
    /**
     * 示例标识
     *
     * @type {*}
     * @memberof Main2FormData
     */
    exampleid?: any;
}

/**
 * 输入属性
 *
 * @export
 * @interface Main2Props
 */
export interface Main2Props {
    /**
     * 表单数据对象
     *
     * @type {Main2FormData}
     * @memberof Main2Props
     */
    data?: Main2FormData;
    /**
     * 表单分页切换
     *
     * @memberof Main2Props
     */
    tabChange?: (key: string) => void;
    /**
     * 表单项之变化
     *
     * @memberof MainProps
     */
    formItemChange?:(key:any) => void;
}

/**
 * Main2
 *
 * @export
 * @class Main2
 * @extends {PureComponent}
 */
export default class Main2 extends PureComponent<Main2Props> {
    /**
     * 表单数据
     *
     * @type {*}
     * @memberof Main2
     */
    public data: Main2FormData = new Main2FormData();

    /**
     * 初始化实例
     *
     * @type {*}
     * @memberof Main2
     */
    constructor(props) {
        super(props);
        if (this.data && this.props.data && !Object.is(JSON.stringify(this.data), JSON.stringify(this.props.data))) {
            Object.assign(this.data, this.props.data);
        }
        this.initForm();
    }
    
    /**
     * 在组件接收到一个新的 prop (或更新后)时被调用
     *
     * @memberof IBizViewController
     */
    public componentWillReceiveProps(nextProps: Readonly<Main2Props>, nextContext: any) {
        if (this.data && nextProps.data && !Object.is(JSON.stringify(this.data), JSON.stringify(nextProps.data))) {
            Object.assign(this.data, nextProps.data);
        }
    }

    /**
     * 在组件从 DOM 中移除的时候立刻被调用
     *
     * @memberof IBizViewController
     */
    public componentWillUnmount() {

    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof Main2
     */
    public rules: any = {
        srfupdatedate: [
            { type: 'string', message: '更新时间 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '更新时间 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '更新时间 值不能为空', trigger: 'blur' },
        ],
        srforikey: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfkey: [
            { type: 'string', message: '示例标识 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '示例标识 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '示例标识 值不能为空', trigger: 'blur' },
        ],
        srfmajortext: [
            { type: 'string', message: '示例名称 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '示例名称 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '示例名称 值不能为空', trigger: 'blur' },
        ],
        srftempmode: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfuf: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfdeid: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfsourcekey: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        exampleid: [
            { type: 'string', message: '示例标识 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '示例标识 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '示例标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof Main2
     */
    public detailsModel: any = {
        tabpanel1: new FormTabPanelModel({ caption: '', detailType: 'TABPANEL', name: 'tabpanel1', visible: true, isShowCaption: false, form: this, tabPages: [] })
,
        formpage1: new FormPageModel({ caption: '表单分页', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this })
,
        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfkey: new FormItemModel({ caption: '示例标识', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfmajortext: new FormItemModel({ caption: '示例名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        exampleid: new FormItemModel({ caption: '示例标识', detailType: 'FORMITEM', name: 'exampleid', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
    }

    /**
      * 代码表模型
      *
      * @type {*}
      * @memberof Main2
      */      
    public codelistModel:any = {
      }

    /**
     * 表单逻辑
     *
     * @private
     * @param { name, newVal, oldVal }
     * @memberof Main2
     */
    private formLogic(name: string, newVal: any, oldVal?: any): void {
                











    }


    /**
     * 表单分页切换
     *
     * @param {string} key 分页标识
     * @memberof Main2
     */
    public tabChange(key: string): void {
        if (this.props.tabChange) {
            this.props.tabChange(key);
        }
    }

    /**
     * 表单值变化事件
     *
     * @memberof Main2
     */
    public formItemChange(item: string, value: any, isFirst?: boolean) {
        this.data[item] = value;
        this.formLogic(item, value);
        if (!isFirst) {
            this.validateItem(item, value);
            if (this.props.formItemChange) {
                this.props.formItemChange({name:item,value:value});
            }
        }
        this.tick();
    }

    /**
     * 按钮点击事件
     *
     * @memberof Main2
     */
    public buttonClick($event:any,value:String){
        message.info('点击了'+value);
    }

    /**
     * 初始化表单
     * 
     * @memberof Main2
     */
    public initForm() {
        if (Object.keys(this.data).length > 0) {
            Object.keys(this.data).forEach((item) => {
                this.formItemChange(item, this.data[item], true);
            })
        }
    }

    /**
     * 校验单个表单项
     * @param item 
     * @param value 
     */
    public validateItem(item: string, value: any) {
        // 做校验
        // 1.获取数值和规则
        const rule = this.rules[item];
        // 2.创建校验规则
        const schema = new Schema({ [item]: rule })
        // 校验返回Promise
        return schema.validate({ [item]: value },undefined,errors => {
            if (errors) {
                // 有错
                this.detailsModel[item].setError(errors[0].message);
            } else {
                this.detailsModel[item].setError('');
            }
        })
    }

    /**
     * 校验表单
     * 
     * @memberof Main2
     */
    public validateForm(callback:Function) {
        let tasks: any;
        if (Object.keys(this.data).length > 0) {
            tasks = Object.keys(this.data).map((item) => {
                this.validateItem(item, this.data[item]);
            })
        }
        Promise.all(tasks)
            .then(() => callback(true))
            .catch(() => callback(false))
    }

    /**
     * 绘制内容
     *
     * @returns
     * @memberof Main2
     */
    public render(): any {
        return <>
            <div className="ibiz-form main2">
                <Form layout="inline">
                {this.detailsModel.tabpanel1.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
        <Tabs    className="">
</Tabs>

    </Col>:""}


                </Form>
            </div>
        </>;
    }

    /**
     * 变更监测
     *
     * @protected
     * @memberof Main
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }

}