import React, { PureComponent } from 'react';
import { Checkbox } from 'antd';

import './app-checkbox.less';

/**
 * 输入属性
 *
 * @export
 * @interface CheckboxProps
 */
export interface CheckboxProps {
    /**
     * 传入表单项值
     *
     * @type {any}
     * @memberof CheckboxProps
     */
    value?: any;

    /**
     * 是否禁用
     * 
     *  @type {boolean}
     * @memberof CheckboxProps
     */
    disabled: boolean;

    /**
     * 值变化事件
     *
     * @memberof CheckboxProps
     */
    onChange: (value: string) => void;
}

/**
 * BookTestEditView
 *
 * @export
 * @class BookTestEditView
 * @extends {PureComponent}
 */
export default class AppCheckBox extends PureComponent<CheckboxProps> {

    /**
     * 绑定值
     */
    public currentValue: any = undefined;

    /**
     * 是否禁用
     */
    public curDisabled:boolean = false;

    constructor(props) {
        super(props);
        if (props.value) {
            this.currentValue = props.value;
        }else{
            this.currentValue = false;
        }
        if(props.disabled){
            this.curDisabled = true;
        }else{
            this.curDisabled = false;
        }
    }

    /**
     * 在组件接收到一个新的 prop (或更新后)时被调用
     *
     * @memberof AppDropDownList
     */
    public componentWillReceiveProps(nextProps: Readonly<CheckboxProps>, nextContext: any) {
        if (nextProps.value) {
            this.currentValue = nextProps.value;
        }else{
            this.currentValue = false;
        }
        if(nextProps.disabled){
            this.curDisabled = true;
        }else{
            this.curDisabled = false;
        }
    }


    /**
     * 绘制内容
     *
     * @returns
     * @memberof AppDropDownList
     */
    public render() {
        return (<Checkbox checked={this.currentValue}  disabled={this.curDisabled}  onChange={($event) =>{this.handleChange($event)}}></Checkbox>);
    }

    /**
     * 值变化事件
     * 
     * @param $event
     * @memberof AppDropDownList 
     */
    public handleChange($event){
        this.props.onChange($event.target.checked);
    }

    /**
     * 变更监测
     *
     * @protected
     * @memberof AppDropDownList
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }

}