
import React, { PureComponent } from 'react';
import { TimePicker } from 'antd';

import './app-time-picker.less';

/**
 * 输入属性
 *
 * @export
 * @interface TimeProps
 */
export interface TimeProps {
    /**
     * 传入表单项值
     *
     * @type {any}
     * @memberof TimeProps
     */
    value?: any;

    /**
     * 是否禁用
     * 
     *  @type {boolean}
     * @memberof TimeProps
     */
    disabled: boolean;

    /**
     * 提示信息
     * 
     * @type {string}
     * @memberof TimeProps
     */
    placeholder?: string;

    /**
     * 时间格式
     * 
     * @type {string}
     * @memberof TimeProps
     */
    format?: string;

    /**
     * 是否展示时间
     */
    showTime?:boolean;

    /**
     * 值变化事件
     *
     * @memberof TimeProps
     */
    onChange: (value: string) => void;
}


const moment = require("moment");

/**
 * BookTestEditView
 *
 * @export
 * @class BookTestEditView
 * @extends {PureComponent}
 */
export default class AppTimePicker extends PureComponent<TimeProps> {

    /**
     * 绑定值
     */
    public currentValue: any = undefined;

    /**
     * 是否禁用
     */
    public curDisabled: boolean = false;

    /**
     * 当前日期格式
     */
    public curFormat: string = "HH:mm:ss";

    constructor(props) {
        super(props);
        if (props.value) {
            this.currentValue = props.value ? moment(props.value,this.curFormat) : null;
        } else {
            this.currentValue = null;
        }
        if (props.disabled) {
            this.curDisabled = true;
        } else {
            this.curDisabled = false;
        }
        if (props.format) {
            this.curFormat = props.format;
        } else {
            this.curFormat = "HH:mm:ss";
        }
    }

    /**
     * 在组件接收到一个新的 prop (或更新后)时被调用
     *
     * @memberof AppTimePicker
     */
    public componentWillReceiveProps(nextProps: Readonly<TimeProps>, nextContext: any) {
        if (nextProps.value) {
            this.currentValue = nextProps.value ? moment(nextProps.value,this.curFormat) : null;
        } else {
            this.currentValue = null;
        }
        if (nextProps.disabled) {
            this.curDisabled = true;
        } else {
            this.curDisabled = false;
        }
    }


    /**
     * 绘制内容
     *
     * @returns
     * @memberof AppTimePicker
     */
    public render() {
        return (
            <TimePicker value={this.currentValue} format={this.curFormat} disabled={this.curDisabled} onChange={(date: any, dateString: string) => { this.handleChange(date, dateString) }} />
        );
    }

    /**
     * 值变化事件
     * 
     * @param $event
     * @memberof AppTimePicker 
     */
    public handleChange(date: any, dateString: string) {
        this.props.onChange(dateString);
    }

    /**
     * 变更监测
     *
     * @protected
     * @memberof AppTimePicker
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }

}