import React, { PureComponent } from 'react';
import EntityEditView from './pages/module/entity-edit-view/entity-edit-view';
import ExampleEditorType from './pages/exapmple/example-editor-type/example-editor-type';
import ExampleEditView from './pages/exapmple/example-edit-view/example-edit-view';
import Entity3EditView from './pages/module3/entity3-edit-view/entity3-edit-view';
import Entity4EditView from './pages/module4/entity4-edit-view/entity4-edit-view';
import Entity5EditView from './pages/module5/entity5-edit-view/entity5-edit-view';
import ExampleDLFEditView from './pages/exapmple/example-dlfedit-view/example-dlfedit-view';
import Entity2EditView from './pages/module2/entity2-edit-view/entity2-edit-view';
import './App.less';
import { Layout, Menu, Breadcrumb, Icon } from 'antd';
const { Header, Content, Footer, Sider } = Layout;
const { SubMenu } = Menu;


/**
 * App
 *
 * @export
 * @class App
 * @extends {PureComponent}
 */
export default class App extends PureComponent {

     /**
     * 当前页面
     */
    public currentPage: string = "EntityEditView";

    /**
     * 处理菜单点击
     * @param item 
     * @param key 
     * @param keyPath 
     * @param domEvent 
     */
    public handleMenuClick(item, key, keyPath, domEvent) {
        this.currentPage = key;
        this.tick();
    }

    /**
     * 获取当前视图
     */
    public getCurPage(): any {
        if (Object.is(this.currentPage, "EntityEditView")) {
            return <EntityEditView/>;
        }
        if (Object.is(this.currentPage, "ExampleEditorType")) {
            return <ExampleEditorType/>;
        }
        if (Object.is(this.currentPage, "ExampleEditView")) {
            return <ExampleEditView/>;
        }
        if (Object.is(this.currentPage, "Entity3EditView")) {
            return <Entity3EditView/>;
        }
        if (Object.is(this.currentPage, "Entity4EditView")) {
            return <Entity4EditView/>;
        }
        if (Object.is(this.currentPage, "Entity5EditView")) {
            return <Entity5EditView/>;
        }
        if (Object.is(this.currentPage, "ExampleDLFEditView")) {
            return <ExampleDLFEditView/>;
        }
        if (Object.is(this.currentPage, "Entity2EditView")) {
            return <Entity2EditView/>;
        }
    }

    /**
     * 变更监测
     *
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }


    /**
     * 渲染视图
     *
     * @returns
     * @memberof App
     */
    public render() {
        return <div className="App">
            <Layout id="components-layout-demo-custom-trigger">
                <Sider trigger={null} collapsible style={{ minHeight: '100vh' }}>
                    <div className="logo"><img src="assets/images/logo.png" /></div>
                    <Menu theme="dark" mode="inline" defaultSelectedKeys={['"EntityEditView""ExampleEditorType""ExampleEditView""Entity3EditView""Entity4EditView""Entity5EditView""ExampleDLFEditView""Entity2EditView"']} onClick={({ item, key, keyPath, domEvent }) => { this.handleMenuClick(item, key, keyPath, domEvent) }}>
                        <Menu.Item key="EntityEditView">
                            <Icon type="user" />
                            <span>实体编辑视图</span>
                        </Menu.Item>
                        <Menu.Item key="ExampleEditorType">
                            <Icon type="video-camera" />
                            <span>基础编辑器</span>
                        </Menu.Item>
                        <Menu.Item key="ExampleEditView">
                            <Icon type="upload" />
                            <span>基础表单项</span>
                        </Menu.Item>
                        <Menu.Item key="Entity3EditView">
                            <Icon type="user" />
                            <span>实体3编辑视图</span>
                        </Menu.Item>
                        <Menu.Item key="Entity4EditView">
                            <Icon type="video-camera" />
                            <span>实体4编辑视图</span>
                        </Menu.Item>
                        <Menu.Item key="Entity5EditView">
                            <Icon type="upload" />
                            <span>实体5编辑视图</span>
                        </Menu.Item>
                        <Menu.Item key="ExampleDLFEditView">
                            <Icon type="user" />
                            <span>表单项动态逻辑示例</span>
                        </Menu.Item>
                        <Menu.Item key="Entity2EditView">
                            <Icon type="video-camera" />
                            <span>实体2编辑视图</span>
                        </Menu.Item>
                    </Menu>
                </Sider>
                <Layout>
                    <Content
                        style={{
                            margin: '24px 16px',
                            padding: 24,
                            background: '#fff',
                            minHeight: 280,
                        }}>
                        {this.getCurPage()}
                    </Content>
                </Layout>
            </Layout>
        </div>;
    }

}