
import React, { PureComponent } from 'react';
import { Upload, Button, Icon } from 'antd';

import './app-file-upload.less';

/**
 * 输入属性
 *
 * @export
 * @interface FileUploadProps
 */
export interface FileUploadProps {
    /**
     * 传入表单项值
     *
     * @type {any}
     * @memberof FileUploadProps
     */
    value: any;

    /**
     * 是否禁用
     * 
     *  @type {boolean}
     * @memberof FileUploadProps
     */
    disabled?: boolean;

    /**
     * 上传参数
     */
    uploadparams?: string;

    /**
     * 导出参数
     */
    exportparams?: string;

    /**
     * 自定义参数
     */
    customparams?: Object;

    /**
     * 值变化事件
     *
     * @memberof FileUploadProps
     */
    onChange: (value: string) => void;
}

/**
 * BookTestEditView
 *
 * @export
 * @class BookTestEditView
 * @extends {PureComponent}
 */
export default class AppFileUpload extends PureComponent<FileUploadProps> {

    /**
     * 文件集合
     */
    public currentValue: Array<any> = [];

    /**
     * 是否禁用
     */
    public curDisabled: boolean = false;

    /**
     * 上传路径
     */
    public uploadUrl: string = "https://www.mocky.io/v2/5cc8019d300000980a055e76";

    constructor(props) {
        super(props);
        if (props.value) {
            this.currentValue = this.handleInputData(props.value);
        } else {
            this.currentValue = [];
        }
        if (props.disabled) {
            this.curDisabled = true;
        } else {
            this.curDisabled = false;
        }
    }

    /**
     * 在组件接收到一个新的 prop (或更新后)时被调用
     *
     * @memberof AppFileUpload
     */
    public componentWillReceiveProps(nextProps: Readonly<FileUploadProps>, nextContext: any) {
        if (nextProps.value) {
            this.currentValue = this.handleInputData(nextProps.value);
        } else {
            this.currentValue = [];
        }
        if (nextProps.disabled) {
            this.curDisabled = true;
        } else {
            this.curDisabled = false;
        }
    }

    /**
     * 绘制内容
     *
     * @returns
     * @memberof AppFileUpload
     */
    public render() {
        return (
            <div className="clearfix">
                <Upload action={this.uploadUrl}
                    disabled={this.curDisabled}
                    fileList={this.currentValue}
                    onChange={this.handleChange} >
                    <Button>
                        <Icon type="upload" /> Upload
                    </Button>
                </Upload>
            </div>
        );
    }

    /**
     * 处理输入参数
     * @param fileList 
     */
    public handleInputData(fileList: any) {
        //todo
        return JSON.parse(fileList);
    }

    /**
     * 处理输出参数
     * @param fileList 
     */
    public handleOutData(fileList: any) {
        //todo
        return JSON.stringify(fileList);
    }

    /**
     * 值变化事件
     * 
     * @param $event
     * @memberof AppFileUpload 
     */
    public handleChange = ({ fileList }) => {
        this.props.onChange(this.handleOutData(fileList));
    }

    /**
     * 变更监测
     *
     * @protected
     * @memberof AppFileUpload
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }

}
