import React, { PureComponent } from 'react';
import { Form, Input, Row, Col, Tabs, Icon, Collapse, Button, Select, message } from 'antd';
import Schema from "async-validator";
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '../../../ibizsys/form-detail';
import { Util } from '../../../ibizsys/utils/util';

import AppDropDownList  from '../../../ibizsys/components/app-dropdown-list/app-dropdown-list';
import AppRadioGroup from '../../../ibizsys/components/app-radio-group/app-radio-group';
import AppCheckBox from '../../../ibizsys/components/app-checkbox/app-checkbox';
import AppCheckBoxGroup from '../../../ibizsys/components/app-checkbox-group/app-checkbox-group';
import AppDatePicker from '../../../ibizsys/components/app-date-picker/app-date-picker';
import AppTimePicker from '../../../ibizsys/components/app-time-picker/app-time-picker';
import AppImageUpload from '../../../ibizsys/components/app-image-upload/app-image-upload';
import AppFileUpload from '../../../ibizsys/components/app-file-upload/app-file-upload';
import AppRichTextEditor from '../../../ibizsys/components/app-rich-text-editor/app-rich-text-editor';

import './all-editor-type.less';
const { TabPane } = Tabs;
const { Panel } = Collapse;
const { Option } = Select;
const { TextArea  } = Input;

/**
 * 表单属性
 *
 * @export
 * @interface AllEditorTypeFormData
 */
export class AllEditorTypeFormData {
    /**
     * 标签
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    span?: any;
    /**
     * 文本框
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    textbox?: any;
    /**
     * 密码输入框
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    password?: any;
    /**
     * 直接内容
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    rawitem?: any;
    /**
     * 选项框
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    checkbox?: any;
    /**
     * 选项框列表
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    checkboxlist?: any;
    /**
     * 下拉列表
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    dropdownlist?: any;
    /**
     * 列表框
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    listbox?: any;
    /**
     * 单选项列表
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    formitem1?: any;
    /**
     * 时间选择
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    datepicker?: any;
    /**
     * 无小时
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    formitem?: any;
    /**
     * 无日期
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    formitem6?: any;
    /**
     * 小时
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    formitem7?: any;
    /**
     * 分钟
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    formitem8?: any;
    /**
     * 秒钟
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    formitem9?: any;
    /**
     * 无日期无秒钟
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    formitem10?: any;
    /**
     * 多行输入框
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    textrea?: any;
    /**
     * HTML编辑框
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    formitem2?: any;
    /**
     * 图片上传
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    formitem4?: any;
    /**
     * 文件上传
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    formitem5?: any;
    /**
     * 示例标识
     *
     * @type {*}
     * @memberof AllEditorTypeFormData
     */
    exampleid?: any;
}

/**
 * 输入属性
 *
 * @export
 * @interface AllEditorTypeProps
 */
export interface AllEditorTypeProps {
    /**
     * 表单数据对象
     *
     * @type {AllEditorTypeFormData}
     * @memberof AllEditorTypeProps
     */
    data?: AllEditorTypeFormData;
    /**
     * 表单分页切换
     *
     * @memberof AllEditorTypeProps
     */
    tabChange?: (key: string) => void;
    /**
     * 表单项之变化
     *
     * @memberof MainProps
     */
    formItemChange?:(key:any) => void;
}

/**
 * AllEditorType
 *
 * @export
 * @class AllEditorType
 * @extends {PureComponent}
 */
export default class AllEditorType extends PureComponent<AllEditorTypeProps> {
    /**
     * 表单数据
     *
     * @type {*}
     * @memberof AllEditorType
     */
    public data: AllEditorTypeFormData = new AllEditorTypeFormData();

    /**
     * 初始化实例
     *
     * @type {*}
     * @memberof AllEditorType
     */
    constructor(props) {
        super(props);
        if (this.data && this.props.data && !Object.is(JSON.stringify(this.data), JSON.stringify(this.props.data))) {
            Object.assign(this.data, this.props.data);
        }
        this.initForm();
    }
    
    /**
     * 在组件接收到一个新的 prop (或更新后)时被调用
     *
     * @memberof IBizViewController
     */
    public componentWillReceiveProps(nextProps: Readonly<AllEditorTypeProps>, nextContext: any) {
        if (this.data && nextProps.data && !Object.is(JSON.stringify(this.data), JSON.stringify(nextProps.data))) {
            Object.assign(this.data, nextProps.data);
        }
    }

    /**
     * 在组件从 DOM 中移除的时候立刻被调用
     *
     * @memberof IBizViewController
     */
    public componentWillUnmount() {

    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof AllEditorType
     */
    public rules: any = {
        srfupdatedate: [
            { type: 'string', message: '更新时间 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '更新时间 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '更新时间 值不能为空', trigger: 'blur' },
        ],
        srforikey: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfkey: [
            { type: 'string', message: '示例标识 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '示例标识 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '示例标识 值不能为空', trigger: 'blur' },
        ],
        srfmajortext: [
            { type: 'string', message: '示例名称 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '示例名称 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '示例名称 值不能为空', trigger: 'blur' },
        ],
        srftempmode: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfuf: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfdeid: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfsourcekey: [
            { type: 'string', message: ' 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        span: [
            { type: 'string', message: '标签 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '标签 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '标签 值不能为空', trigger: 'blur' },
        ],
        textbox: [
            { type: 'string', message: '文本框 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '文本框 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '文本框 值不能为空', trigger: 'blur' },
        ],
        password: [
            { type: 'string', message: '密码输入框 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '密码输入框 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '密码输入框 值不能为空', trigger: 'blur' },
        ],
        rawitem: [
            { type: 'string', message: '直接内容 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '直接内容 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '直接内容 值不能为空', trigger: 'blur' },
        ],
        checkbox: [
            { type: 'string', message: '选项框 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '选项框 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '选项框 值不能为空', trigger: 'blur' },
        ],
        checkboxlist: [
            { type: 'string', message: '选项框列表 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '选项框列表 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '选项框列表 值不能为空', trigger: 'blur' },
        ],
        dropdownlist: [
            { type: 'string', message: '下拉列表 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '下拉列表 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '下拉列表 值不能为空', trigger: 'blur' },
        ],
        listbox: [
            { type: 'string', message: '列表框 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '列表框 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '列表框 值不能为空', trigger: 'blur' },
        ],
        formitem1: [
            { type: 'string', message: '单选项列表 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '单选项列表 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '单选项列表 值不能为空', trigger: 'blur' },
        ],
        datepicker: [
            { type: 'string', message: '时间选择 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '时间选择 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '时间选择 值不能为空', trigger: 'blur' },
        ],
        formitem: [
            { type: 'string', message: '无小时 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '无小时 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '无小时 值不能为空', trigger: 'blur' },
        ],
        formitem6: [
            { type: 'string', message: '无日期 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '无日期 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '无日期 值不能为空', trigger: 'blur' },
        ],
        formitem7: [
            { type: 'string', message: '小时 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '小时 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '小时 值不能为空', trigger: 'blur' },
        ],
        formitem8: [
            { type: 'string', message: '分钟 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '分钟 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '分钟 值不能为空', trigger: 'blur' },
        ],
        formitem9: [
            { type: 'string', message: '秒钟 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '秒钟 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '秒钟 值不能为空', trigger: 'blur' },
        ],
        formitem10: [
            { type: 'string', message: '无日期无秒钟 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '无日期无秒钟 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '无日期无秒钟 值不能为空', trigger: 'blur' },
        ],
        textrea: [
            { type: 'string', message: '多行输入框 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '多行输入框 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '多行输入框 值不能为空', trigger: 'blur' },
        ],
        formitem2: [
            { type: 'string', message: 'HTML编辑框 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: 'HTML编辑框 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: 'HTML编辑框 值不能为空', trigger: 'blur' },
        ],
        formitem4: [
            { type: 'string', message: '图片上传 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '图片上传 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '图片上传 值不能为空', trigger: 'blur' },
        ],
        formitem5: [
            { type: 'string', message: '文件上传 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '文件上传 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '文件上传 值不能为空', trigger: 'blur' },
        ],
        exampleid: [
            { type: 'string', message: '示例标识 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '示例标识 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '示例标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof AllEditorType
     */
    public detailsModel: any = {
        grouppanel1: new FormGroupPanelModel({ caption: '基础', detailType: 'GROUPPANEL', name: 'grouppanel1', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        grouppanel3: new FormGroupPanelModel({ caption: '选择类', detailType: 'GROUPPANEL', name: 'grouppanel3', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        grouppanel4: new FormGroupPanelModel({ caption: '时间类型', detailType: 'GROUPPANEL', name: 'grouppanel4', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        grouppanel2: new FormGroupPanelModel({ caption: '多行输入框', detailType: 'GROUPPANEL', name: 'grouppanel2', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        grouppanel5: new FormGroupPanelModel({ caption: '富文本文本编辑', detailType: 'GROUPPANEL', name: 'grouppanel5', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        grouppanel6: new FormGroupPanelModel({ caption: '图片上传', detailType: 'GROUPPANEL', name: 'grouppanel6', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        grouppanel7: new FormGroupPanelModel({ caption: '文件上传', detailType: 'GROUPPANEL', name: 'grouppanel7', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        formpage1: new FormPageModel({ caption: '表单分页', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this })
,
        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfkey: new FormItemModel({ caption: '示例标识', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfmajortext: new FormItemModel({ caption: '示例名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        span: new FormItemModel({ caption: '标签', detailType: 'FORMITEM', name: 'span', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        textbox: new FormItemModel({ caption: '文本框', detailType: 'FORMITEM', name: 'textbox', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        password: new FormItemModel({ caption: '密码输入框', detailType: 'FORMITEM', name: 'password', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        rawitem: new FormItemModel({ caption: '直接内容', detailType: 'FORMITEM', name: 'rawitem', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        checkbox: new FormItemModel({ caption: '选项框', detailType: 'FORMITEM', name: 'checkbox', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        checkboxlist: new FormItemModel({ caption: '选项框列表', detailType: 'FORMITEM', name: 'checkboxlist', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        dropdownlist: new FormItemModel({ caption: '下拉列表', detailType: 'FORMITEM', name: 'dropdownlist', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        listbox: new FormItemModel({ caption: '列表框', detailType: 'FORMITEM', name: 'listbox', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem1: new FormItemModel({ caption: '单选项列表', detailType: 'FORMITEM', name: 'formitem1', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        datepicker: new FormItemModel({ caption: '时间选择', detailType: 'FORMITEM', name: 'datepicker', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem: new FormItemModel({ caption: '无小时', detailType: 'FORMITEM', name: 'formitem', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem6: new FormItemModel({ caption: '无日期', detailType: 'FORMITEM', name: 'formitem6', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem7: new FormItemModel({ caption: '小时', detailType: 'FORMITEM', name: 'formitem7', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem8: new FormItemModel({ caption: '分钟', detailType: 'FORMITEM', name: 'formitem8', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem9: new FormItemModel({ caption: '秒钟', detailType: 'FORMITEM', name: 'formitem9', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem10: new FormItemModel({ caption: '无日期无秒钟', detailType: 'FORMITEM', name: 'formitem10', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        textrea: new FormItemModel({ caption: '多行输入框', detailType: 'FORMITEM', name: 'textrea', visible: true, isShowCaption: false, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem2: new FormItemModel({ caption: 'HTML编辑框', detailType: 'FORMITEM', name: 'formitem2', visible: true, isShowCaption: false, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem4: new FormItemModel({ caption: '图片上传', detailType: 'FORMITEM', name: 'formitem4', visible: true, isShowCaption: false, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem5: new FormItemModel({ caption: '文件上传', detailType: 'FORMITEM', name: 'formitem5', visible: true, isShowCaption: false, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        exampleid: new FormItemModel({ caption: '示例标识', detailType: 'FORMITEM', name: 'exampleid', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
    }

    /**
      * 代码表模型
      *
      * @type {*}
      * @memberof AllEditorType
      */      
    public codelistModel:any = {
        "formbase_ExampleText":[
        {"id":"A","text":"文本1","disabled":false},
        {"id":"B","text":"文本2","disabled":false},
        {"id":"C","text":"文本3","disabled":false},
        {"id":"D","text":"文本4","disabled":false},
        {"id":"E","text":"文本5","disabled":false}
        ]
      }

    /**
     * 表单逻辑
     *
     * @private
     * @param { name, newVal, oldVal }
     * @memberof AllEditorType
     */
    private formLogic(name: string, newVal: any, oldVal?: any): void {
                





































    }


    /**
     * 表单分页切换
     *
     * @param {string} key 分页标识
     * @memberof AllEditorType
     */
    public tabChange(key: string): void {
        if (this.props.tabChange) {
            this.props.tabChange(key);
        }
    }

    /**
     * 表单值变化事件
     *
     * @memberof AllEditorType
     */
    public formItemChange(item: string, value: any, isFirst?: boolean) {
        this.data[item] = value;
        this.formLogic(item, value);
        if (!isFirst) {
            this.validateItem(item, value);
            if (this.props.formItemChange) {
                this.props.formItemChange({name:item,value:value});
            }
        }
        this.tick();
    }

    /**
     * 按钮点击事件
     *
     * @memberof AllEditorType
     */
    public buttonClick($event:any,value:String){
        message.info('点击了'+value);
    }

    /**
     * 初始化表单
     * 
     * @memberof AllEditorType
     */
    public initForm() {
        if (Object.keys(this.data).length > 0) {
            Object.keys(this.data).forEach((item) => {
                this.formItemChange(item, this.data[item], true);
            })
        }
    }

    /**
     * 校验单个表单项
     * @param item 
     * @param value 
     */
    public validateItem(item: string, value: any) {
        // 做校验
        // 1.获取数值和规则
        const rule = this.rules[item];
        // 2.创建校验规则
        const schema = new Schema({ [item]: rule })
        // 校验返回Promise
        return schema.validate({ [item]: value },undefined,errors => {
            if (errors) {
                // 有错
                this.detailsModel[item].setError(errors[0].message);
            } else {
                this.detailsModel[item].setError('');
            }
        })
    }

    /**
     * 校验表单
     * 
     * @memberof AllEditorType
     */
    public validateForm(callback:Function) {
        let tasks: any;
        if (Object.keys(this.data).length > 0) {
            tasks = Object.keys(this.data).map((item) => {
                this.validateItem(item, this.data[item]);
            })
        }
        Promise.all(tasks)
            .then(() => callback(true))
            .catch(() => callback(false))
    }

    /**
     * 绘制内容
     *
     * @returns
     * @memberof AllEditorType
     */
    public render(): any {
        return <>
            <div className="ibiz-form alleditortype">
                <Form layout="inline">
                {this.detailsModel.grouppanel1.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
        <Collapse defaultActiveKey={['grouppanel1']} className=''>
    <Panel header="基础" key="grouppanel1">
        <Row>
                
        {this.detailsModel.span.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.span.isShowCaption && !this.detailsModel.span.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.span.required ? <span className="isrequired">*</span> : ""}标签
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'span'}  validateStatus={this.detailsModel.span.validateStatus} help={this.detailsModel.span.error}>
                <span>{this.data.span}</span>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.textbox.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.textbox.isShowCaption && !this.detailsModel.textbox.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.textbox.required ? <span className="isrequired">*</span> : ""}文本框
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'textbox'}  validateStatus={this.detailsModel.textbox.validateStatus} help={this.detailsModel.textbox.error}>
                <Input id={'textbox'} disabled={this.detailsModel.textbox.disabled} value={this.data.textbox}     onChange={($event) =>{this.formItemChange('textbox',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.password.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.password.isShowCaption && !this.detailsModel.password.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.password.required ? <span className="isrequired">*</span> : ""}密码输入框
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'password'}  validateStatus={this.detailsModel.password.validateStatus} help={this.detailsModel.password.error}>
                <Input id={'password'} type={'password'} disabled={this.detailsModel.password.disabled} value={this.data.password}     onChange={($event) =>{this.formItemChange('password',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.rawitem.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.rawitem.isShowCaption && !this.detailsModel.rawitem.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.rawitem.required ? <span className="isrequired">*</span> : ""}直接内容
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'rawitem'}  validateStatus={this.detailsModel.rawitem.validateStatus} help={this.detailsModel.rawitem.error}>
                <div>{this.data.rawitem}</div>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
        
            </Row>
    </Panel>
</Collapse>
    </Col>:""}
    {this.detailsModel.grouppanel3.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
        <Collapse defaultActiveKey={['grouppanel3']} className=''>
    <Panel header="选择类" key="grouppanel3">
        <Row>
                
        {this.detailsModel.checkbox.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.checkbox.isShowCaption && !this.detailsModel.checkbox.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.checkbox.required ? <span className="isrequired">*</span> : ""}选项框
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'checkbox'}  validateStatus={this.detailsModel.checkbox.validateStatus} help={this.detailsModel.checkbox.error}>
                <AppCheckBox value={this.data.checkbox} disabled={this.detailsModel.checkbox.disabled}  onChange={($event) =>{this.formItemChange('checkbox', $event)}}></AppCheckBox>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.checkboxlist.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.checkboxlist.isShowCaption && !this.detailsModel.checkboxlist.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.checkboxlist.required ? <span className="isrequired">*</span> : ""}选项框列表
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'checkboxlist'}  validateStatus={this.detailsModel.checkboxlist.validateStatus} help={this.detailsModel.checkboxlist.error}>
                <AppCheckBoxGroup value={this.data.checkboxlist}  disabled={this.detailsModel.checkboxlist.disabled}   tag={'formbase_ExampleText'}  mode={''} separator={''}  codelist={this.codelistModel} onChange={($event) =>{this.formItemChange('checkboxlist', $event)}}></AppCheckBoxGroup>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.dropdownlist.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.dropdownlist.isShowCaption && !this.detailsModel.dropdownlist.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.dropdownlist.required ? <span className="isrequired">*</span> : ""}下拉列表
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'dropdownlist'}  validateStatus={this.detailsModel.dropdownlist.validateStatus} help={this.detailsModel.dropdownlist.error}>
                <AppDropDownList value={this.data.dropdownlist} disabled={this.detailsModel.dropdownlist.disabled}  tag={'formbase_ExampleText'}  codelist={this.codelistModel}  placeholder={'请选择...'}  onChange={($event) =>{this.formItemChange('dropdownlist', $event)}}></AppDropDownList>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.listbox.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.listbox.isShowCaption && !this.detailsModel.listbox.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.listbox.required ? <span className="isrequired">*</span> : ""}列表框
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'listbox'}  validateStatus={this.detailsModel.listbox.validateStatus} help={this.detailsModel.listbox.error}>
                
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem1.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem1.isShowCaption && !this.detailsModel.formitem1.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.formitem1.required ? <span className="isrequired">*</span> : ""}单选项列表
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'formitem1'}  validateStatus={this.detailsModel.formitem1.validateStatus} help={this.detailsModel.formitem1.error}>
                
        <AppRadioGroup value={this.data.formitem1}  disabled={this.detailsModel.formitem1.disabled}  tag={'formbase_ExampleText'}  codelist={this.codelistModel} onChange={($event) =>{this.formItemChange('formitem1', $event)}}></AppRadioGroup>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
        
            </Row>
    </Panel>
</Collapse>
    </Col>:""}
    {this.detailsModel.grouppanel4.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
        <Collapse defaultActiveKey={['grouppanel4']} className=''>
    <Panel header="时间类型" key="grouppanel4">
        <Row>
                
        {this.detailsModel.datepicker.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.datepicker.isShowCaption && !this.detailsModel.datepicker.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.datepicker.required ? <span className="isrequired">*</span> : ""}时间选择
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'datepicker'}  validateStatus={this.detailsModel.datepicker.validateStatus} help={this.detailsModel.datepicker.error}>
                <AppDatePicker value={this.data.datepicker} disabled={this.detailsModel.datepicker.disabled}  showTime={true}  format={'YYYY-MM-DD HH:mm:ss'}  placeholder={"请选择时间..."}  onChange={($event) =>{this.formItemChange('datepicker',$event)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem.isShowCaption && !this.detailsModel.formitem.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.formitem.required ? <span className="isrequired">*</span> : ""}无小时
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'formitem'}  validateStatus={this.detailsModel.formitem.validateStatus} help={this.detailsModel.formitem.error}>
                <AppDatePicker value={this.data.formitem} disabled={this.detailsModel.formitem.disabled}  placeholder={"请选择时间..."}  onChange={($event) =>{this.formItemChange('formitem',$event)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem6.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem6.isShowCaption && !this.detailsModel.formitem6.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.formitem6.required ? <span className="isrequired">*</span> : ""}无日期
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'formitem6'}  validateStatus={this.detailsModel.formitem6.validateStatus} help={this.detailsModel.formitem6.error}>
                <AppTimePicker value={this.data.formitem6} disabled={this.detailsModel.formitem6.disabled}  format={'HH:mm:ss'}  placeholder={"请选择时间..."}  onChange={($event) =>{this.formItemChange('formitem6',$event)}} />
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem7.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem7.isShowCaption && !this.detailsModel.formitem7.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.formitem7.required ? <span className="isrequired">*</span> : ""}小时
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'formitem7'}  validateStatus={this.detailsModel.formitem7.validateStatus} help={this.detailsModel.formitem7.error}>
                <AppDatePicker value={this.data.formitem7} showTime={true} format={"YYYY-MM-DD HH"} disabled={this.detailsModel.formitem7.disabled}  placeholder={"请选择时间..."}  onChange={($event) =>{this.formItemChange('formitem7',$event)}} />
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem8.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem8.isShowCaption && !this.detailsModel.formitem8.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.formitem8.required ? <span className="isrequired">*</span> : ""}分钟
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'formitem8'}  validateStatus={this.detailsModel.formitem8.validateStatus} help={this.detailsModel.formitem8.error}>
                <AppDatePicker value={this.data.formitem8} showTime={true} format={"YYYY-MM-DD HH:mm"} disabled={this.detailsModel.formitem8.disabled} placeholder={"请选择时间..."}  onChange={($event) =>{this.formItemChange('formitem8',$event)}} />
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem9.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem9.isShowCaption && !this.detailsModel.formitem9.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.formitem9.required ? <span className="isrequired">*</span> : ""}秒钟
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'formitem9'}  validateStatus={this.detailsModel.formitem9.validateStatus} help={this.detailsModel.formitem9.error}>
                <AppDatePicker value={this.data.formitem9} showTime={true} format={"YYYY-MM-DD HH:mm:ss"} disabled={this.detailsModel.formitem9.disabled} placeholder={"请选择时间..."}  onChange={($event) =>{this.formItemChange('formitem9',$event)}} />
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem10.visible?<Col style={{}}  lg={{ span: 24, offset: 0}} xl={{ span: 12, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem10.isShowCaption && !this.detailsModel.formitem10.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.formitem10.required ? <span className="isrequired">*</span> : ""}无日期无秒钟
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'formitem10'}  validateStatus={this.detailsModel.formitem10.validateStatus} help={this.detailsModel.formitem10.error}>
                <AppTimePicker value={this.data.formitem10} disabled={this.detailsModel.formitem10.disabled}  format={'HH:mm'}  placeholder={"请选择时间..."}  onChange={($event) =>{this.formItemChange('formitem10',$event)}} />
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
        
            </Row>
    </Panel>
</Collapse>
    </Col>:""}
    {this.detailsModel.grouppanel2.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
        <Collapse defaultActiveKey={['grouppanel2']} className=''>
    <Panel header="多行输入框" key="grouppanel2">
        <Row>
                
        {this.detailsModel.textrea.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.textrea.isShowCaption && !this.detailsModel.textrea.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '0px' }}>
                    {this.detailsModel.textrea.required ? <span className="isrequired">*</span> : ""}多行输入框
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 0px)" }}>
                <Form.Item    key={'textrea'}  validateStatus={this.detailsModel.textrea.validateStatus} help={this.detailsModel.textrea.error}>
                <TextArea id={'textrea'} disabled={this.detailsModel.textrea.disabled} value={this.data.textrea}     onChange={($event) =>{this.formItemChange('textrea',$event.target.value)}} autosize={{minRows:3}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
        
            </Row>
    </Panel>
</Collapse>
    </Col>:""}
    {this.detailsModel.grouppanel5.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
        <Collapse defaultActiveKey={['grouppanel5']} className=''>
    <Panel header="富文本文本编辑" key="grouppanel5">
        <Row>
                
        {this.detailsModel.formitem2.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem2.isShowCaption && !this.detailsModel.formitem2.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '0px' }}>
                    {this.detailsModel.formitem2.required ? <span className="isrequired">*</span> : ""}HTML编辑框
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 0px)" }}>
                <Form.Item    key={'formitem2'}  validateStatus={this.detailsModel.formitem2.validateStatus} help={this.detailsModel.formitem2.error}>
                <AppRichTextEditor value={this.data.formitem2} disabled={this.detailsModel.formitem2.disabled}   onChange={($event) => { this.formItemChange('formitem2', $event) }}></AppRichTextEditor>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
        
            </Row>
    </Panel>
</Collapse>
    </Col>:""}
    {this.detailsModel.grouppanel6.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
        <Collapse defaultActiveKey={['grouppanel6']} className=''>
    <Panel header="图片上传" key="grouppanel6">
        <Row>
                
        {this.detailsModel.formitem4.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem4.isShowCaption && !this.detailsModel.formitem4.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '0px' }}>
                    {this.detailsModel.formitem4.required ? <span className="isrequired">*</span> : ""}图片上传
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 0px)" }}>
                <Form.Item    key={'formitem4'}  validateStatus={this.detailsModel.formitem4.validateStatus} help={this.detailsModel.formitem4.error}>
                <AppImageUpload value={this.data.formitem4} disabled={this.detailsModel.formitem4.disabled} multiple={true} onChange={($event) => { this.formItemChange('formitem4', $event) }}   uploadparams={''} exportparams={''} customparams={{}}></AppImageUpload>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
        
            </Row>
    </Panel>
</Collapse>
    </Col>:""}
    {this.detailsModel.grouppanel7.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
        <Collapse defaultActiveKey={['grouppanel7']} className=''>
    <Panel header="文件上传" key="grouppanel7">
        <Row>
                
        {this.detailsModel.formitem5.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem5.isShowCaption && !this.detailsModel.formitem5.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '0px' }}>
                    {this.detailsModel.formitem5.required ? <span className="isrequired">*</span> : ""}文件上传
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 0px)" }}>
                <Form.Item    key={'formitem5'}  validateStatus={this.detailsModel.formitem5.validateStatus} help={this.detailsModel.formitem5.error}>
                <AppFileUpload value={this.data.formitem5} disabled={this.detailsModel.formitem5.disabled}  uploadparams={''} exportparams={''} customparams={{}}  onChange={($event) => { this.formItemChange('formitem5', $event) }}></AppFileUpload>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
        
            </Row>
    </Panel>
</Collapse>
    </Col>:""}


                </Form>
            </div>
        </>;
    }

    /**
     * 变更监测
     *
     * @protected
     * @memberof Main
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }

}