import React, { PureComponent } from 'react';
import { DatePicker } from 'antd';
import './app-date-picker.less';

const { MonthPicker, RangePicker, WeekPicker } = DatePicker;
/**
 * 输入属性
 *
 * @export
 * @interface DateProps
 */
export interface DateProps {
    /**
     * 传入表单项值
     *
     * @type {any}
     * @memberof DateProps
     */
    value?: any;

    /**
     * 是否禁用
     * 
     *  @type {boolean}
     * @memberof DateProps
     */
    disabled: boolean;

    /**
     * 提示信息
     * 
     * @type {string}
     * @memberof DateProps
     */
    placeholder?: string;

    /**
     * 时间格式
     * 
     * @type {string}
     * @memberof DateProps
     */
    format?: string;

    /**
     * 是否展示时间
     */
    showTime?:boolean;

    /**
     * 值变化事件
     *
     * @memberof DateProps
     */
    onChange: (value: string) => void;
}


const moment = require("moment");

/**
 * BookTestEditView
 *
 * @export
 * @class BookTestEditView
 * @extends {PureComponent}
 */
export default class AppDatePicker extends PureComponent<DateProps> {

    /**
     * 绑定值
     */
    public currentValue: any = undefined;

    /**
     * 是否禁用
     */
    public curDisabled: boolean = false;

    /**
     * 当前日期格式
     */
    public curFormat: string = "YYYY-MM-DD";

    constructor(props) {
        super(props);
        if (props.value) {
            this.currentValue = props.value ? moment(props.value) : null;
        } else {
            this.currentValue = null;
        }
        if (props.disabled) {
            this.curDisabled = true;
        } else {
            this.curDisabled = false;
        }
        if (props.format) {
            this.curFormat = props.format;
        } else {
            this.curFormat = "YYYY-MM-DD";
        }
    }

    /**
     * 在组件接收到一个新的 prop (或更新后)时被调用
     *
     * @memberof AppDatePicker
     */
    public componentWillReceiveProps(nextProps: Readonly<DateProps>, nextContext: any) {
        if (nextProps.value) {
            this.currentValue = nextProps.value ? moment(nextProps.value) : null;
        } else {
            this.currentValue = null;
        }
        if (nextProps.disabled) {
            this.curDisabled = true;
        } else {
            this.curDisabled = false;
        }
    }


    /**
     * 绘制内容
     *
     * @returns
     * @memberof AppDatePicker
     */
    public render() {
        return (
            <DatePicker value={this.currentValue} showTime={this.props.showTime} format={this.curFormat} disabled={this.curDisabled} onChange={(date: any, dateString: string) => { this.handleChange(date, dateString) }} />
        );
    }

    /**
     * 值变化事件
     * 
     * @param $event
     * @memberof AppDatePicker 
     */
    public handleChange(date: any, dateString: string) {
        this.props.onChange(dateString);
    }

    /**
     * 变更监测
     *
     * @protected
     * @memberof AppDatePicker
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }

}