import React, { PureComponent } from 'react';
import { Select } from 'antd';

import './app-dropdown-list.less';
const { Option } = Select;

/**
 * 输入属性
 *
 * @export
 * @interface Props
 */
export interface Props {
    /**
     * 传入表单项值
     *
     * @type {any}
     * @memberof Props
     */
    value?: any;

    /**
     * 代码表标识
     * 
     * @type {string}
     * @memberof Props
     */
    tag?: string;

    /**
     * 是否禁用
     * 
     *  @type {boolean}
     * @memberof Props
     */
    disabled: boolean;

    /**
     * 代码表
     * 
     *  @type {Object}
     * @memberof Props
     */
    codelist?: Object;

    /**
     * 提示信息
     * 
     * @type {string}
     * @memberof Props
     */
    placeholder?: string;

    /**
     * 是否为宽度100
     * 
     * @type {boolean}
     * @memberof Props
     */
    isauto?:boolean;

    /**
     * 值变化事件
     *
     * @memberof Props
     */
    onChange: (value: string) => void;
}

/**
 * BookTestEditView
 *
 * @export
 * @class BookTestEditView
 * @extends {PureComponent}
 */
export default class AppDropDownList extends PureComponent<Props> {

    /**
     * 当前代码表
     * 
     * @memberof AppDropDownList
     */
    public curCodeList: Array<any> = [];

    /**
     * 绑定值
     */
    public currentValue: any = undefined;

    /**
     * 是否禁用
     */
    public curDisabled:boolean = false;

    constructor(props) {
        super(props);
        if (props.tag && props.codelist) {
            this.curCodeList = props.codelist[props.tag];
        }
        if (props.value) {
            this.currentValue = props.value;
        }else{
            this.currentValue = undefined;
        }
        if(props.disabled){
            this.curDisabled = true;
        }else{
            this.curDisabled = false;
        }
    }

    /**
     * 在组件接收到一个新的 prop (或更新后)时被调用
     *
     * @memberof AppDropDownList
     */
    public componentWillReceiveProps(nextProps: Readonly<Props>, nextContext: any) {
        if (nextProps.value) {
            this.currentValue = nextProps.value;
        }else{
            this.currentValue = undefined;
        }
        if(nextProps.disabled){
            this.curDisabled = true;
        }else{
            this.curDisabled = false;
        }
    }


    /**
     * 绘制内容
     *
     * @returns
     * @memberof AppDropDownList
     */
    public render() {
        return (<Select value={this.currentValue}  disabled={this.curDisabled} placeholder={this.props.placeholder} style={{ width:  this.props.isauto?100:'100%'}} onChange={($event) => {this.handleChange($event)}}>
            {
                this.curCodeList.map((item: any) => {
                    return <Option key={item.id}  value={item.id} disabled={item.disabled}>{item.text}</Option>
                })
            }
        </Select>);
    }

    /**
     * 值变化事件
     * 
     * @param $event
     * @memberof AppDropDownList 
     */
    public handleChange($event){
        this.props.onChange($event);
    }

    /**
     * 变更监测
     *
     * @protected
     * @memberof AppDropDownList
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }

}