import React, { PureComponent } from 'react';
import ExampleEditorType from './pages/exapmple/example-editor-type/example-editor-type';
import ExampleEditView from './pages/exapmple/example-edit-view/example-edit-view';
import ExampleDLFEditView from './pages/exapmple/example-dlfedit-view/example-dlfedit-view';
import './App.less';
import { Layout, Menu, Breadcrumb, Icon } from 'antd';
const { Header, Content, Footer, Sider } = Layout;
const { SubMenu } = Menu;


/**
 * App
 *
 * @export
 * @class App
 * @extends {PureComponent}
 */
export default class App extends PureComponent {

     /**
     * 当前页面
     */
    public currentPage: string = "ExampleEditorType";

    /**
     * 处理菜单点击
     * @param item 
     * @param key 
     * @param keyPath 
     * @param domEvent 
     */
    public handleMenuClick(item, key, keyPath, domEvent) {
        this.currentPage = key;
        this.tick();
    }

    /**
     * 获取当前视图
     */
    public getCurPage(): any {
        if (Object.is(this.currentPage, "ExampleEditorType")) {
            return <ExampleEditorType/>;
        }
        if (Object.is(this.currentPage, "ExampleEditView")) {
            return <ExampleEditView/>;
        }
        if (Object.is(this.currentPage, "ExampleDLFEditView")) {
            return <ExampleDLFEditView/>;
        }
    }

    /**
     * 变更监测
     *
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }


    /**
     * 渲染视图
     *
     * @returns
     * @memberof App
     */
    public render() {
        return <div className="App">
            <Layout id="components-layout-demo-custom-trigger">
                <Sider trigger={null} collapsible style={{ minHeight: '100vh' }}>
                    <div className="logo"><img src="https://cdn.ibizlab.cn/super-form/logo.png" /></div>
                    <Menu theme="dark" mode="inline" defaultSelectedKeys={['"ExampleEditorType""ExampleEditView""ExampleDLFEditView"']} onClick={({ item, key, keyPath, domEvent }) => { this.handleMenuClick(item, key, keyPath, domEvent) }}>
                        <Menu.Item key="ExampleEditorType">
                            <Icon type="user" />
                            <span>基础编辑器</span>
                        </Menu.Item>
                        <Menu.Item key="ExampleEditView">
                            <Icon type="video-camera" />
                            <span>基础表单项</span>
                        </Menu.Item>
                        <Menu.Item key="ExampleDLFEditView">
                            <Icon type="upload" />
                            <span>表单项动态逻辑示例</span>
                        </Menu.Item>
                    </Menu>
                </Sider>
                <Layout>
                    <Content
                        style={{
                            margin: '24px 16px',
                            padding: 24,
                            background: '#fff',
                            minHeight: 280,
                        }}>
                        {this.getCurPage()}
                    </Content>
                </Layout>
            </Layout>
        </div>;
    }

}