import React, { PureComponent } from 'react';
import { Form, Input, Row, Col, Tabs, Icon, Collapse, Button, Select, message } from 'antd';
import Schema from "async-validator";
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '../../../ibizsys/form-detail';
import { Util } from '../../../ibizsys/utils/util';

import AppDropDownList  from '../../../ibizsys/components/app-dropdown-list/app-dropdown-list';
import AppRadioGroup from '../../../ibizsys/components/app-radio-group/app-radio-group';
import AppCheckBox from '../../../ibizsys/components/app-checkbox/app-checkbox';
import AppCheckBoxGroup from '../../../ibizsys/components/app-checkbox-group/app-checkbox-group';
import AppDatePicker from '../../../ibizsys/components/app-date-picker/app-date-picker';
import AppTimePicker from '../../../ibizsys/components/app-time-picker/app-time-picker';
import AppImageUpload from '../../../ibizsys/components/app-image-upload/app-image-upload';
import AppFileUpload from '../../../ibizsys/components/app-file-upload/app-file-upload';
import AppRichTextEditor from '../../../ibizsys/components/app-rich-text-editor/app-rich-text-editor';

import './main.less';
const { TabPane } = Tabs;
const { Panel } = Collapse;
const { Option } = Select;
const { TextArea  } = Input;

/**
 * 表单属性
 *
 * @export
 * @interface MainFormData
 */
export class MainFormData {
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem?: any;
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem1?: any;
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem2?: any;
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem3?: any;
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem4?: any;
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem5?: any;
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem6?: any;
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem7?: any;
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem8?: any;
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem9?: any;
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem10?: any;
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem11?: any;
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem12?: any;
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem13?: any;
    /**
     * 表单项
     *
     * @type {*}
     * @memberof MainFormData
     */
    formitem14?: any;
    /**
     * 示例标识
     *
     * @type {*}
     * @memberof MainFormData
     */
    exampleid?: any;
}

/**
 * 输入属性
 *
 * @export
 * @interface MainProps
 */
export interface MainProps {
    /**
     * 表单数据对象
     *
     * @type {MainFormData}
     * @memberof MainProps
     */
    data?: MainFormData;
    /**
     * 表单分页切换
     *
     * @memberof MainProps
     */
    tabChange?: (key: string) => void;
    /**
     * 表单项之变化
     *
     * @memberof MainProps
     */
    formItemChange?:(key:any) => void;
}

/**
 * Main
 *
 * @export
 * @class Main
 * @extends {PureComponent}
 */
export default class Main extends PureComponent<MainProps> {
    /**
     * 表单数据
     *
     * @type {*}
     * @memberof Main
     */
    public data: MainFormData = new MainFormData();

    /**
     * 初始化实例
     *
     * @type {*}
     * @memberof Main
     */
    constructor(props) {
        super(props);
        if (this.data && this.props.data && !Object.is(JSON.stringify(this.data), JSON.stringify(this.props.data))) {
            Object.assign(this.data, this.props.data);
        }
        this.initForm();
    }
    
    /**
     * 在组件接收到一个新的 prop (或更新后)时被调用
     *
     * @memberof IBizViewController
     */
    public componentWillReceiveProps(nextProps: Readonly<MainProps>, nextContext: any) {
        if (this.data && nextProps.data && !Object.is(JSON.stringify(this.data), JSON.stringify(nextProps.data))) {
            Object.assign(this.data, nextProps.data);
        }
    }

    /**
     * 在组件从 DOM 中移除的时候立刻被调用
     *
     * @memberof IBizViewController
     */
    public componentWillUnmount() {

    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof Main
     */
    public rules: any = {
        formitem: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
        formitem1: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
        formitem2: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
        formitem3: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
        formitem4: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
        formitem5: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
        formitem6: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
        formitem7: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
        formitem8: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
        formitem9: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
        formitem10: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
        formitem11: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
        formitem12: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
        formitem13: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
        formitem14: [
            { type: 'string', message: '表单项 值必须为字符串类型', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '表单项 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof Main
     */
    public detailsModel: any = {
        formitem: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem1: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem1', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        tabpage1: new FormTabPageModel({ caption: '分页面板', detailType: 'TABPAGE', name: 'tabpage1', visible: true, isShowCaption: true, form: this })
,
        formitem2: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem2', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem3: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem3', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        tabpage2: new FormTabPageModel({ caption: '分页面板2', detailType: 'TABPAGE', name: 'tabpage2', visible: true, isShowCaption: true, form: this })
,
        tabpanel1: new FormTabPanelModel({ caption: '', detailType: 'TABPANEL', name: 'tabpanel1', visible: true, isShowCaption: false, form: this, tabPages: [{ name: 'tabpage1', index: 0, visible: true }, { name: 'tabpage2', index: 1, visible: true }] })
,
        grouppanel1: new FormGroupPanelModel({ caption: '分组面板', detailType: 'GROUPPANEL', name: 'grouppanel1', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        button1: new FormButtonModel({ caption: '表单按钮', detailType: 'BUTTON', name: 'button1', visible: true, isShowCaption: true, form: this })
,
        rawitem1: new FormRowItemModel({ caption: '', detailType: 'RAWITEM', name: 'rawitem1', visible: true, isShowCaption: true, form: this })
,
        iframe1: new FormIFrameModel({ caption: '', detailType: 'IFRAME', name: 'iframe1', visible: true, isShowCaption: true, form: this })
,
        grouppanel2: new FormGroupPanelModel({ caption: '分组面板2', detailType: 'GROUPPANEL', name: 'grouppanel2', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        formitem4: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem4', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem5: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem5', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem6: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem6', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem7: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem7', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem8: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem8', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem9: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem9', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem10: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem10', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem11: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem11', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        grouppanel3: new FormGroupPanelModel({ caption: '栅格布局', detailType: 'GROUPPANEL', name: 'grouppanel3', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        formitem12: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem12', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem13: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem13', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        formitem14: new FormItemModel({ caption: '表单项', detailType: 'FORMITEM', name: 'formitem14', visible: true, isShowCaption: true, form: this, disabled: false,error:"",isEmptyCaption:"false",validateStatus:"",required:false,enableCond: 3 })
,
        grouppanel4: new FormGroupPanelModel({ caption: 'Flex布局', detailType: 'GROUPPANEL', name: 'grouppanel4', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: '', extractMode: 'ITEM', details: [] } })
,
        formpage1: new FormPageModel({ caption: '表单分页', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this })
,
    }

    /**
      * 代码表模型
      *
      * @type {*}
      * @memberof Main
      */      
    public codelistModel:any = {
      }

    /**
     * 表单逻辑
     *
     * @private
     * @param { name, newVal, oldVal }
     * @memberof Main
     */
    private formLogic(name: string, newVal: any, oldVal?: any): void {
                


























    }


    /**
     * 表单分页切换
     *
     * @param {string} key 分页标识
     * @memberof Main
     */
    public tabChange(key: string): void {
        if (this.props.tabChange) {
            this.props.tabChange(key);
        }
    }

    /**
     * 表单值变化事件
     *
     * @memberof Main
     */
    public formItemChange(item: string, value: any, isFirst?: boolean) {
        this.data[item] = value;
        this.formLogic(item, value);
        if (!isFirst) {
            this.validateItem(item, value);
            if (this.props.formItemChange) {
                this.props.formItemChange({name:item,value:value});
            }
        }
        this.tick();
    }

    /**
     * 按钮点击事件
     *
     * @memberof Main
     */
    public buttonClick($event:any,value:String){
        message.info('点击了'+value);
    }

    /**
     * 初始化表单
     * 
     * @memberof Main
     */
    public initForm() {
        if (Object.keys(this.data).length > 0) {
            Object.keys(this.data).forEach((item) => {
                this.formItemChange(item, this.data[item], true);
            })
        }
    }

    /**
     * 校验单个表单项
     * @param item 
     * @param value 
     */
    public validateItem(item: string, value: any) {
        // 做校验
        // 1.获取数值和规则
        const rule = this.rules[item];
        // 2.创建校验规则
        const schema = new Schema({ [item]: rule })
        // 校验返回Promise
        return schema.validate({ [item]: value },undefined,errors => {
            if (errors) {
                // 有错
                this.detailsModel[item].setError(errors[0].message);
            } else {
                this.detailsModel[item].setError('');
            }
        })
    }

    /**
     * 校验表单
     * 
     * @memberof Main
     */
    public validateForm(callback:Function) {
        let tasks: any;
        if (Object.keys(this.data).length > 0) {
            tasks = Object.keys(this.data).map((item) => {
                this.validateItem(item, this.data[item]);
            })
        }
        Promise.all(tasks)
            .then(() => callback(true))
            .catch(() => callback(false))
    }

    /**
     * 绘制内容
     *
     * @returns
     * @memberof Main
     */
    public render(): any {
        return <>
            <div className="ibiz-form main">
                <Form layout="inline">
                {this.detailsModel.grouppanel1.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
        <Collapse defaultActiveKey={['grouppanel1']} className=''>
    <Panel header="分组面板" key="grouppanel1">
        <Row>
                
        {this.detailsModel.tabpanel1.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                <Tabs defaultActiveKey="tabpage1"   className="">
        				<TabPane key={'tabpage1'}  tab={'分页面板'}  className="app-form-page-panel "  style={{}}>
        					
                {this.detailsModel.formitem.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem.isShowCaption && !this.detailsModel.formitem.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.formitem.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'formitem'}  validateStatus={this.detailsModel.formitem.validateStatus} help={this.detailsModel.formitem.error}>
                <Input id={'formitem'} disabled={this.detailsModel.formitem.disabled} value={this.data.formitem}     onChange={($event) =>{this.formItemChange('formitem',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem1.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem1.isShowCaption && !this.detailsModel.formitem1.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.formitem1.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'formitem1'}  validateStatus={this.detailsModel.formitem1.validateStatus} help={this.detailsModel.formitem1.error}>
                <Input id={'formitem1'} disabled={this.detailsModel.formitem1.disabled} value={this.data.formitem1}     onChange={($event) =>{this.formItemChange('formitem1',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
        
        
        				</TabPane>
        				<TabPane key={'tabpage2'}  tab={'分页面板2'}  className="app-form-page-panel "  style={{}}>
        					
                {this.detailsModel.formitem2.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem2.isShowCaption && !this.detailsModel.formitem2.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.formitem2.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'formitem2'}  validateStatus={this.detailsModel.formitem2.validateStatus} help={this.detailsModel.formitem2.error}>
                <Input id={'formitem2'} disabled={this.detailsModel.formitem2.disabled} value={this.data.formitem2}     onChange={($event) =>{this.formItemChange('formitem2',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem3.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem3.isShowCaption && !this.detailsModel.formitem3.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.formitem3.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'formitem3'}  validateStatus={this.detailsModel.formitem3.validateStatus} help={this.detailsModel.formitem3.error}>
                <Input id={'formitem3'} disabled={this.detailsModel.formitem3.disabled} value={this.data.formitem3}     onChange={($event) =>{this.formItemChange('formitem3',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
        
        
        				</TabPane>
        </Tabs>
        
            </Col>:""}
        
            </Row>
    </Panel>
</Collapse>
    </Col>:""}
    {this.detailsModel.grouppanel2.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
        <Collapse defaultActiveKey={['grouppanel2']} className=''>
    <Panel header="分组面板2" key="grouppanel2">
        <Row>
                
        {this.detailsModel.button1.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                    <Button type="primary" onClick={($event: any) => this.buttonClick($event,"表单按钮")}
                 style={{}}>
                   
                <span >表单按钮</span>
            </Button>
            </Col>:""}
            {this.detailsModel.rawitem1.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                <div className="" style="">
            表单内容
        </div>
        
            </Col>:""}
            {this.detailsModel.iframe1.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
                <div style="height:0px;">https://www.baidu.com</div>
            </Col>:""}
        
            </Row>
    </Panel>
</Collapse>
    </Col>:""}
    {this.detailsModel.grouppanel3.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
        <Collapse defaultActiveKey={['grouppanel3']} className=''>
    <Panel header="栅格布局" key="grouppanel3">
        <Row>
                
        {this.detailsModel.formitem4.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 12, offset: 0}} lg={{ span: 8, offset: 0}} xl={{ span: 6, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem4.isShowCaption && !this.detailsModel.formitem4.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '70px' }}>
                    {this.detailsModel.formitem4.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 70px)" }}>
                <Form.Item    key={'formitem4'}  validateStatus={this.detailsModel.formitem4.validateStatus} help={this.detailsModel.formitem4.error}>
                <Input id={'formitem4'} disabled={this.detailsModel.formitem4.disabled} value={this.data.formitem4}     onChange={($event) =>{this.formItemChange('formitem4',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem5.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 12, offset: 0}} lg={{ span: 8, offset: 0}} xl={{ span: 6, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem5.isShowCaption && !this.detailsModel.formitem5.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '70px' }}>
                    {this.detailsModel.formitem5.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 70px)" }}>
                <Form.Item    key={'formitem5'}  validateStatus={this.detailsModel.formitem5.validateStatus} help={this.detailsModel.formitem5.error}>
                <Input id={'formitem5'} disabled={this.detailsModel.formitem5.disabled} value={this.data.formitem5}     onChange={($event) =>{this.formItemChange('formitem5',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem6.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 12, offset: 0}} lg={{ span: 8, offset: 0}} xl={{ span: 6, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem6.isShowCaption && !this.detailsModel.formitem6.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '70px' }}>
                    {this.detailsModel.formitem6.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 70px)" }}>
                <Form.Item    key={'formitem6'}  validateStatus={this.detailsModel.formitem6.validateStatus} help={this.detailsModel.formitem6.error}>
                <Input id={'formitem6'} disabled={this.detailsModel.formitem6.disabled} value={this.data.formitem6}     onChange={($event) =>{this.formItemChange('formitem6',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem7.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 12, offset: 0}} lg={{ span: 8, offset: 0}} xl={{ span: 6, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem7.isShowCaption && !this.detailsModel.formitem7.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '70px' }}>
                    {this.detailsModel.formitem7.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 70px)" }}>
                <Form.Item    key={'formitem7'}  validateStatus={this.detailsModel.formitem7.validateStatus} help={this.detailsModel.formitem7.error}>
                <Input id={'formitem7'} disabled={this.detailsModel.formitem7.disabled} value={this.data.formitem7}     onChange={($event) =>{this.formItemChange('formitem7',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem8.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 12, offset: 0}} lg={{ span: 8, offset: 0}} xl={{ span: 6, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem8.isShowCaption && !this.detailsModel.formitem8.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '70px' }}>
                    {this.detailsModel.formitem8.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 70px)" }}>
                <Form.Item    key={'formitem8'}  validateStatus={this.detailsModel.formitem8.validateStatus} help={this.detailsModel.formitem8.error}>
                <Input id={'formitem8'} disabled={this.detailsModel.formitem8.disabled} value={this.data.formitem8}     onChange={($event) =>{this.formItemChange('formitem8',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem9.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 12, offset: 0}} lg={{ span: 8, offset: 0}} xl={{ span: 6, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem9.isShowCaption && !this.detailsModel.formitem9.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '70px' }}>
                    {this.detailsModel.formitem9.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 70px)" }}>
                <Form.Item    key={'formitem9'}  validateStatus={this.detailsModel.formitem9.validateStatus} help={this.detailsModel.formitem9.error}>
                <Input id={'formitem9'} disabled={this.detailsModel.formitem9.disabled} value={this.data.formitem9}     onChange={($event) =>{this.formItemChange('formitem9',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem10.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 12, offset: 0}} lg={{ span: 8, offset: 0}} xl={{ span: 6, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem10.isShowCaption && !this.detailsModel.formitem10.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '70px' }}>
                    {this.detailsModel.formitem10.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 70px)" }}>
                <Form.Item    key={'formitem10'}  validateStatus={this.detailsModel.formitem10.validateStatus} help={this.detailsModel.formitem10.error}>
                <Input id={'formitem10'} disabled={this.detailsModel.formitem10.disabled} value={this.data.formitem10}     onChange={($event) =>{this.formItemChange('formitem10',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
            {this.detailsModel.formitem11.visible?<Col style={{}}  sm={{ span: 24, offset: 0 }} md={{span: 12, offset: 0}} lg={{ span: 8, offset: 0}} xl={{ span: 6, offset: 0}}>
                <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem11.isShowCaption && !this.detailsModel.formitem11.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '70px' }}>
                    {this.detailsModel.formitem11.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 70px)" }}>
                <Form.Item    key={'formitem11'}  validateStatus={this.detailsModel.formitem11.validateStatus} help={this.detailsModel.formitem11.error}>
                <Input id={'formitem11'} disabled={this.detailsModel.formitem11.disabled} value={this.data.formitem11}     onChange={($event) =>{this.formItemChange('formitem11',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
            </Col>:""}
        
            </Row>
    </Panel>
</Collapse>
    </Col>:""}
    {this.detailsModel.grouppanel4.visible?<Col style={{}}  lg={{ span: 24, offset: 0}}>
        <Collapse defaultActiveKey={['grouppanel4']} className=''>
    <Panel header="Flex布局" key="grouppanel4">
        <div style={{height: '100%',display: 'flex',        flexDirection:'column',alignItems:'center'}}>        
                
        {this.detailsModel.formitem12.visible?<div   style={{flexGrow:1,}}>
               <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem12.isShowCaption && !this.detailsModel.formitem12.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.formitem12.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'formitem12'}  validateStatus={this.detailsModel.formitem12.validateStatus} help={this.detailsModel.formitem12.error}>
                <Input id={'formitem12'} disabled={this.detailsModel.formitem12.disabled} value={this.data.formitem12}     onChange={($event) =>{this.formItemChange('formitem12',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
           </div>:""}
          {this.detailsModel.formitem13.visible?<div   style={{flexGrow:1,}}>
               <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem13.isShowCaption && !this.detailsModel.formitem13.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.formitem13.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'formitem13'}  validateStatus={this.detailsModel.formitem13.validateStatus} help={this.detailsModel.formitem13.error}>
                <Input id={'formitem13'} disabled={this.detailsModel.formitem13.disabled} value={this.data.formitem13}     onChange={($event) =>{this.formItemChange('formitem13',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
           </div>:""}
          {this.detailsModel.formitem14.visible?<div   style={{flexGrow:1,}}>
               <div className={`app-form-item app-form-item-left`}>
            {this.detailsModel.formitem14.isShowCaption && !this.detailsModel.formitem14.isEmptyCaption ?
                <div className="app-form-item-label" style={{ width: '130px' }}>
                    {this.detailsModel.formitem14.required ? <span className="isrequired">*</span> : ""}表单项
                </div> : ""}
            <div className="app-form-item-container" style={{ width: "calc(100% - 130px)" }}>
                <Form.Item    key={'formitem14'}  validateStatus={this.detailsModel.formitem14.validateStatus} help={this.detailsModel.formitem14.error}>
                <Input id={'formitem14'} disabled={this.detailsModel.formitem14.disabled} value={this.data.formitem14}     onChange={($event) =>{this.formItemChange('formitem14',$event.target.value)}}/>
                </Form.Item>
            </div>
        </div> 
        
           </div>:""}
        
            </div>
    </Panel>
</Collapse>
    </Col>:""}


                </Form>
            </div>
        </>;
    }

    /**
     * 变更监测
     *
     * @protected
     * @memberof Main
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }

}