import React, { PureComponent } from 'react';
import { Form, Input, Row, Col, Tabs, Icon, Collapse, Button, Select, message } from 'antd';
import Schema from "async-validator";
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '../../../ibizsys/form-detail';
import { Util } from '../../../ibizsys/utils/util';

import AppDropDownList  from '../../../ibizsys/components/app-dropdown-list/app-dropdown-list';
import AppRadioGroup from '../../../ibizsys/components/app-radio-group/app-radio-group';
import AppCheckBox from '../../../ibizsys/components/app-checkbox/app-checkbox';
import AppCheckBoxGroup from '../../../ibizsys/components/app-checkbox-group/app-checkbox-group';
import AppDatePicker from '../../../ibizsys/components/app-date-picker/app-date-picker';
import AppTimePicker from '../../../ibizsys/components/app-time-picker/app-time-picker';
import AppImageUpload from '../../../ibizsys/components/app-image-upload/app-image-upload';
import AppFileUpload from '../../../ibizsys/components/app-file-upload/app-file-upload';
import AppRichTextEditor from '../../../ibizsys/components/app-rich-text-editor/app-rich-text-editor';

import './${srffilepath2(ctrl.codeName)}.less';
const { TabPane } = Tabs;
const { Panel } = Collapse;
const { Option } = Select;
const { TextArea  } = Input;

/**
 * 表单属性
 *
 * @export
 * @interface ${srfclassname(ctrl.codeName)}FormData
 */
export class ${srfclassname(ctrl.codeName)}FormData {
<#list ctrl.getPSDEFormItems() as item>
<#if item.getName()?index_of('srf') != 0>
    /**
     * <#if item.getCaption()??>${item.getCaption()}<#else>${item.getName()}</#if>
     *
     * @type {*}
     * @memberof ${srfclassname(ctrl.codeName)}FormData
     */
    ${item.getName()}?: any;
</#if>
</#list>
}

/**
 * 输入属性
 *
 * @export
 * @interface ${srfclassname(ctrl.codeName)}Props
 */
export interface ${srfclassname(ctrl.codeName)}Props {
    /**
     * 表单数据对象
     *
     * @type {${srfclassname(ctrl.codeName)}FormData}
     * @memberof ${srfclassname(ctrl.codeName)}Props
     */
    data?: ${srfclassname(ctrl.codeName)}FormData;
    /**
     * 表单分页切换
     *
     * @memberof ${srfclassname(ctrl.codeName)}Props
     */
    tabChange?: (key: string) => void;
    /**
     * 表单项之变化
     *
     * @memberof MainProps
     */
    formItemChange?:(key:any) => void;
}

/**
 * ${srfclassname(ctrl.codeName)}
 *
 * @export
 * @class ${srfclassname(ctrl.codeName)}
 * @extends {PureComponent}
 */
export default class ${srfclassname(ctrl.codeName)} extends PureComponent<${srfclassname(ctrl.codeName)}Props> {
    /**
     * 表单数据
     *
     * @type {*}
     * @memberof ${srfclassname(ctrl.codeName)}
     */
    public data: ${srfclassname(ctrl.codeName)}FormData = new ${srfclassname(ctrl.codeName)}FormData();

    /**
     * 初始化实例
     *
     * @type {*}
     * @memberof ${srfclassname(ctrl.codeName)}
     */
    constructor(props) {
        super(props);
        if (this.data && this.props.data && !Object.is(JSON.stringify(this.data), JSON.stringify(this.props.data))) {
            Object.assign(this.data, this.props.data);
        }
        this.initForm();
    }
    
    /**
     * 在组件接收到一个新的 prop (或更新后)时被调用
     *
     * @memberof IBizViewController
     */
    public componentWillReceiveProps(nextProps: Readonly<${srfclassname(ctrl.codeName)}Props>, nextContext: any) {
        if (this.data && nextProps.data && !Object.is(JSON.stringify(this.data), JSON.stringify(nextProps.data))) {
            Object.assign(this.data, nextProps.data);
        }
    }

    /**
     * 在组件从 DOM 中移除的时候立刻被调用
     *
     * @memberof IBizViewController
     */
    public componentWillUnmount() {

    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof ${srfclassname(ctrl.codeName)}
     */
    public rules: any = {
        <#list ctrl.getAllPSDEFormDetails() as formdetail>
        <#if formdetail.getDetailType?? && formdetail.getDetailType() == 'FORMITEM'>
        ${formdetail.getName()}: [
            { type: '<#assign datatype=srfjavatype(formdetail.getStdDataType())><#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>number<#else>string</#if>', message: '${formdetail.getCaption()} 值必须为<#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>数值<#else>字符串</#if>类型', trigger: 'change' },
            { required: <#if formdetail.isAllowEmpty()>false<#else>true</#if>, type: '<#assign datatype=srfjavatype(formdetail.getStdDataType())><#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>number<#else>string</#if>', message: '${formdetail.getCaption()} 值不能为空', trigger: 'change' },
            { required: <#if formdetail.isAllowEmpty()>false<#else>true</#if>, type: '<#assign datatype=srfjavatype(formdetail.getStdDataType())><#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>number<#else>string</#if>', message: '${formdetail.getCaption()} 值不能为空', trigger: 'blur' },
            <#if ctrl.getPSDEFormItemVRs()??>
            <#list ctrl.getPSDEFormItemVRs() as fideValueRule>
            <#if fideValueRule.getPSDEFormItemName() == formdetail.getName()>
              <#if fideValueRule.getPSSysValueRule()??>
                <#assign  valueRule = fideValueRule.getPSSysValueRule()/>
                <#if valueRule.getRuleType?? && valueRule.getRuleType()?? && valueRule.getRuleType() == "REG">
            { <#if valueRule.getRegExCode?? && valueRule.getRegExCode()??>pattern: /^${valueRule.getRegExCode()}$/</#if><#if valueRule.getRuleInfo?? &&  valueRule.getRuleInfo()??>, message: '${valueRule.getRuleInfo()}'</#if>, trigger: 'change' },
                </#if>
              </#if>
            </#if>            
            </#list>
            </#if>
        ],
        </#if>
        </#list>
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof ${srfclassname(ctrl.codeName)}
     */
    public detailsModel: any = {
        <#list ctrl.getAllPSDEFormDetails() as formdetail>
        ${formdetail.name}: ${P.getPartCode(formdetail, 'DETAIL_MODEL').code},
        </#list>
        <#if !ctrl.isNoTabHeader()>
        ${ctrl.name}: new FormTabPanelModel({ caption: '${ctrl.name}', detailType: 'TABPANEL', name: '${ctrl.name}', visible: true, isShowCaption: true, form: this, tabPages: [<#list ctrl.getPSDEFormPages() as formmenber><#if formmenber_index gt 0>, </#if>{ name: '${formmenber.name}', index: ${formmenber_index}, visible: <#if formmenber.getPSDEFDGroupLogic('PANELVISIBLE')??>false<#else>true</#if> }</#list>] }),
        </#if>
    }

    /**
      * 代码表模型
      *
      * @type {*}
      * @memberof ${srfclassname(ctrl.codeName)}
      */      
    public codelistModel:any = {
        <#if view.getAllRelatedPSCodeLists()??>
        <#list view.getAllRelatedPSCodeLists() as codelist>
        <#if codelist.getAllPSCodeItems()??>
        "${codelist.getSystemTag()}_${codelist.codeName}":[
        <#list codelist.getAllPSCodeItems() as codeItem>
        {"id":"${codeItem.getValue()}","text":"${codeItem.getText()}","disabled":${codeItem.isDisableSelect()?c}}<#if codeItem_has_next>,</#if>
        </#list>
        ]<#if codelist_has_next>,</#if>
        </#if>
        </#list>
        </#if>
      }

    /**
     * 表单逻辑
     *
     * @private
     * @param { name, newVal, oldVal }
     * @memberof ${srfclassname(ctrl.codeName)}
     */
    private formLogic(name: string, newVal: any, oldVal?: any): void {
        <#if P.getPartCode(item,'FORM_LOGIC').code?length gt 0>
        ${P.getPartCode(item,'FORM_LOGIC').code}
        </#if>
        <#if ctrl.getPSDEFormItems()??>
        <#list ctrl.getPSDEFormItems() as formitem>
        <#if formitem.getPSDEFormItemUpdate()??>
        <#assign itemUpdate=formitem.getPSDEFormItemUpdate()/>

        if(Object.is(name, '${formitem.name}')){
            const details: string[] = [<#list itemUpdate.getPSDEFIUpdateDetails() as detail><#if detail_index gt 0>, </#if>'${detail.getPSDEFormDetailName()?lower_case}'</#list>];
            this.updateFormItems('${itemUpdate.codeName}', this.data, details, ${itemUpdate.isShowBusyIndicator()?c});
        }
        </#if>
        </#list>
        </#if>
    }

    <#list ctrl.getAllPSDEFormDetails() as formdetail>
    <#if formdetail.getDetailType?? && formdetail.getDetailType() == 'BUTTON'>
    <#if formdetail.getActionType?? && formdetail.getActionType()??>
    <#if formdetail.getActionType() == 'UIACTION'>

	/**
	 * 表单 ${formdetail.getCaption()} 事件
	 *
	 * @memberof @memberof ${srfclassname('${ctrl.codeName}')}
	 */
    public ${formdetail.getName()}_click($event: any): void {
        alert('需自定义实现');
    }
    </#if>
    <#if formdetail.getActionType() == 'FIUPDATE'>

	/**
	 * 表单 ${formdetail.getCaption()} 事件
	 *
	 * @memberof @memberof ${srfclassname('${ctrl.codeName}')}
	 */
    public ${formdetail.getName()}_click($event: any): void {
        alert('需自定义实现');
    }
    </#if>
    </#if>
    </#if>
    </#list>

    /**
     * 表单分页切换
     *
     * @param {string} key 分页标识
     * @memberof ${srfclassname(ctrl.codeName)}
     */
    public tabChange(key: string): void {
        if (this.props.tabChange) {
            this.props.tabChange(key);
        }
    }

    /**
     * 表单值变化事件
     *
     * @memberof ${srfclassname(ctrl.codeName)}
     */
    public formItemChange(item: string, value: any, isFirst?: boolean) {
        this.data[item] = value;
        this.formLogic(item, value);
        if (!isFirst) {
            this.validateItem(item, value);
            if (this.props.formItemChange) {
                this.props.formItemChange({name:item,value:value});
            }
        }
        this.tick();
    }

    /**
     * 按钮点击事件
     *
     * @memberof ${srfclassname(ctrl.codeName)}
     */
    public buttonClick($event:any,value:String){
        message.info('点击了'+value);
    }

    /**
     * 初始化表单
     * 
     * @memberof ${srfclassname(ctrl.codeName)}
     */
    public initForm() {
        if (Object.keys(this.data).length > 0) {
            Object.keys(this.data).forEach((item) => {
                this.formItemChange(item, this.data[item], true);
            })
        }
    }

    /**
     * 校验单个表单项
     * @param item 
     * @param value 
     */
    public validateItem(item: string, value: any) {
        // 做校验
        // 1.获取数值和规则
        const rule = this.rules[item];
        // 2.创建校验规则
        const schema = new Schema({ [item]: rule })
        // 校验返回Promise
        return schema.validate({ [item]: value },undefined,errors => {
            if (errors) {
                // 有错
                this.detailsModel[item].setError(errors[0].message);
            } else {
                this.detailsModel[item].setError('');
            }
        })
    }

    /**
     * 校验表单
     * 
     * @memberof ${srfclassname(ctrl.codeName)}
     */
    public validateForm(callback:Function) {
        let tasks: any;
        if (Object.keys(this.data).length > 0) {
            tasks = Object.keys(this.data).map((item) => {
                this.validateItem(item, this.data[item]);
            })
        }
        Promise.all(tasks)
            .then(() => callback(true))
            .catch(() => callback(false))
    }

    /**
     * 绘制内容
     *
     * @returns
     * @memberof ${srfclassname(ctrl.codeName)}
     */
    public render(): any {
        return <>
            ${P.getPartCode(item,'FORM').code}
        </>;
    }

    /**
     * 变更监测
     *
     * @protected
     * @memberof Main
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }

}