<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
import React, { PureComponent } from 'react';
import { Radio } from 'antd';

import './app-radio-group.less';

/**
 * 输入属性
 *
 * @export
 * @interface RadioProps
 */
export interface RadioProps {
    /**
     * 传入表单项值
     *
     * @type {any}
     * @memberof RadioProps
     */
    value?: any;

    /**
     * 代码表标识
     * 
     * @type {string}
     * @memberof RadioProps
     */
    tag?: string;

    /**
     * 是否禁用
     * 
     *  @type {boolean}
     * @memberof RadioProps
     */
    disabled: boolean;

    /**
     * 代码表
     * 
     *  @type {Object}
     * @memberof RadioProps
     */
    codelist?: Object;

    /**
     * 值变化事件
     *
     * @memberof RadioProps
     */
    onChange: (value: string) => void;
}

/**
 * AppRadioGroup
 *
 * @export
 * @class AppRadioGroup
 * @extends {PureComponent}
 */
export default class AppRadioGroup extends PureComponent<RadioProps> {

    /**
     * 当前代码表
     * 
     * @memberof AppRadioGroup
     */
    public curCodeList: Array<any> = [];

    /**
     * 绑定值
     */
    public currentValue: any = undefined;

    /**
     * 是否禁用
     */
    public curDisabled: boolean = false;

    constructor(props) {
        super(props);
        if (props.tag && props.codelist) {
            this.curCodeList = props.codelist[props.tag];
        }
        if (props.value) {
            this.currentValue = props.value;
        } else {
            this.currentValue = undefined;
        }
        if (props.disabled) {
            this.curDisabled = true;
        } else {
            this.curDisabled = false;
        }
    }

    /**
     * 在组件接收到一个新的 prop (或更新后)时被调用
     *
     * @memberof AppRadioGroup
     */
    public componentWillReceiveProps(nextProps: Readonly<RadioProps>, nextContext: any) {
        if (nextProps.value) {
            this.currentValue = nextProps.value;
        } else {
            this.currentValue = undefined;
        }
        if (nextProps.disabled) {
            this.curDisabled = true;
        } else {
            this.curDisabled = false;
        }
    }


    /**
     * 绘制内容
     *
     * @returns
     * @memberof AppRadioGroup
     */
    public render() {
        return (<Radio.Group value={this.currentValue} disabled={this.curDisabled} onChange={($event) => { this.handleChange($event) }}>
            {
                this.curCodeList.map((item: any) => {
                    return <Radio key={item.id} value={item.id}>{item.text}</Radio>
                })
            }
        </Radio.Group>
        );
    }

    /**
     * 值变化事件
     * 
     * @param $event
     * @memberof AppRadioGroup 
     */
    public handleChange($event) {
        this.props.onChange($event.target.value);
    }

    /**
     * 变更监测
     *
     * @protected
     * @memberof AppRadioGroup
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }

}