# iBiz表单React版

## 简介

iBiz表单React版是基于React和消费iBiz模型构建而成的表单Demo（下面简称表单），目前，该表单书写了我们表单常用的功能，如表单的栅格布局，flex布局，表单项动态显示，动态启用，动态空输入，表单值规则，表单的数据绑定，表单项的错误提示等功能。如果你的项目使用的前端框架是React,我们可以通过iBiz设计工具来设计我们的表单，然后把iBiz工具产生的成果物集成到我们的项目中，这样可以大大的减轻我们自己的工作压力。当然，由于业务场景的限制，如果有场景不满足，欢迎pr。

## 技术栈

**react+   less    +  antd   +   tinymce   +   axios    +   moment    +   rxjs**

## 项目运行

git clone  XXXX

cd XXXX

yarn  install

yarn  start

## 项目结构

把该iBiz表单集成到我们的项目中，也是非常方便的。了解项目集成之前，我们首先来看一下我们的表单目录结构，如下图1：

<div align = center><img src="superFormReact.assets/1570497166531.png" /></div>
<div align = center>图1</div>


```
├── node_modules                      项目的依赖文件
├── public                      
│   ├── assets                        项目的静态资源，包括项目中的图片，其他静态资源
│   ├── favicon.ico
│   ├── index.html                  
├── src  
│   ├──forms                             表单存放的地址
│   ├──ibizsys
│   │   ├──components             项目的全局基础组件
│   │   ├──form-detail                项目的表单模型类
│   │   ├──utils                             项目的工具类
│   ├──pages                               视图存放的地址
│   ├──styles                               项目的全局样式文件夹
│   ├──App.less                          根组件样式文件
│   ├──App.tsx                            根组件
│   ├──index.less                        项目的全局样式文件
│   ├──index.tsx                          项目的入口文件
│   ├──react-app-env.d.ts
│   ├──serviceWorker.ts             项目支持pwd的配置文件
│   ├──.gitignore
│   ├──config-overrides.js
│   ├──package.json                   项目的所有依赖文件
│   ├──tsconfig.json
│   ├──tslint.json           

```


## 项目

表单的项目集成该表单也是非常方便，通过以下几个步骤来完成表单的项目集成；

1.在package.json文件中添加依赖；

<div align = center><img src="superFormReact.assets/1570499047891.png" /></div>
<div align = center>图2</div>
如上图2，我们需要添加*antd*，*axios*，*moment*，*tinymce*，*rxjs*等组件，如果我们项目之前有引入的话，就不需要引入了，只需要引入我们之前没引入的；

2.复制静态资源，工具类，基础组件，设置入口文件；

<div align = center><img src="superFormReact.assets/1570499222398.png" /></div>
<div align = center>图3</div>
如上图3，我们需要把public里面的assets文件夹，src下的ibizsys文件夹直接copy到我们项目中，其中components是我们的表单引用的基础组件，form-detail是我们的表单模型类，utils是我们的工具类，所以我们需要在我们的项目中加入上图的代码。

<div align = center><img src="superFormReact.assets/1570499815047.png" /></div>
<div align = center>图4</div>
<div align = center><img src="superFormReact.assets/1570499882964.png" /></div>
<div align = center>图5</div>
如上图4和图5，我们项目的入口文件中修改的地方添加到我们的项目中；

3.完成集成，将iBiz平台的成果物copy到项目中，开始你的表演吧！

## 效果展示

<div align = center><img src="superFormReact.assets/1570500259460.png" /></div>
<div align = center>图6</div>
<div align = center><img src="superFormReact.assets/1570500296491.png" /></div>
<div align = center>图7</div>
<div align = center><img src="superFormReact.assets/1570500335486.png" /></div>
<div align = center>图8</div>
<div align = center><img src="superFormReact.assets/1570500379570.png" /></div>
<div align = center>图9</div>
<div align = center><img src="superFormReact.assets/1570500405334.png" /></div>
<div align = center>图10</div>
## 常见问题

Q1:其中文件上传和图片上传组件由于场景参数不足，上传路径，上传参数，导出参数及自定义参数都需要开发者重新定义。另外，文件上传和图片上传的数据存储格式未知，目前，返回的数据格式与蚂蚁金服提供的一致，若数据存储格式确定但不满足需求，需要开发者在数据输入（handleInputData）和数据抛出（handleOutData）的时候进行数据处理。

Q2:由于TypeScript校验可能会出现如下报错，需要去`tsconfig.json`的`compilerOptions`里添加对应校验规则

```
1.Parameter 'props' implicitly has an 'any' type.  TS7006 
#添加 "noImplicitAny": false,
2.'nextContext' is declared but its value is never read.  TS6133
#添加 "noUnusedParameters": false,
```

其他规则校验可以参考[TypeScript官方的schema](http://json.schemastore.org/tsconfig)