<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
import React, { PureComponent } from 'react';
<#if app.getAllPSAppViews()??>
<#list app.getAllPSAppViews() as view>
<#if view.getViewType() == "DEEDITVIEW">
import ${srfclassname(view.getCodeName())} from './pages/${srffilepath2(view.getPSAppModule().getCodeName())}/${srffilepath2(view.getCodeName())}/${srffilepath2(view.getCodeName())}';
</#if>
</#list>
</#if>
import './App.less';
import { Layout, Menu, Breadcrumb, Icon } from 'antd';
const { Header, Content, Footer, Sider } = Layout;
const { SubMenu } = Menu;


/**
 * App
 *
 * @export
 * @class App
 * @extends {PureComponent}
 */
export default class App extends PureComponent {

     /**
     * 当前页面
     */
    public currentPage: string = <#if app.getAllPSAppViews()??><#list app.getAllPSAppViews() as singleView><#if singleView_index == 0>"${singleView.getCodeName()}"</#if></#list></#if>;

    /**
     * 处理菜单点击
     * @param item 
     * @param key 
     * @param keyPath 
     * @param domEvent 
     */
    public handleMenuClick(item, key, keyPath, domEvent) {
        this.currentPage = key;
        this.tick();
    }

    /**
     * 获取当前视图
     */
    public getCurPage(): any {
        <#if app.getAllPSAppViews()??>
        <#list app.getAllPSAppViews() as singleView>
        if (Object.is(this.currentPage, "${singleView.getCodeName()}")) {
            return <${srfclassname(singleView.getCodeName())}/>;
        }
        </#list>
        </#if>
    }

    /**
     * 变更监测
     *
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }


    /**
     * 渲染视图
     *
     * @returns
     * @memberof App
     */
    public render() {
        return <div className="App">
            <Layout id="components-layout-demo-custom-trigger">
                <Sider trigger={null} collapsible style={{ minHeight: '100vh' }}>
                    <div className="logo"><img src="https://cdn.ibizlab.cn/super-form/logo.png" /></div>
                    <Menu theme="dark" mode="inline" defaultSelectedKeys={['<#if app.getAllPSAppViews()??><#list app.getAllPSAppViews() as singleView><#if singleView_index == 0></#if>"${singleView.getCodeName()}"</#list></#if>']} onClick={({ item, key, keyPath, domEvent }) => { this.handleMenuClick(item, key, keyPath, domEvent) }}>
                        <#if app.getAllPSAppViews()??>
                        <#list app.getAllPSAppViews() as singleView>
                        <Menu.Item key="${singleView.getCodeName()}">
                            <#if singleView_index % 3 == 0>
                            <Icon type="user" />
                            <#elseif singleView_index % 3 == 1>
                            <Icon type="video-camera" />
                            <#else>
                            <Icon type="upload" />
                            </#if>
                            <span>${singleView.getTitle()}</span>
                        </Menu.Item>
                        </#list>
                        </#if>
                    </Menu>
                </Sider>
                <Layout>
                    <Content
                        style={{
                            margin: '24px 16px',
                            padding: 24,
                            background: '#fff',
                            minHeight: 280,
                        }}>
                        {this.getCurPage()}
                    </Content>
                </Layout>
            </Layout>
        </div>;
    }

}